{- This module was generated from data in the Kate syntax
   highlighting file scheme.xml, version 1.12, by Dominik Haumann (dhdev@gmx.de) -}

module Text.Highlighting.Kate.Syntax.Scheme
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Scheme"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.scm;*.ss;*.scheme;*.guile"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Scheme" }
  context <- currentContext <|> (pushContext "Level0" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("Scheme",["Level0"])], synStLanguage = "Scheme", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Level0" -> return ()
    "Default" -> return ()
    "MultiLineComment" -> return ()
    "SpecialNumber" -> (popContext) >> pEndLine
    "String" -> return ()
    "function_decl" -> return ()
    "Level1" -> return ()
    "Level2" -> return ()
    "Level3" -> return ()
    "Level4" -> return ()
    "Level5" -> return ()
    "Level6" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_operators = Set.fromList $ words $ "<= < = => >= > - / *,* *) +"
list_characters = Set.fromList $ words $ "#\\nul #\\soh #\\stx #\\etx #\\eot #\\enq #\\ack #\\bel #\\bs #\\ht #\\nl #\\vt #\\np #\\cr #\\so #\\si #\\dle #\\dc1 #\\dc2 #\\dc3 #\\dc4 #\\nak #\\syn #\\etb #\\can #\\em #\\sub #\\esc #\\fs #\\gs #\\rs #\\us #\\space #\\sp #\\newline #\\nl #\\tab #\\ht #\\backspace #\\bs #\\return #\\cr #\\page #\\np #\\null #\\nul"
list_defines = Set.fromList $ words $ "define define* define-accessor define-class defined? define-generic define-macro define-method define-module define-private define-public define*-public define-reader-ctor define-syntax define-syntax-macro defmacro defmacro* defmacro*-public"
list_keywords = Set.fromList $ words $ "abs acos and angle append applymap asin assoc assq assv atan begin boolean? break caaaar caaadr caaar caadar caaddr caadr caar cadaar cadadr cadar caddar cadddr caddr cadr call/cc call-with-current-continuation call-with-input-file call-with-output-file call-with-values car case catch cdaaar cdaadr cdaar cdadar cdaddr cdadr cdar cddaar cddadr cddar cdddar cddddr cdddr cddr cdr ceiling char-alphabetic? char-ci>=? char-ci>? char-ci=? char-ci<=? char-downcase char->integer char>=? char>? char=? char? char-lower-case? char<?c char<=? char-numeric? char-ready? char-upcase char-upper-case? char-whitespace? close-input-port close-output-port complex? cond cons continue cos current-input-port current-output-port denominator display do dynamic-wind else eof-object? eq? equal? eqv? eval even? exact->inexact exact? exp expt floor force for-each gcd har-ci<? if imag-part inexact->exact inexact? input-port? integer->char integer? interaction-environment lambda lcm length let let* letrec letrec-syntax let-syntax list->string list list? list-ref list-tail load log magnitude make-polar make-rectangular make-string make-vector max member memq memv min modulo negative? newline not null-environment null? number? number->string numerator odd? open-input-file open-output-file or output-port? pair? peek-char port? positive? procedure? quotient rational? rationalize read-char read real? real-part remainder reverse round scheme-report-environment set-car! set-cdr! sin sqrt string-append string-ci>=? string-ci>? string-ci=? string-ci<=? string-ci<? string-copy string-fill! string>=? string>? string->list string->number string->symbol string=? string string? string-length string<=? string<? string-ref string-set! substring symbol->string symbol? syntax-rules tan transcript-off transcript-on truncate values vector-fill! vector->listlist->vector vector vector? vector-length vector-ref vector-set! while with-input-from-file with-output-to-file write-char write zero?"

regex_'3b'2b'5cs'2aBEGIN'2e'2a'24 = compileRegex ";+\\s*BEGIN.*$"
regex_'3b'2b'5cs'2aEND'2e'2a'24 = compileRegex ";+\\s*END.*$"
regex_'3b'2e'2a'24 = compileRegex ";.*$"
regex_'23'5c'5c'2e = compileRegex "#\\\\."
regex_'23'5bbodxei'5d = compileRegex "#[bodxei]"
regex_'23'5btf'5d = compileRegex "#[tf]"
regex_'21'23'5cs'2a'24 = compileRegex "!#\\s*$"
regex_'5cd'2a'28'5c'2e'5cd'2b'29'3f = compileRegex "\\d*(\\.\\d+)?"
regex_'5cs'2a'5bA'2dZa'2dz0'2d9'2d'2b'5c'3c'5c'3e'2f'2f'5c'2a'5d'2a'5cs'2a = compileRegex "\\s*[A-Za-z0-9-+\\<\\>//\\*]*\\s*"

defaultAttributes = [("Level0",NormalTok),("Default",NormalTok),("MultiLineComment",CommentTok),("SpecialNumber",NormalTok),("String",StringTok),("function_decl",FunctionTok),("Level1",NormalTok),("Level2",NormalTok),("Level3",NormalTok),("Level4",NormalTok),("Level5",NormalTok),("Level6",NormalTok)]

parseRules "Level0" =
  (((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext "Level1")
   <|>
   ((parseRules "Default")))

parseRules "Default" =
  (((pRegExpr regex_'3b'2b'5cs'2aBEGIN'2e'2a'24 >>= withAttribute RegionMarkerTok))
   <|>
   ((pRegExpr regex_'3b'2b'5cs'2aEND'2e'2a'24 >>= withAttribute RegionMarkerTok))
   <|>
   ((pRegExpr regex_'3b'2e'2a'24 >>= withAttribute CommentTok))
   <|>
   ((pDetect2Chars False '#' '!' >>= withAttribute CommentTok) >>~ pushContext "MultiLineComment")
   <|>
   ((pKeyword " \n\t.(),%&;[]^{|}~" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.(),%&;[]^{|}~" list_operators >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.(),%&;[]^{|}~" list_defines >>= withAttribute KeywordTok) >>~ pushContext "function_decl")
   <|>
   ((pKeyword " \n\t.(),%&;[]^{|}~" list_characters >>= withAttribute CharTok))
   <|>
   ((pRegExpr regex_'23'5c'5c'2e >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "String")
   <|>
   ((pRegExpr regex_'23'5bbodxei'5d >>= withAttribute CharTok) >>~ pushContext "SpecialNumber")
   <|>
   ((pRegExpr regex_'23'5btf'5d >>= withAttribute DecValTok))
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext "Level1"))

parseRules "MultiLineComment" =
  ((pColumn 0 >> pRegExpr regex_'21'23'5cs'2a'24 >>= withAttribute CommentTok) >>~ (popContext))

parseRules "SpecialNumber" =
  (((pRegExpr regex_'5cd'2a'28'5c'2e'5cd'2b'29'3f >>= withAttribute DecValTok) >>~ (popContext))
   <|>
   (currentContext >>= parseRules))

parseRules "String" =
  (((pKeyword " \n\t.(),%&;[]^{|}~" list_characters >>= withAttribute CharTok))
   <|>
   ((pRegExpr regex_'23'5c'5c'2e >>= withAttribute CharTok))
   <|>
   ((pDetect2Chars False '\\' '"' >>= withAttribute CharTok))
   <|>
   ((pDetect2Chars False '\\' '\\' >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "function_decl" =
  ((pRegExpr regex_'5cs'2a'5bA'2dZa'2dz0'2d9'2d'2b'5c'3c'5c'3e'2f'2f'5c'2a'5d'2a'5cs'2a >>= withAttribute FunctionTok) >>~ (popContext))

parseRules "Level1" =
  (((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext "Level2")
   <|>
   ((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((parseRules "Default")))

parseRules "Level2" =
  (((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext "Level3")
   <|>
   ((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((parseRules "Default")))

parseRules "Level3" =
  (((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext "Level4")
   <|>
   ((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((parseRules "Default")))

parseRules "Level4" =
  (((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext "Level5")
   <|>
   ((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((parseRules "Default")))

parseRules "Level5" =
  (((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext "Level6")
   <|>
   ((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((parseRules "Default")))

parseRules "Level6" =
  (((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext "Level1")
   <|>
   ((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((parseRules "Default")))

parseRules "" = parseRules "Level0"

parseRules x = fail $ "Unknown context" ++ x
