{- This module was generated from data in the Kate syntax
   highlighting file modula-2.xml, version 1.03, by  -}

module Text.Highlighting.Kate.Syntax.Modula2
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Modula-2"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.mod;*.def;*.mi;*.md"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Modula-2" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("Modula-2",["Normal"])], synStLanguage = "Modula-2", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Normal" -> return ()
    "String1" -> (popContext) >> pEndLine
    "String2" -> (popContext) >> pEndLine
    "Comment2" -> return ()
    "Comment3" -> (popContext) >> pEndLine
    "Prep1" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_directives = Set.fromList $ words $ "ASSEMBLER ALLOCATE DEALLOCATE SIZE Write WriteString WriteCard WriteLn WriteBf WriteInt WriteReal WriteLongReal Read ReadString ReadCard ReadInt ReadReal ReadLongReal Open Close OpenInput OpenOutput Accessible Erase EOF Done EmptyString Assign Append Length StrEq Copy Concat pos Delete Insert compare CAPS PutBf GetArgs GetEnv ResetClock UserTime SystemTime GetChar GetInt GetCard GetString GetReal GetLongReal PutChar PutInt PutCard PutString PutReal PutLongReal PutLn"
list_keywords = Set.fromList $ words $ "AND ARRAY ASM BEGIN CASE CONST DIV DO ELSE ELSIF END FOR IF IMPLEMENTATION IN SET INCL EXCL ABS BITSET CAP CHR DEC HALT HIGH INC MAX MIN ODD ORD PROC TRUNC VAL MOD NIL NOT OF OR PROCEDURE MODULE DEFINITION RECORD REPEAT THEN TO TYPE UNTIL LOOP VAR WHILE WITH EXIT FALSE TRUE BY FROM IMPORT EXPORT QUALIFIED RETURN NEWPROCESS TRANSFER IOTRANSFER FOREIGN"
list_types = Set.fromList $ words $ "INTEGER CARDINAL SHORTINT SHORTCARD LONGINT LONGREAL CHAR BOOLEAN POINTER ADDRESS ADR REAL File"


defaultAttributes = [("Normal",NormalTok),("String1",StringTok),("String2",StringTok),("Comment2",CommentTok),("Comment3",CommentTok),("Prep1",OtherTok)]

parseRules "Normal" =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_directives >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pFloat >>= withAttribute DecValTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "String1")
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext "String2")
   <|>
   ((pString False "(*$" >>= withAttribute OtherTok) >>~ pushContext "Prep1")
   <|>
   ((pDetect2Chars False '(' '*' >>= withAttribute CommentTok) >>~ pushContext "Comment2"))

parseRules "String1" =
  ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))

parseRules "String2" =
  ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))

parseRules "Comment2" =
  ((pDetect2Chars False '*' ')' >>= withAttribute CommentTok) >>~ (popContext))

parseRules "Comment3" =
  pzero

parseRules "Prep1" =
  ((pString False "$*)" >>= withAttribute OtherTok) >>~ pushContext "Prep1")

parseRules "" = parseRules "Normal"

parseRules x = fail $ "Unknown context" ++ x
