{- This module was generated from data in the Kate syntax
   highlighting file changelog.xml, version 1.04, by Dominik Haumann (dhdev@gmx.de) -}

module Text.Highlighting.Kate.Syntax.Changelog
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)

-- | Full name of language.
syntaxName :: String
syntaxName = "ChangeLog"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "ChangeLog"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "ChangeLog" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("ChangeLog",["Normal"])], synStLanguage = "ChangeLog", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Normal" -> return ()
    "line" -> (popContext) >> pEndLine
    "entry" -> (popContext) >> pEndLine
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))


regex_'5cd'5cd'5cd'5cd'5cs'2a'2d'5cs'2a'5cd'5cd'5cs'2a'2d'5cs'2a'5cd'5cd'5cs'2a = compileRegex "\\d\\d\\d\\d\\s*-\\s*\\d\\d\\s*-\\s*\\d\\d\\s*"
regex_'28'5cw'5cs'2a'29'2b = compileRegex "(\\w\\s*)+"
regex_'3c'2e'2a'3e'5cs'2a'24 = compileRegex "<.*>\\s*$"
regex_'2e'2a'3a = compileRegex ".*:"

defaultAttributes = [("Normal",NormalTok),("line",NormalTok),("entry",NormalTok)]

parseRules "Normal" =
  (((pFirstNonSpace >> pDetectChar False '*' >>= withAttribute DecValTok) >>~ pushContext "entry")
   <|>
   ((pColumn 0 >> pRegExpr regex_'5cd'5cd'5cd'5cd'5cs'2a'2d'5cs'2a'5cd'5cd'5cs'2a'2d'5cs'2a'5cd'5cd'5cs'2a >>= withAttribute DataTypeTok) >>~ pushContext "line"))

parseRules "line" =
  (((pRegExpr regex_'28'5cw'5cs'2a'29'2b >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'3c'2e'2a'3e'5cs'2a'24 >>= withAttribute OtherTok) >>~ (popContext)))

parseRules "entry" =
  ((pRegExpr regex_'2e'2a'3a >>= withAttribute DecValTok) >>~ (popContext))

parseRules "" = parseRules "Normal"

parseRules x = fail $ "Unknown context" ++ x
