{- This module was generated from data in the Kate syntax highlighting file objectivecpp.xml, version 1.01,
   by  Gennady Telegin (gepo@lvk.cs.msu.su -}

module Text.Highlighting.Kate.Syntax.Objectivecpp ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Doxygen
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "Objective-C++"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.mm;*.M;*.h"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Objective-C++" }
  context <- currentContext <|> (pushContext "Default" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("Objective-C++",["Default"])], synStLanguage = "Objective-C++", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Default" -> return () >> pHandleEndLine
    "String" -> (popContext) >> pEndLine
    "SingleLineComment" -> (popContext) >> pEndLine
    "MultiLineComment" -> return () >> pHandleEndLine
    "Preprocessor" -> pushContext "Default" >> pHandleEndLine
    "MultiLineCommentPrep" -> return () >> pHandleEndLine
    "Region Marker" -> (popContext) >> pEndLine
    "Commentar 1" -> (popContext) >> pEndLine
    "Commentar 2" -> return () >> pHandleEndLine
    "Preprocessor" -> (popContext) >> pEndLine
    "Define" -> (popContext) >> pEndLine
    "Outscoped" -> return () >> pHandleEndLine
    "Outscoped intern" -> return () >> pHandleEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Keyword","kw"),("Extensions","kw"),("Data Type","dt"),("Decimal","dv"),("Octal","bn"),("Hex","bn"),("Float","fl"),("Char","ch"),("String","st"),("String Char","ch"),("Comment","co"),("Preprocessor","ot"),("Prep. Lib","ot"),("Region Marker","re")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "break case continue default do else enum extern for goto if return sizeof struct switch typedef union while @class @defs @encode @end @implementation @interface @private @protected @protocol @public @selector self super asm catch class const_cast delete dynamic_cast explicit export false friend inline namespace new operator private protected public qobject_cast reinterpret_cast static_cast template this throw true try typeid type_info typename using virtual and and_eq bad_cast bad_typeid bitand bitor compl not not_eq or or_eq xor xor_eq"
list_extensions = Set.fromList $ words $ "K_DCOP SLOT SIGNAL Q_CLASSINFO Q_ENUMS Q_EXPORT Q_OBJECT Q_OVERRIDE Q_PROPERTY Q_SETS Q_SIGNALS Q_SLOTS Q_FOREACH Q_DECLARE_FLAGS Q_INIT_RESOURCE Q_CLEANUP_RESOURCE Q_GLOBAL_STATIC Q_GLOBAL_STATIC_WITH_ARGS Q_DECLARE_INTERFACE Q_DECLARE_TYPEINFO Q_DECLARE_SHARED Q_DECLARE_FLAGS Q_DECLARE_OPERATORS_FOR_FLAGS Q_FOREVER Q_DECLARE_PRIVATE Q_DECLARE_PUBLIC Q_D Q_Q Q_DISABLE_COPY Q_INTERFACES Q_FLAGS Q_SCRIPTABLE Q_INVOKABLE Q_GADGET Q_ARG Q_RETURN_ARG Q_ASSERT Q_ASSERT_X TRUE FALSE connect disconnect emit signals slots foreach forever"
list_types = Set.fromList $ words $ "auto char const double float int long register short signed static unsigned void volatile bool mutable uchar uint int8_t int16_t int32_t int64_t uint8_t uint16_t uint32_t uint64_t wchar_t"

regex_'23'5cs'2aif'5cs'2b0 = compileRegex "#\\s*if\\s+0"
regex_'23 = compileRegex "#"
regex_define'2e'2a'28'28'3f'3d'5c'5c'29'29 = compileRegex "define.*((?=\\\\))"
regex_define'2e'2a = compileRegex "define.*"
regex_'23'5cs'2aif = compileRegex "#\\s*if"
regex_'23'5cs'2a'28endif'7celse'7celif'29 = compileRegex "#\\s*(endif|else|elif)"
regex_'23'5cs'2aendif = compileRegex "#\\s*endif"

defaultAttributes = [("Default","Normal Text"),("String","String"),("SingleLineComment","Comment"),("MultiLineComment","Comment"),("Preprocessor","Preprocessor"),("MultiLineCommentPrep","Comment"),("Region Marker","Region Marker"),("Commentar 1","Comment"),("Commentar 2","Comment"),("Preprocessor","Preprocessor"),("Define","Preprocessor"),("Outscoped","Comment"),("Outscoped intern","Comment")]

parseRules "Default" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Normal Text"))
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif'5cs'2b0 >>= withAttribute "Preprocessor") >>~ pushContext "Outscoped")
                        <|>
                        ((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute "Preprocessor") >>~ pushContext "Preprocessor")
                        <|>
                        ((pFirstNonSpace >> pString False "//BEGIN" >>= withAttribute "Region Marker") >>~ pushContext "Region Marker")
                        <|>
                        ((pFirstNonSpace >> pString False "//END" >>= withAttribute "Region Marker") >>~ pushContext "Region Marker")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute "Keyword"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute "Data Type"))
                        <|>
                        ((pDetectChar False '{' >>= withAttribute "Symbol"))
                        <|>
                        ((pDetectChar False '}' >>= withAttribute "Symbol"))
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Normal Text"))
                        <|>
                        (withChildren (pFloat >>= withAttribute "Float") ((pAnyChar "fF" >>= withAttribute "Float")))
                        <|>
                        ((pHlCOct >>= withAttribute "Octal"))
                        <|>
                        ((pHlCHex >>= withAttribute "Hex"))
                        <|>
                        (withChildren (pInt >>= withAttribute "Decimal") (((pString False "ULL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LUL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LLU" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "UL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LU" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "U" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "L" >>= withAttribute "Decimal"))))
                        <|>
                        ((pHlCChar >>= withAttribute "Char"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "String")
                        <|>
                        ((pDetect2Chars False '/' '/' >>= withAttribute "Comment") >>~ pushContext "SingleLineComment")
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Comment") >>~ pushContext "MultiLineComment")
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'23 >>= withAttribute "Preprocessor") >>~ pushContext "Preprocessor")
                        <|>
                        ((pDetect2Chars False '@' '"' >>= withAttribute "String") >>~ pushContext "String")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_extensions >>= withAttribute "Extensions"))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression))
                        <|>
                        ((pDetect2Chars False '/' '/' >>= withAttribute "Comment") >>~ pushContext "Commentar 1")
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Comment") >>~ pushContext "Commentar 2")
                        <|>
                        ((pDetectChar False '{' >>= withAttribute "Symbol"))
                        <|>
                        ((pDetectChar False '}' >>= withAttribute "Symbol"))
                        <|>
                        ((pAnyChar ":!%&()+,-/.*<=>?[]{|}~^;" >>= withAttribute "Symbol")))
     return (attr, result)

parseRules "String" = 
  do (attr, result) <- (((pLineContinue >>= withAttribute "String"))
                        <|>
                        ((pHlCStringChar >>= withAttribute "String Char"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext)))
     return (attr, result)

parseRules "SingleLineComment" = 
  pzero

parseRules "MultiLineComment" = 
  do (attr, result) <- ((pDetect2Chars False '*' '/' >>= withAttribute "Comment") >>~ (popContext))
     return (attr, result)

parseRules "Preprocessor" = 
  do (attr, result) <- (((pLineContinue >>= withAttribute "Preprocessor"))
                        <|>
                        ((pRangeDetect '"' '"' >>= withAttribute "Prep. Lib"))
                        <|>
                        ((pRangeDetect '<' '>' >>= withAttribute "Prep. Lib"))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression))
                        <|>
                        ((pDetect2Chars False '/' '/' >>= withAttribute "Comment") >>~ pushContext "SingleLineComment")
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Comment") >>~ pushContext "MultiLineCommentPrep"))
     return (attr, result)

parseRules "MultiLineCommentPrep" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Comment"))
                        <|>
                        ((pDetect2Chars False '*' '/' >>= withAttribute "Comment") >>~ (popContext >> popContext))
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Comment")))
     return (attr, result)

parseRules "Region Marker" = 
  pzero

parseRules "Commentar 1" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Comment"))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Alert.parseExpression))
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Comment")))
     return (attr, result)

parseRules "Commentar 2" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Comment"))
                        <|>
                        ((pDetect2Chars False '*' '/' >>= withAttribute "Comment") >>~ (popContext))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Alert.parseExpression))
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Comment")))
     return (attr, result)

parseRules "Preprocessor" = 
  do (attr, result) <- (((pLineContinue >>= withAttribute "Preprocessor"))
                        <|>
                        ((pRegExpr regex_define'2e'2a'28'28'3f'3d'5c'5c'29'29 >>= withAttribute "Preprocessor") >>~ pushContext "Define")
                        <|>
                        ((pRegExpr regex_define'2e'2a >>= withAttribute "Preprocessor"))
                        <|>
                        ((pRangeDetect '"' '"' >>= withAttribute "Prep. Lib"))
                        <|>
                        ((pRangeDetect '<' '>' >>= withAttribute "Prep. Lib"))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression))
                        <|>
                        ((pDetect2Chars False '/' '/' >>= withAttribute "Comment") >>~ pushContext "Commentar 1")
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Comment") >>~ pushContext "MultiLineCommentPrep"))
     return (attr, result)

parseRules "Define" = 
  do (attr, result) <- ((pLineContinue >>= withAttribute "Preprocessor"))
     return (attr, result)

parseRules "Outscoped" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Comment"))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Alert.parseExpression))
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Comment"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "String")
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression))
                        <|>
                        ((pDetect2Chars False '/' '/' >>= withAttribute "Comment") >>~ pushContext "Commentar 1")
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Comment") >>~ pushContext "Commentar 2")
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif >>= withAttribute "Comment") >>~ pushContext "Outscoped intern")
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2a'28endif'7celse'7celif'29 >>= withAttribute "Preprocessor") >>~ (popContext)))
     return (attr, result)

parseRules "Outscoped intern" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Comment"))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Alert.parseExpression))
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Comment"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "String")
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression))
                        <|>
                        ((pDetect2Chars False '/' '/' >>= withAttribute "Comment") >>~ pushContext "Commentar 1")
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Comment") >>~ pushContext "Commentar 2")
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif >>= withAttribute "Comment") >>~ pushContext "Outscoped intern")
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aendif >>= withAttribute "Comment") >>~ (popContext)))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
