{- This module was generated from data in the Kate syntax highlighting file m3u.xml, version 1.10,
   by  Jan Janssen (medhefgo@web.de) -}

module Text.Highlighting.Kate.Syntax.M3u ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

-- | Full name of language.
syntaxName :: String
syntaxName = "M3U"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.m3u"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "M3U" }
  context <- currentContext <|> (pushContext "M3U" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("M3U",["M3U"])], synStLanguage = "M3U", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "M3U" -> return () >> pHandleEndLine
    "FindEXTINF" -> return () >> pHandleEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("M3USpec","kw"),("Comment","co"),("EXTINF","ot"),("Lenght","dv"),("Descr","st")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))


regex_'23'2e'2a'24 = compileRegex "#.*$"
regex_'3a'5cd'2b = compileRegex ":\\d+"
regex_'2c'2e'2a'24 = compileRegex ",.*$"

defaultAttributes = [("M3U","Normal Text"),("FindEXTINF","Normal Text")]

parseRules "M3U" = 
  do (attr, result) <- (((pColumn 0 >> pString False "#EXTM3U" >>= withAttribute "M3USpec") >>~ (popContext))
                        <|>
                        ((pColumn 0 >> pString False "#EXTINF" >>= withAttribute "EXTINF") >>~ pushContext "FindEXTINF")
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'2e'2a'24 >>= withAttribute "Comment")))
     return (attr, result)

parseRules "FindEXTINF" = 
  do (attr, result) <- (((pRegExpr regex_'3a'5cd'2b >>= withAttribute "Lenght"))
                        <|>
                        ((pRegExpr regex_'2c'2e'2a'24 >>= withAttribute "Descr") >>~ (popContext)))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
