{- This module was generated from data in the Kate syntax highlighting file ilerpg.xml, version 1.05,
   by   -}

module Text.Highlighting.Kate.Syntax.Ilerpg ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "ILERPG"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "QRPG*.*;qrpg*.*"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "ILERPG" }
  context <- currentContext <|> (pushContext "Default" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("ILERPG",["Default"])], synStLanguage = "ILERPG", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = False, synStKeywordCaseSensitive = False, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Default" -> return () >> pHandleEndLine
    "CControlLevel" -> (popContext) >> pEndLine
    "CIndicators" -> (popContext >> popContext) >> pEndLine
    "CFactor1" -> (popContext >> popContext >> popContext) >> pEndLine
    "FindOC" -> (popContext >> popContext >> popContext >> popContext) >> pEndLine
    "NonEvalOC2" -> pushContext "Default" >> pHandleEndLine
    "NonEvalOC3" -> pushContext "Default" >> pHandleEndLine
    "NonEvalOC4" -> pushContext "Default" >> pHandleEndLine
    "NonEvalOC5" -> pushContext "Default" >> pHandleEndLine
    "NonEvalOC6" -> pushContext "Default" >> pHandleEndLine
    "NonEvalOC7" -> pushContext "Default" >> pHandleEndLine
    "CFactor2" -> pushContext "Default" >> pHandleEndLine
    "EvalOC2" -> pushContext "Default" >> pHandleEndLine
    "EvalOC3" -> pushContext "Default" >> pHandleEndLine
    "EvalOC4" -> pushContext "Default" >> pHandleEndLine
    "EvalOC5" -> pushContext "Default" >> pHandleEndLine
    "EvalOC6" -> pushContext "Default" >> pHandleEndLine
    "EvalOC8" -> pushContext "Default" >> pHandleEndLine
    "CExFactor2" -> pushContext "Default" >> pHandleEndLine
    "EvalOCCont" -> return () >> pHandleEndLine
    "Comments" -> (popContext) >> pEndLine
    "StringConstants" -> (popContext) >> pEndLine
    "Directives" -> pushContext "Default" >> pHandleEndLine
    "Directives2" -> pushContext "Default" >> pHandleEndLine
    "Directives3" -> pushContext "Default" >> pHandleEndLine
    "Free" -> return () >> pHandleEndLine
    "Exec" -> return () >> pHandleEndLine
    "Biffs" -> (popContext) >> pEndLine
    "CommonCode" -> return () >> pHandleEndLine
    "Indicators" -> return () >> pHandleEndLine
    "ReservedWords" -> return () >> pHandleEndLine
    "AnyCode" -> (popContext) >> pEndLine
    "D" -> (popContext) >> pEndLine
    "P" -> (popContext) >> pEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Alert","al"),("Keyword","kw"),("Biff","kw"),("RegExpr","bn"),("Decimal","dv"),("Float","fl"),("Octal","bn"),("Hex","bn"),("Float","fl"),("Base-N","bn"),("Float","fl"),("Char","ch"),("Comment","co"),("DivideComment","co"),("Directive","ot")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_dkeywords = Set.fromList $ words $ "extproc extpgm opdesc datfmt dim likeds likerec like procptr timfmt varying ascend const noopt options value qualified inz based"
list_pkeywords = Set.fromList $ words $ "datfmt dim like likeds likerec procptr timfmt"
list_directives = Set.fromList $ words $ "free end-free title eject space copy include define undefine if else exec end-exec elseif endif eof"
list_directives2 = Set.fromList $ words $ "not defined"
list_directives3 = Set.fromList $ words $ "defined"
list_biffs = Set.fromList $ words $ "abs addr alloc bitand bitnot bitor bitxor char check checkr date days dec dech decpos diff div editc editflt editw elem eof equal error fields float found graph hours int inth kds len lookup lookuplt lookuple lookupgt lookupge minutes months mseconds nullind occur open paddr parms realloc rem replace scan seconds shtdn size sqrt status str subarr subdt subst this time timestamp tlookup tlookuplt tlookuple tlookupgt tlookupge trim triml trimr ucs2 uns unsh xfoot xlate years"
list_evalopcodes2 = Set.fromList $ words $ "if"
list_evalopcodes3 = Set.fromList $ words $ "dow dou for"
list_evalopcodes4 = Set.fromList $ words $ "when eval"
list_evalopcodes5 = Set.fromList $ words $ "evalr"
list_evalopcodes6 = Set.fromList $ words $ "return"
list_evalopcodes8 = Set.fromList $ words $ "on-error"
list_nonevalopcodes2 = Set.fromList $ words $ "do in or"
list_nonevalopcodes3 = Set.fromList $ words $ "acq add and cab cas cat div dou end mvr out rel sub tag"
list_nonevalopcodes4 = Set.fromList $ words $ "call comp dump else exsr feod goto ifgt iflt ifeq ifne ifge ifle iter kfld move mult next open orgt orlt oreq orne orge orle parm post read scan sqrt test time"
list_nonevalopcodes5 = Set.fromList $ words $ "alloc andgt andlt andeq andne andge andle begsr biton cabgt cablt cabeq cabne cabge cable callb callp casgt caslt caseq casne casge casle chain check clear close check clear close dowgt dowlt doweq downe dowge dowle dougt doult doueq doune douge doule dsply endcs enddo endif endsl endsr exfmt force klist leave mhhzo mhlzo mlhzo mllzo movea movel occur other plist readc reade readp reset rolbk setgt setll seton shtdn sorta subst testb testn testz write xfoot xlate"
list_nonevalopcodes6 = Set.fromList $ words $ "adddur bitoff checkr commit define delete except extrct lookup readpe return select setoff subdur unlock update whengt whenlt wheneq whennr whenge whenle"
list_nonevalopcodes7 = Set.fromList $ words $ "dealloc realloc"
list_freeopcodes = Set.fromList $ words $ "acq begsr callp chain clear close commit dealloc delete dou dow dsply dump else elseif enddo endfor endif endmon endsl endsr eval evalr except exfmt exsr feod for force if in iter leave leavesr monitor next on-error open other out post read readc reade readp readpe rel reset return rolbk select setgt setll sorta test unlock update when write"

regex_'5bPpOoIiHhFfDdCc_'5d'3f'5c'2a = compileRegex "[PpOoIiHhFfDdCc ]?\\*"
regex_'5bPpOoIiHhFfDdCc_'5d'3f'2f = compileRegex "[PpOoIiHhFfDdCc ]?/"
regex_'5c_'7b2'7d = compileRegex "\\ {2}"
regex_'5bL'7cl'5d'5b0'2d9'5d = compileRegex "[L|l][0-9]"
regex_'5bO'7co'7cL'7cl'7cS'7cs'5d'5bR'7cr'5d = compileRegex "[O|o|L|l|S|s][R|r]"
regex_'5bA'7ca'5d'5bN'7cn'5d = compileRegex "[A|a][N|n]"
regex_'5bL'7cl'7cS'7cs'5d'5bR'7cr'5d = compileRegex "[L|l|S|s][R|r]"
regex_'2e'7b2'7d = compileRegex ".{2}"
regex_'5c_'7b3'7d = compileRegex "\\ {3}"
regex_'5b'5c_'7cN'7cn'5d'5b0'2d9'5d'7b2'7d = compileRegex "[\\ |N|n][0-9]{2}"
regex_'5b'5c_'7cN'7cn'5d'5bK'7ck'5d'5bA'2dN'7cp'2dy'5d = compileRegex "[\\ |N|n][K|k][A-N|p-y]"
regex_'5b'5c_'7cN'7cn'5d'5bK'7ck'5d'5bP'2dY'7cp'2dy'5d'7d = compileRegex "[\\ |N|n][K|k][P-Y|p-y]}"
regex_'5b'5c_'7cN'7cn'5d'5bL'7cl'5d'5b1'2d9'5d = compileRegex "[\\ |N|n][L|l][1-9]"
regex_'5b'5c_'7cN'7cn'5d'5bL'7cl'7cM'7cm'5d'5bR'7cr'5d = compileRegex "[\\ |N|n][L|l|M|m][R|r]"
regex_'5b'5c_'7cN'7cn'5d'5bR'7cr'5d'5bT'7ct'5d = compileRegex "[\\ |N|n][R|r][T|t]"
regex_'5b'5c_'7cN'7cn'5d'5bU'7cu'5d'5b1'2d8'5d = compileRegex "[\\ |N|n][U|u][1-8]"
regex_'5b'5c_'7cN'7cn'5d'5bO'7co'5d'5bA'2dG'7ca'2dg'5d = compileRegex "[\\ |N|n][O|o][A-G|a-g]"
regex_'5b'5c_'7cN'7cn'5d'5bO'7co'5d'5bV'7cv'5d = compileRegex "[\\ |N|n][O|o][V|v]"
regex_'5b'5c_'7cN'7cn'5d'5bH'7ch'5d'5b1'2d9'5d = compileRegex "[\\ |N|n][H|h][1-9]"
regex_'2e'7b3'7d = compileRegex ".{3}"
regex_'2e'7b14'7d = compileRegex ".{14}"
regex_'5bZ'7cz'5d'2d'28'5bA'7ca'5d'5bD'7cd'5d'7b2'7d'7c'5bS'7cs'5d'5bU'7cu'5d'5bB'7cb'5d'29 = compileRegex "[Z|z]-([A|a][D|d]{2}|[S|s][U|u][B|b])"
regex_'5bO'7co'5d'5bN'7cn'5d'2d'28'5bE'7ce'5d'5bR'7cr'5d'7b2'7d'7c'5bO'7co'5d'5bR'7cr'5d'29 = compileRegex "[O|o][N|n]-([E|e][R|r]{2}|[O|o][R|r])"
regex_'5c_'7b10'7d = compileRegex "\\ {10}"
regex_'2e'7b10'7d = compileRegex ".{10}"
regex_'5c_'7b8'7d = compileRegex "\\ {8}"
regex_'5c_'7b7'7d = compileRegex "\\ {7}"
regex_'5c_'7b6'7d = compileRegex "\\ {6}"
regex_'5c_'7b5'7d = compileRegex "\\ {5}"
regex_'5c_'7b4'7d = compileRegex "\\ {4}"
regex_'5c'28'2a'28FIXME'7cTODO'29'5c'29'2a = compileRegex "\\(*(FIXME|TODO)\\)*"
regex_'5c'28'2a'28NOTE'3a'29'5c'29'2a = compileRegex "\\(*(NOTE:)\\)*"
regex_'2d'7c'3d = compileRegex "-|="
regex_'5bF'7cf'5d'5bR'7cr'5d'5bE'7ce'5d'5bE'7ce'5d = compileRegex "[F|f][R|r][E|e][E|e]"
regex_'5bE'7ce'5d'5bX'7cx'5d'5bE'7ce'5d'5bC'7cc'5d = compileRegex "[E|e][X|x][E|e][C|c]"
regex_'5bPOIHFDC_'5d'3f'2f'5bE'7ce'5d'5bN'7cn'5d'5bD'7cd'5d'2d'5bF'7cf'5d'5bR'7cr'5d'5bE'7ce'5d'5bE'7ce'5d = compileRegex "[POIHFDC ]?/[E|e][N|n][D|d]-[F|f][R|r][E|e][E|e]"
regex_'2f'2f = compileRegex "//"
regex_'5bPOIHFDC_'5d'3f'2f'5bE'7ce'5d'5bN'7cn'5d'5bD'7cd'5d'2d'5bE'7ce'5d'5bX'7cx'5d'5bE'7ce'5d'5bC'7cc'5d = compileRegex "[POIHFDC ]?/[E|e][N|n][D|d]-[E|e][X|x][E|e][C|c]"
regex_'2e = compileRegex "."
regex_'5bXx'5d'27'5b0'2d9a'2dfA'2dF'5d'7b2'2c'7d'27 = compileRegex "[Xx]'[0-9a-fA-F]{2,}'"
regex_'5c'2a'5bI'7ci'5d'5bN'7cn'5d'5c'28'3f'5b0'2d9'5d'5b0'2d9'5d'5c'29'3f = compileRegex "\\*[I|i][N|n]\\(?[0-9][0-9]\\)?"
regex_'5c'2a'5bI'7ci'5d'5bN'7cn'5d'5c'28'3f1'5bP'7cp'5d'5c'29'3f = compileRegex "\\*[I|i][N|n]\\(?1[P|p]\\)?"
regex_'5c'2a'5bI'7ci'5d'5bN'7cn'5d'5c'28'3f'5bH'7ch'7cL'7cl'5d'5b1'2d9'5d'5c'29'3f = compileRegex "\\*[I|i][N|n]\\(?[H|h|L|l][1-9]\\)?"
regex_'5c'2a'5bI'7ci'5d'5bN'7cn'5d'5c'28'3f'5bL'7cl'7cM'7cm'5d'5bR'7cr'5d'5c'29'3f = compileRegex "\\*[I|i][N|n]\\(?[L|l|M|m][R|r]\\)?"
regex_'5c'2a'5bI'7ci'5d'5bN'7cn'5d'5c'28'3f'5bO'7co'5d'5bA'2dG'7ca'2dg'7cV'7cv'5d'5c'29'3f = compileRegex "\\*[I|i][N|n]\\(?[O|o][A-G|a-g|V|v]\\)?"
regex_'5c'2a'5bI'7ci'5d'5bN'7cn'5d'5c'28'3f'5bU'7cu'5d'5b1'2d8'5d'5c'29'3f = compileRegex "\\*[I|i][N|n]\\(?[U|u][1-8]\\)?"
regex_'5c'2a'5bI'7ci'5d'5bN'7cn'5d'5c'28'3f'5bK'7ck'5d'5bA'2dN'7ca'2dn'7cP'2dY'7cp'2dy'5d'5c'29'3f = compileRegex "\\*[I|i][N|n]\\(?[K|k][A-N|a-n|P-Y|p-y]\\)?"
regex_'5c'2a'5bI'7ci'5d'5bN'7cn'5d'5c'28'3f'5bR'7cr'5d'5bT'7ct'5d'5c'29'3f = compileRegex "\\*[I|i][N|n]\\(?[R|r][T|t]\\)?"
regex_'5b'5c'2a'7cU'7cu'5d'5bD'7cd'5d'5bA'7ca'5d'5bT'7ct'5d'5bE'7ce'5d = compileRegex "[\\*|U|u][D|d][A|a][T|t][E|e]"
regex_'5b'5c'2a'7cU'7cu'5d'5bM'7cm'5d'5bO'7co'5d'5bN'7cn'5d'5bT'7ct'5d'5bH'7ch'5d = compileRegex "[\\*|U|u][M|m][O|o][N|n][T|t][H|h]"
regex_'5b'5c'2a'7cU'7cu'5d'5bY'7cy'5d'5bE'7ce'5d'5bA'7ca'5d'5bR'7cr'5d = compileRegex "[\\*|U|u][Y|y][E|e][A|a][R|r]"
regex_'5b'5c'2a'7cU'7cu'5d'5bD'7cd'5d'5bA'7ca'5d'5bY'7cy'5d = compileRegex "[\\*|U|u][D|d][A|a][Y|y]"
regex_'5c_'5bP'7cp'5d'5bA'7ca'5d'5bG'7cg'5d'5bE'7ce'5d'5b1'2d7'5d'3f = compileRegex "\\ [P|p][A|a][G|g][E|e][1-7]?"
regex_'5c'2a'28'5bA'7ca'5d'5bA'7cl'5d'7b2'7d'5bX'7cx'7cG'7cg'5d'3f'7c'5bB'7cb'5d'5bL'7cl'5d'5bA'7ca'5d'5bN'7cn'5d'5bK'7ck'5d'5bS'7cs'5d'3f'7c'5bO'7co'5d'5bN'7cn'5d'7c'5bO'7co'5d'5bF'7cf'5d'7b2'7d'7c'5bN'7cn'5d'5bU'7cu'5d'5bL'7cl'5d'7b2'7d'7c'5bZ'7cz'5d'5bE'7ce'5d'5bR'7cr'5d'5bO'7co'5d'5bS'7cs'5d'3f'7c'5bH'7ch'5d'5bI'7ci'5d'5bV'7cv'5d'5bA'7ca'5d'5bL'7cl'5d'7c'5bL'7cl'5d'5bO'7co'5d'5bV'7cv'5d'5bA'7ca'5d'5bL'7cl'5d'7c'5bP'7cp'5d'5bS'7cs'5d'7b2'7d'5bR'7cr'5d'7c'5bE'7ce'5d'5bN'7cn'5d'5bD'7cd'5d'7c'5bS'7cs'5d'5bT'7ct'5d'5bA'7ca'5d'5bR'7cr'5d'5bT'7ct'5d'29 = compileRegex "\\*([A|a][A|l]{2}[X|x|G|g]?|[B|b][L|l][A|a][N|n][K|k][S|s]?|[O|o][N|n]|[O|o][F|f]{2}|[N|n][U|u][L|l]{2}|[Z|z][E|e][R|r][O|o][S|s]?|[H|h][I|i][V|v][A|a][L|l]|[L|l][O|o][V|v][A|a][L|l]|[P|p][S|s]{2}[R|r]|[E|e][N|n][D|d]|[S|s][T|t][A|a][R|r][T|t])"
regex_'5c'2a'5bC'7cc'5d'5bD'7cd'5d'5bM'7cm'5d'5bY'7cy'5d = compileRegex "\\*[C|c][D|d][M|m][Y|y]"
regex_'5c'2a'5bC'7cc'5d'5bM'7cm'5d'5bD'7cd'5d'5bY'7cy'5d = compileRegex "\\*[C|c][M|m][D|d][Y|y]"
regex_'5c'2a'5bC'7cc'5d'5bY'7cy'5d'5bM'7cm'5d'5bD'7cd'5d = compileRegex "\\*[C|c][Y|y][M|m][D|d]"
regex_'5c'2a'5bD'7cd'5d'5bM'7cm'5d'5bY'7cy'5d = compileRegex "\\*[D|d][M|m][Y|y]"
regex_'5c'2a'5bE'7ce'5d'5bU'7cu'5d'5bR'7cr'5d = compileRegex "\\*[E|e][U|u][R|r]"
regex_'5c'2a'5bH'7ch'5d'5bM'7cm'5d'5bS'7cs'5d = compileRegex "\\*[H|h][M|m][S|s]"
regex_'5c'2a'5bI'7ci'5d'5bS'7cs'5d'5bO'7co'5d = compileRegex "\\*[I|i][S|s][O|o]"
regex_'5c'2a'5bJ'7cj'5d'5bI'7ci'5d'5bS'7cs'5d = compileRegex "\\*[J|j][I|i][S|s]"
regex_'5c'2a'5bJ'7cj'5d'5bO'7co'5d'5bB'7cb'5d'28'5bR'7cr'5d'5bU'7cu'5d'5bN'7cn'5d'29'3f = compileRegex "\\*[J|j][O|o][B|b]([R|r][U|u][N|n])?"
regex_'5c'2a'28'5bL'7cl'5d'5bO'7co'5d'5bN'7cn'5d'5bG'7cg'5d'29'3f'5bJ'7cj'5d'5bU'7cu'5d'5bL'7cl'5d = compileRegex "\\*([L|l][O|o][N|n][G|g])?[J|j][U|u][L|l]"
regex_'5c'2a'5bM'7cm'5d'5bD'7cd'5d'5bY'7cy'5d = compileRegex "\\*[M|m][D|d][Y|y]"
regex_'5c'2a'5bS'7cs'5d'5bY'7cy'5d'5bS'7cs'5d = compileRegex "\\*[S|s][Y|y][S|s]"
regex_'5c'2a'5bU'7cu'5d'5bS'7cs'5d'5bA'7ca'5d = compileRegex "\\*[U|u][S|s][A|a]"
regex_'5c'2a'5bY'7cy'5d'5bM'7cm'5d'5bD'7cd'5d = compileRegex "\\*[Y|y][M|m][D|d]"
regex_'5c'2a'5bA'7ca'5d'5bL'7cl'5d'5bT'7ct'5d'5bS'7cs'5d'5bE'7ce'5d'5bQ'7cq'5d = compileRegex "\\*[A|a][L|l][T|t][S|s][E|e][Q|q]"
regex_'5c'2a'5bE'7ce'5d'5bQ'7cq'5d'5bU'7cu'5d'5bA'7ca'5d'5bT'7ct'5d'5bE'7ce'5d = compileRegex "\\*[E|e][Q|q][U|u][A|a][T|t][E|e]"
regex_'5c'2a'5bF'7cf'5d'5bI'7ci'5d'5bL'7cl'5d'5bE'7ce'5d = compileRegex "\\*[F|f][I|i][L|l][E|e]"
regex_'5c'2a'5bF'7cf'5d'5bT'7ct'5d'5bR'7cr'5d'5bA'7ca'5d'5bN'7cn'5d'5bS'7cs'5d = compileRegex "\\*[F|f][T|t][R|r][A|a][N|n][S|s]"
regex_'5c'2a'5bI'7ci'5d'5bL'7cl'5d'5bE'7ce'5d'5bR'7cr'5d'5bP'7cp'5d'5bG'7cg'5d = compileRegex "\\*[I|i][L|l][E|e][R|r][P|p][G|g]"
regex_'5c'2a'5bC'7cc'5d'5bR'7cr'5d'5bT'7ct'5d'5bB'7cb'5d'5bN'7cn'5d'5bD'7cd'5d'5bR'7cr'5d'5bP'7cp'5d'5bG'7cg'5d = compileRegex "\\*[C|c][R|r][T|t][B|b][N|n][D|d][R|r][P|p][G|g]"
regex_'5c'2a'5bC'7cc'5d'5bR'7cr'5d'5bT'7ct'5d'5bR'7cr'5d'5bP'7cp'5d'5bG'7cg'5d'5bM'7cm'5d'5bO'7co'5d'5bD'7cd'5d = compileRegex "\\*[C|c][R|r][T|t][R|r][P|p][G|g][M|m][O|o][D|d]"
regex_'5c'2a'5bV'7cv'5d'5b0'2d9'5d'5bR'7cr'5d'5b0'2d9'5d'5bM'7cm'5d'5b0'2d9'5d = compileRegex "\\*[V|v][0-9][R|r][0-9][M|m][0-9]"
regex_'5c'2a'5bN'7cn'5d'5bO'7co'5d'5bP'7cp'5d'5bA'7ca'5d'5bS'7cs'5d'7b2'7d = compileRegex "\\*[N|n][O|o][P|p][A|a][S|s]{2}"
regex_'5c'2a'5bO'7co'5d'5bM'7cm'5d'5bI'7ci'5d'5bT'7ct'5d = compileRegex "\\*[O|o][M|m][I|i][T|t]"
regex_'5c'2a'5bV'7cv'5d'5bA'7ca'5d'5bR'7cr'5d'5bS'7cs'5d'5bI'7ci'5d'5bZ'7cz'5d'5bE'7ce'5d = compileRegex "\\*[V|v][A|a][R|r][S|s][I|i][Z|z][E|e]"
regex_'5c'2a'5bR'7cr'5d'5bI'7ci'5d'5bG'7cg'5d'5bH'7ch'5d'5bT'7ct'5d'5bA'7ca'5d'5bD'7cd'5d'5bJ'7cj'5d = compileRegex "\\*[R|r][I|i][G|g][H|h][T|t][A|a][D|d][J|j]"
regex_'5c'2a'5bS'7cs'5d'5bT'7ct'5d'5bR'7cr'5d'5bI'7ci'5d'5bN'7cn'5d'5bG'7cg'5d = compileRegex "\\*[S|s][T|t][R|r][I|i][N|n][G|g]"
regex_'5c'2a'5bT'7ct'5d'5bR'7cr'5d'5bI'7ci'5d'5bM'7cm'5d = compileRegex "\\*[T|t][R|r][I|i][M|m]"

defaultAttributes = [("Default","Normal Text"),("CControlLevel","Normal Text"),("CIndicators","Normal Text"),("CFactor1","Normal Text"),("FindOC","Normal Text"),("NonEvalOC2","Normal Text"),("NonEvalOC3","Normal Text"),("NonEvalOC4","Normal Text"),("NonEvalOC5","Normal Text"),("NonEvalOC6","Normal Text"),("NonEvalOC7","Normal Text"),("CFactor2","Normal Text"),("EvalOC2","Normal Text"),("EvalOC3","Normal Text"),("EvalOC4","Normal Text"),("EvalOC5","Normal Text"),("EvalOC6","Normal Text"),("EvalOC8","Normal Text"),("CExFactor2","Normal Text"),("EvalOCCont","Normal Text"),("Comments","Comment"),("StringConstants","ConstantChar"),("Directives","Normal Text"),("Directives2","Normal Text"),("Directives3","Normal Text"),("Free","Normal Text"),("Exec","Normal Text"),("Biffs","Biff"),("CommonCode","Normal Text"),("Indicators","Normal Text"),("ReservedWords","Normal Text"),("AnyCode","Normal Text"),("D","Normal Text"),("P","Normal Text")]

parseRules "Default" = 
  do (attr, result) <- (((pRegExpr regex_'5bPpOoIiHhFfDdCc_'5d'3f'5c'2a >>= withAttribute "Comment") >>~ pushContext "Comments")
                        <|>
                        ((pRegExpr regex_'5bPpOoIiHhFfDdCc_'5d'3f'2f >>= withAttribute "Directive") >>~ pushContext "Directives")
                        <|>
                        ((pAnyChar "OoIiHhFf" >>= withAttribute "Keyword") >>~ pushContext "AnyCode")
                        <|>
                        ((pAnyChar "Dd" >>= withAttribute "Keyword") >>~ pushContext "D")
                        <|>
                        ((pAnyChar "Pp" >>= withAttribute "Keyword") >>~ pushContext "P")
                        <|>
                        ((pAnyChar "Cc" >>= withAttribute "Keyword") >>~ pushContext "CControlLevel"))
     return (attr, result)

parseRules "CControlLevel" = 
  do (attr, result) <- (((pRegExpr regex_'5c_'7b2'7d >>= withAttribute "Indicator") >>~ pushContext "CIndicators")
                        <|>
                        ((pRegExpr regex_'5bL'7cl'5d'5b0'2d9'5d >>= withAttribute "Indicator") >>~ pushContext "CIndicators")
                        <|>
                        ((pRegExpr regex_'5bO'7co'7cL'7cl'7cS'7cs'5d'5bR'7cr'5d >>= withAttribute "Indicator") >>~ pushContext "CIndicators")
                        <|>
                        ((pRegExpr regex_'5bA'7ca'5d'5bN'7cn'5d >>= withAttribute "Indicator") >>~ pushContext "CIndicators")
                        <|>
                        ((pRegExpr regex_'5bL'7cl'7cS'7cs'5d'5bR'7cr'5d >>= withAttribute "Indicator") >>~ pushContext "CIndicators")
                        <|>
                        ((pRegExpr regex_'2e'7b2'7d >>= withAttribute "Alert") >>~ pushContext "CIndicators"))
     return (attr, result)

parseRules "CIndicators" = 
  do (attr, result) <- (((pRegExpr regex_'5c_'7b3'7d >>= withAttribute "Indicator") >>~ pushContext "CFactor1")
                        <|>
                        ((pRegExpr regex_'5b'5c_'7cN'7cn'5d'5b0'2d9'5d'7b2'7d >>= withAttribute "Indicator") >>~ pushContext "CFactor1")
                        <|>
                        ((pRegExpr regex_'5b'5c_'7cN'7cn'5d'5bK'7ck'5d'5bA'2dN'7cp'2dy'5d >>= withAttribute "Indicator") >>~ pushContext "CFactor1")
                        <|>
                        ((pRegExpr regex_'5b'5c_'7cN'7cn'5d'5bK'7ck'5d'5bP'2dY'7cp'2dy'5d'7d >>= withAttribute "Indicator") >>~ pushContext "CFactor1")
                        <|>
                        ((pRegExpr regex_'5b'5c_'7cN'7cn'5d'5bL'7cl'5d'5b1'2d9'5d >>= withAttribute "Indicator") >>~ pushContext "CFactor1")
                        <|>
                        ((pRegExpr regex_'5b'5c_'7cN'7cn'5d'5bL'7cl'7cM'7cm'5d'5bR'7cr'5d >>= withAttribute "Indicator") >>~ pushContext "CFactor1")
                        <|>
                        ((pRegExpr regex_'5b'5c_'7cN'7cn'5d'5bR'7cr'5d'5bT'7ct'5d >>= withAttribute "Indicator") >>~ pushContext "CFactor1")
                        <|>
                        ((pRegExpr regex_'5b'5c_'7cN'7cn'5d'5bU'7cu'5d'5b1'2d8'5d >>= withAttribute "Indicator") >>~ pushContext "CFactor1")
                        <|>
                        ((pRegExpr regex_'5b'5c_'7cN'7cn'5d'5bO'7co'5d'5bA'2dG'7ca'2dg'5d >>= withAttribute "Indicator") >>~ pushContext "CFactor1")
                        <|>
                        ((pRegExpr regex_'5b'5c_'7cN'7cn'5d'5bO'7co'5d'5bV'7cv'5d >>= withAttribute "Indicator") >>~ pushContext "CFactor1")
                        <|>
                        ((pRegExpr regex_'5b'5c_'7cN'7cn'5d'5bH'7ch'5d'5b1'2d9'5d >>= withAttribute "Indicator") >>~ pushContext "CFactor1")
                        <|>
                        ((pRegExpr regex_'2e'7b3'7d >>= withAttribute "Alert") >>~ pushContext "CFactor1"))
     return (attr, result)

parseRules "CFactor1" = 
  do (attr, result) <- ((pRegExpr regex_'2e'7b14'7d >>= withAttribute "Normal Text") >>~ pushContext "FindOC")
     return (attr, result)

parseRules "FindOC" = 
  do (attr, result) <- (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_nonevalopcodes2 >>= withAttribute "Keyword") >>~ pushContext "NonEvalOC2")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_nonevalopcodes3 >>= withAttribute "Keyword") >>~ pushContext "NonEvalOC3")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_nonevalopcodes4 >>= withAttribute "Keyword") >>~ pushContext "NonEvalOC4")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_nonevalopcodes5 >>= withAttribute "Keyword") >>~ pushContext "NonEvalOC5")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_nonevalopcodes6 >>= withAttribute "Keyword") >>~ pushContext "NonEvalOC6")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_nonevalopcodes7 >>= withAttribute "Keyword") >>~ pushContext "NonEvalOC7")
                        <|>
                        ((pRegExpr regex_'5bZ'7cz'5d'2d'28'5bA'7ca'5d'5bD'7cd'5d'7b2'7d'7c'5bS'7cs'5d'5bU'7cu'5d'5bB'7cb'5d'29 >>= withAttribute "Keyword") >>~ pushContext "NonEvalOC5")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_evalopcodes2 >>= withAttribute "Keyword") >>~ pushContext "EvalOC2")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_evalopcodes3 >>= withAttribute "Keyword") >>~ pushContext "EvalOC3")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_evalopcodes4 >>= withAttribute "Keyword") >>~ pushContext "EvalOC4")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_evalopcodes5 >>= withAttribute "Keyword") >>~ pushContext "EvalOC5")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_evalopcodes6 >>= withAttribute "Keyword") >>~ pushContext "EvalOC6")
                        <|>
                        ((pRegExpr regex_'5bO'7co'5d'5bN'7cn'5d'2d'28'5bE'7ce'5d'5bR'7cr'5d'7b2'7d'7c'5bO'7co'5d'5bR'7cr'5d'29 >>= withAttribute "Keyword") >>~ pushContext "EvalOC8")
                        <|>
                        ((pRegExpr regex_'5c_'7b10'7d >>= withAttribute "Normal Text") >>~ pushContext "CFactor2")
                        <|>
                        ((pRegExpr regex_'2e'7b10'7d >>= withAttribute "Alert") >>~ pushContext "CFactor2"))
     return (attr, result)

parseRules "NonEvalOC2" = 
  do (attr, result) <- ((pRegExpr regex_'5c_'7b8'7d >>= withAttribute "Normal Text") >>~ pushContext "CFactor2")
     return (attr, result)

parseRules "NonEvalOC3" = 
  do (attr, result) <- ((pRegExpr regex_'5c_'7b7'7d >>= withAttribute "Normal Text") >>~ pushContext "CFactor2")
     return (attr, result)

parseRules "NonEvalOC4" = 
  do (attr, result) <- ((pRegExpr regex_'5c_'7b6'7d >>= withAttribute "Normal Text") >>~ pushContext "CFactor2")
     return (attr, result)

parseRules "NonEvalOC5" = 
  do (attr, result) <- ((pRegExpr regex_'5c_'7b5'7d >>= withAttribute "Normal Text") >>~ pushContext "CFactor2")
     return (attr, result)

parseRules "NonEvalOC6" = 
  do (attr, result) <- ((pRegExpr regex_'5c_'7b4'7d >>= withAttribute "Normal Text") >>~ pushContext "CFactor2")
     return (attr, result)

parseRules "NonEvalOC7" = 
  do (attr, result) <- ((pRegExpr regex_'5c_'7b3'7d >>= withAttribute "Normal Text") >>~ pushContext "CFactor2")
     return (attr, result)

parseRules "CFactor2" = 
  do (attr, result) <- (((pDetectChar False '%' >>= withAttribute "Biff") >>~ pushContext "Biffs")
                        <|>
                        ((parseRules "CommonCode")))
     return (attr, result)

parseRules "EvalOC2" = 
  do (attr, result) <- ((pRegExpr regex_'5c_'7b8'7d >>= withAttribute "Normal Text") >>~ pushContext "CExFactor2")
     return (attr, result)

parseRules "EvalOC3" = 
  do (attr, result) <- ((pRegExpr regex_'5c_'7b7'7d >>= withAttribute "Normal Text") >>~ pushContext "CExFactor2")
     return (attr, result)

parseRules "EvalOC4" = 
  do (attr, result) <- ((pRegExpr regex_'5c_'7b6'7d >>= withAttribute "Normal Text") >>~ pushContext "CExFactor2")
     return (attr, result)

parseRules "EvalOC5" = 
  do (attr, result) <- ((pRegExpr regex_'5c_'7b5'7d >>= withAttribute "Normal Text") >>~ pushContext "CExFactor2")
     return (attr, result)

parseRules "EvalOC6" = 
  do (attr, result) <- ((pRegExpr regex_'5c_'7b4'7d >>= withAttribute "Normal Text") >>~ pushContext "CExFactor2")
     return (attr, result)

parseRules "EvalOC8" = 
  do (attr, result) <- ((pRegExpr regex_'5c_'7b2'7d >>= withAttribute "Normal Text") >>~ pushContext "CExFactor2")
     return (attr, result)

parseRules "CExFactor2" = 
  do (attr, result) <- (((pDetectChar False '%' >>= withAttribute "Biff") >>~ pushContext "Biffs")
                        <|>
                        ((parseRules "CommonCode")))
     return (attr, result)

parseRules "EvalOCCont" = 
  do (attr, result) <- (((pDetectChar False '%' >>= withAttribute "Biff") >>~ pushContext "Biffs")
                        <|>
                        ((parseRules "CommonCode")))
     return (attr, result)

parseRules "Comments" = 
  do (attr, result) <- (((pRegExpr regex_'5c'28'2a'28FIXME'7cTODO'29'5c'29'2a >>= withAttribute "BoldComment"))
                        <|>
                        ((pRegExpr regex_'5c'28'2a'28NOTE'3a'29'5c'29'2a >>= withAttribute "BoldComment"))
                        <|>
                        ((pRegExpr regex_'2d'7c'3d >>= withAttribute "DivideComment")))
     return (attr, result)

parseRules "StringConstants" = 
  do (attr, result) <- ((pDetectChar False '\'' >>= withAttribute "ConstantChar") >>~ (popContext))
     return (attr, result)

parseRules "Directives" = 
  do (attr, result) <- (((pRegExpr regex_'5bF'7cf'5d'5bR'7cr'5d'5bE'7ce'5d'5bE'7ce'5d >>= withAttribute "Directive") >>~ pushContext "Free")
                        <|>
                        ((pRegExpr regex_'5bE'7ce'5d'5bX'7cx'5d'5bE'7ce'5d'5bC'7cc'5d >>= withAttribute "Directive") >>~ pushContext "Exec")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_directives >>= withAttribute "Directive") >>~ pushContext "Directives2"))
     return (attr, result)

parseRules "Directives2" = 
  do (attr, result) <- ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_directives2 >>= withAttribute "Directive") >>~ pushContext "Directives3")
     return (attr, result)

parseRules "Directives3" = 
  do (attr, result) <- ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_directives3 >>= withAttribute "Directive"))
     return (attr, result)

parseRules "Free" = 
  do (attr, result) <- (((pRegExpr regex_'5bPOIHFDC_'5d'3f'2f'5bE'7ce'5d'5bN'7cn'5d'5bD'7cd'5d'2d'5bF'7cf'5d'5bR'7cr'5d'5bE'7ce'5d'5bE'7ce'5d >>= withAttribute "Directive") >>~ (popContext))
                        <|>
                        ((parseRules "CommonCode"))
                        <|>
                        ((pDetectChar False '%' >>= withAttribute "Biff") >>~ pushContext "Biffs")
                        <|>
                        ((pRegExpr regex_'2f'2f >>= withAttribute "Comment") >>~ pushContext "Comments")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_freeopcodes >>= withAttribute "Keyword")))
     return (attr, result)

parseRules "Exec" = 
  do (attr, result) <- ((pRegExpr regex_'5bPOIHFDC_'5d'3f'2f'5bE'7ce'5d'5bN'7cn'5d'5bD'7cd'5d'2d'5bE'7ce'5d'5bX'7cx'5d'5bE'7ce'5d'5bC'7cc'5d >>= withAttribute "Directive") >>~ (popContext))
     return (attr, result)

parseRules "Biffs" = 
  do (attr, result) <- (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_biffs >>= withAttribute "Biff") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'2e >>= withAttribute "Normal Text") >>~ (popContext)))
     return (attr, result)

parseRules "CommonCode" = 
  do (attr, result) <- (((parseRules "ReservedWords"))
                        <|>
                        ((parseRules "Indicators"))
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "ConstantChar") >>~ pushContext "StringConstants")
                        <|>
                        ((pFloat >>= withAttribute "Float"))
                        <|>
                        ((pRegExpr regex_'5bXx'5d'27'5b0'2d9a'2dfA'2dF'5d'7b2'2c'7d'27 >>= withAttribute "Hex"))
                        <|>
                        (withChildren (pInt >>= withAttribute "Decimal") (((pString False "ULL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LUL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LLU" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "UL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LU" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "U" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "L" >>= withAttribute "Decimal")))))
     return (attr, result)

parseRules "Indicators" = 
  do (attr, result) <- (((pRegExpr regex_'5c'2a'5bI'7ci'5d'5bN'7cn'5d'5c'28'3f'5b0'2d9'5d'5b0'2d9'5d'5c'29'3f >>= withAttribute "Indicator"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bI'7ci'5d'5bN'7cn'5d'5c'28'3f1'5bP'7cp'5d'5c'29'3f >>= withAttribute "Indicator"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bI'7ci'5d'5bN'7cn'5d'5c'28'3f'5bH'7ch'7cL'7cl'5d'5b1'2d9'5d'5c'29'3f >>= withAttribute "Indicator"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bI'7ci'5d'5bN'7cn'5d'5c'28'3f'5bL'7cl'7cM'7cm'5d'5bR'7cr'5d'5c'29'3f >>= withAttribute "Indicator"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bI'7ci'5d'5bN'7cn'5d'5c'28'3f'5bO'7co'5d'5bA'2dG'7ca'2dg'7cV'7cv'5d'5c'29'3f >>= withAttribute "Indicator"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bI'7ci'5d'5bN'7cn'5d'5c'28'3f'5bU'7cu'5d'5b1'2d8'5d'5c'29'3f >>= withAttribute "Indicator"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bI'7ci'5d'5bN'7cn'5d'5c'28'3f'5bK'7ck'5d'5bA'2dN'7ca'2dn'7cP'2dY'7cp'2dy'5d'5c'29'3f >>= withAttribute "Indicator"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bI'7ci'5d'5bN'7cn'5d'5c'28'3f'5bR'7cr'5d'5bT'7ct'5d'5c'29'3f >>= withAttribute "Indicator")))
     return (attr, result)

parseRules "ReservedWords" = 
  do (attr, result) <- (((pRegExpr regex_'5b'5c'2a'7cU'7cu'5d'5bD'7cd'5d'5bA'7ca'5d'5bT'7ct'5d'5bE'7ce'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5b'5c'2a'7cU'7cu'5d'5bM'7cm'5d'5bO'7co'5d'5bN'7cn'5d'5bT'7ct'5d'5bH'7ch'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5b'5c'2a'7cU'7cu'5d'5bY'7cy'5d'5bE'7ce'5d'5bA'7ca'5d'5bR'7cr'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5b'5c'2a'7cU'7cu'5d'5bD'7cd'5d'5bA'7ca'5d'5bY'7cy'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c_'5bP'7cp'5d'5bA'7ca'5d'5bG'7cg'5d'5bE'7ce'5d'5b1'2d7'5d'3f >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'28'5bA'7ca'5d'5bA'7cl'5d'7b2'7d'5bX'7cx'7cG'7cg'5d'3f'7c'5bB'7cb'5d'5bL'7cl'5d'5bA'7ca'5d'5bN'7cn'5d'5bK'7ck'5d'5bS'7cs'5d'3f'7c'5bO'7co'5d'5bN'7cn'5d'7c'5bO'7co'5d'5bF'7cf'5d'7b2'7d'7c'5bN'7cn'5d'5bU'7cu'5d'5bL'7cl'5d'7b2'7d'7c'5bZ'7cz'5d'5bE'7ce'5d'5bR'7cr'5d'5bO'7co'5d'5bS'7cs'5d'3f'7c'5bH'7ch'5d'5bI'7ci'5d'5bV'7cv'5d'5bA'7ca'5d'5bL'7cl'5d'7c'5bL'7cl'5d'5bO'7co'5d'5bV'7cv'5d'5bA'7ca'5d'5bL'7cl'5d'7c'5bP'7cp'5d'5bS'7cs'5d'7b2'7d'5bR'7cr'5d'7c'5bE'7ce'5d'5bN'7cn'5d'5bD'7cd'5d'7c'5bS'7cs'5d'5bT'7ct'5d'5bA'7ca'5d'5bR'7cr'5d'5bT'7ct'5d'29 >>= withAttribute "Constant"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bC'7cc'5d'5bD'7cd'5d'5bM'7cm'5d'5bY'7cy'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bC'7cc'5d'5bM'7cm'5d'5bD'7cd'5d'5bY'7cy'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bC'7cc'5d'5bY'7cy'5d'5bM'7cm'5d'5bD'7cd'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bD'7cd'5d'5bM'7cm'5d'5bY'7cy'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bE'7ce'5d'5bU'7cu'5d'5bR'7cr'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bH'7ch'5d'5bM'7cm'5d'5bS'7cs'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bI'7ci'5d'5bS'7cs'5d'5bO'7co'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bJ'7cj'5d'5bI'7ci'5d'5bS'7cs'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bJ'7cj'5d'5bO'7co'5d'5bB'7cb'5d'28'5bR'7cr'5d'5bU'7cu'5d'5bN'7cn'5d'29'3f >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'28'5bL'7cl'5d'5bO'7co'5d'5bN'7cn'5d'5bG'7cg'5d'29'3f'5bJ'7cj'5d'5bU'7cu'5d'5bL'7cl'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bM'7cm'5d'5bD'7cd'5d'5bY'7cy'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bS'7cs'5d'5bY'7cy'5d'5bS'7cs'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bU'7cu'5d'5bS'7cs'5d'5bA'7ca'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bY'7cy'5d'5bM'7cm'5d'5bD'7cd'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bA'7ca'5d'5bL'7cl'5d'5bT'7ct'5d'5bS'7cs'5d'5bE'7ce'5d'5bQ'7cq'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bE'7ce'5d'5bQ'7cq'5d'5bU'7cu'5d'5bA'7ca'5d'5bT'7ct'5d'5bE'7ce'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bF'7cf'5d'5bI'7ci'5d'5bL'7cl'5d'5bE'7ce'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bF'7cf'5d'5bT'7ct'5d'5bR'7cr'5d'5bA'7ca'5d'5bN'7cn'5d'5bS'7cs'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bI'7ci'5d'5bL'7cl'5d'5bE'7ce'5d'5bR'7cr'5d'5bP'7cp'5d'5bG'7cg'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bC'7cc'5d'5bR'7cr'5d'5bT'7ct'5d'5bB'7cb'5d'5bN'7cn'5d'5bD'7cd'5d'5bR'7cr'5d'5bP'7cp'5d'5bG'7cg'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bC'7cc'5d'5bR'7cr'5d'5bT'7ct'5d'5bR'7cr'5d'5bP'7cp'5d'5bG'7cg'5d'5bM'7cm'5d'5bO'7co'5d'5bD'7cd'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bV'7cv'5d'5b0'2d9'5d'5bR'7cr'5d'5b0'2d9'5d'5bM'7cm'5d'5b0'2d9'5d >>= withAttribute "Reserved")))
     return (attr, result)

parseRules "AnyCode" = 
  do (attr, result) <- ((parseRules "CommonCode"))
     return (attr, result)

parseRules "D" = 
  do (attr, result) <- (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_dkeywords >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bN'7cn'5d'5bO'7co'5d'5bP'7cp'5d'5bA'7ca'5d'5bS'7cs'5d'7b2'7d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bO'7co'5d'5bM'7cm'5d'5bI'7ci'5d'5bT'7ct'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bV'7cv'5d'5bA'7ca'5d'5bR'7cr'5d'5bS'7cs'5d'5bI'7ci'5d'5bZ'7cz'5d'5bE'7ce'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bR'7cr'5d'5bI'7ci'5d'5bG'7cg'5d'5bH'7ch'5d'5bT'7ct'5d'5bA'7ca'5d'5bD'7cd'5d'5bJ'7cj'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bS'7cs'5d'5bT'7ct'5d'5bR'7cr'5d'5bI'7ci'5d'5bN'7cn'5d'5bG'7cg'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bT'7ct'5d'5bR'7cr'5d'5bI'7ci'5d'5bM'7cm'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pDetectChar False '%' >>= withAttribute "Biff") >>~ pushContext "Biffs")
                        <|>
                        ((parseRules "CommonCode")))
     return (attr, result)

parseRules "P" = 
  do (attr, result) <- (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_dkeywords >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bN'7cn'5d'5bO'7co'5d'5bP'7cp'5d'5bA'7ca'5d'5bS'7cs'5d'7b2'7d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bO'7co'5d'5bM'7cm'5d'5bI'7ci'5d'5bT'7ct'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bV'7cv'5d'5bA'7ca'5d'5bR'7cr'5d'5bS'7cs'5d'5bI'7ci'5d'5bZ'7cz'5d'5bE'7ce'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bR'7cr'5d'5bI'7ci'5d'5bG'7cg'5d'5bH'7ch'5d'5bT'7ct'5d'5bA'7ca'5d'5bD'7cd'5d'5bJ'7cj'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bS'7cs'5d'5bT'7ct'5d'5bR'7cr'5d'5bI'7ci'5d'5bN'7cn'5d'5bG'7cg'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5bT'7ct'5d'5bR'7cr'5d'5bI'7ci'5d'5bM'7cm'5d >>= withAttribute "Reserved"))
                        <|>
                        ((pDetectChar False '%' >>= withAttribute "Biff") >>~ pushContext "Biffs")
                        <|>
                        ((parseRules "CommonCode")))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
