{- This module was generated from data in the Kate syntax highlighting file idl.xml, version 1.07,
   by   -}

module Text.Highlighting.Kate.Syntax.Idl ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Doxygen
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "IDL"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.idl"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "IDL" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("IDL",["Normal"])], synStLanguage = "IDL", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Normal" -> return () >> pHandleEndLine
    "String" -> return () >> pHandleEndLine
    "Commentar 1" -> (popContext) >> pEndLine
    "Commentar 2" -> return () >> pHandleEndLine
    "Preprocessor" -> (popContext) >> pEndLine
    "Commentar/Preprocessor" -> return () >> pHandleEndLine
    "Some Context" -> (popContext) >> pEndLine
    "Some Context2" -> (popContext) >> pEndLine
    "Some Context3" -> return () >> pHandleEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Keyword","kw"),("Data Type","dt"),("Decimal","dv"),("Octal","bn"),("Hex","bn"),("Float","fl"),("Char","ch"),("String","st"),("String Char","ch"),("Comment","co"),("Preprocessor","ot"),("Prep. Lib","ot"),("Alert","al")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "any attribute case const context default enum exception FALSE fixed public in inout interface module Object oneway out raises readonly sequence struct switch TRUE typedef unsigned union"
list_types = Set.fromList $ words $ "boolean char double float long octet short string void wchar wstring"

regex_'28FIXME'7cTODO'29 = compileRegex "(FIXME|TODO)"

defaultAttributes = [("Normal","Normal Text"),("String","String"),("Commentar 1","Comment"),("Commentar 2","Comment"),("Preprocessor","Preprocessor"),("Commentar/Preprocessor","Comment"),("Some Context","Normal Text"),("Some Context2","Normal Text"),("Some Context3","Normal Text")]

parseRules "Normal" = 
  do (attr, result) <- (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute "Keyword"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute "Data Type"))
                        <|>
                        ((pHlCOct >>= withAttribute "Octal"))
                        <|>
                        ((pHlCHex >>= withAttribute "Hex"))
                        <|>
                        ((pHlCChar >>= withAttribute "Char"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "String")
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression))
                        <|>
                        ((pDetect2Chars False '/' '/' >>= withAttribute "Comment") >>~ pushContext "Commentar 1")
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Comment") >>~ pushContext "Commentar 2")
                        <|>
                        ((pAnyChar "!%&()+,-<=>?[]^{|}~" >>= withAttribute "Symbol"))
                        <|>
                        ((pString False "#if 0" >>= withAttribute "Comment") >>~ pushContext "Some Context3")
                        <|>
                        ((pColumn 0 >> pDetectChar False '#' >>= withAttribute "Preprocessor") >>~ pushContext "Preprocessor"))
     return (attr, result)

parseRules "String" = 
  do (attr, result) <- (((pLineContinue >>= withAttribute "String") >>~ pushContext "Some Context")
                        <|>
                        ((pHlCStringChar >>= withAttribute "String Char"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext)))
     return (attr, result)

parseRules "Commentar 1" = 
  do (attr, result) <- ((pRegExpr regex_'28FIXME'7cTODO'29 >>= withAttribute "Alert"))
     return (attr, result)

parseRules "Commentar 2" = 
  do (attr, result) <- (((pRegExpr regex_'28FIXME'7cTODO'29 >>= withAttribute "Alert"))
                        <|>
                        ((pDetect2Chars False '*' '/' >>= withAttribute "Comment") >>~ (popContext)))
     return (attr, result)

parseRules "Preprocessor" = 
  do (attr, result) <- (((pLineContinue >>= withAttribute "Preprocessor") >>~ pushContext "Some Context2")
                        <|>
                        ((pRangeDetect '"' '"' >>= withAttribute "Prep. Lib"))
                        <|>
                        ((pRangeDetect '<' '>' >>= withAttribute "Prep. Lib"))
                        <|>
                        ((pDetect2Chars False '/' '/' >>= withAttribute "Comment") >>~ pushContext "Commentar 1")
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Comment") >>~ pushContext "Commentar/Preprocessor"))
     return (attr, result)

parseRules "Commentar/Preprocessor" = 
  do (attr, result) <- ((pDetect2Chars False '*' '/' >>= withAttribute "Comment") >>~ (popContext))
     return (attr, result)

parseRules "Some Context" = 
  pzero

parseRules "Some Context2" = 
  pzero

parseRules "Some Context3" = 
  do (attr, result) <- (((pRegExpr regex_'28FIXME'7cTODO'29 >>= withAttribute "Alert"))
                        <|>
                        ((pColumn 0 >> pString False "#endif" >>= withAttribute "Comment") >>~ (popContext)))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
