{- This module was generated from data in the Kate syntax highlighting file djangotemplate.xml, version 1.2,
   by  Matthew Marshall (matthew@matthewmarshall.org) -}

module Text.Highlighting.Kate.Syntax.Djangotemplate ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import qualified Text.Highlighting.Kate.Syntax.Css
import qualified Text.Highlighting.Kate.Syntax.Javascript
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "Django HTML Template"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.htm;*.html"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Django HTML Template" }
  context <- currentContext <|> (pushContext "Start" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("Django HTML Template",["Start"])], synStLanguage = "Django HTML Template", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Start" -> return () >> pHandleEndLine
    "In Block" -> return () >> pHandleEndLine
    "FindTemplate" -> return () >> pHandleEndLine
    "Template Comment" -> return () >> pHandleEndLine
    "Template Var" -> return () >> pHandleEndLine
    "Template Filter" -> return () >> pHandleEndLine
    "Template Tag" -> return () >> pHandleEndLine
    "Found Block Tag" -> return () >> pHandleEndLine
    "In Block Tag" -> return () >> pHandleEndLine
    "Non Matching Tag" -> return () >> pHandleEndLine
    "In Template Tag" -> return () >> pHandleEndLine
    "Single A-string" -> return () >> pHandleEndLine
    "Single Q-string" -> return () >> pHandleEndLine
    "FindHTML" -> return () >> pHandleEndLine
    "FindEntityRefs" -> return () >> pHandleEndLine
    "FindPEntityRefs" -> return () >> pHandleEndLine
    "FindAttributes" -> return () >> pHandleEndLine
    "FindDTDRules" -> return () >> pHandleEndLine
    "Comment" -> return () >> pHandleEndLine
    "CDATA" -> return () >> pHandleEndLine
    "PI" -> return () >> pHandleEndLine
    "Doctype" -> return () >> pHandleEndLine
    "Doctype Internal Subset" -> return () >> pHandleEndLine
    "Doctype Markupdecl" -> return () >> pHandleEndLine
    "Doctype Markupdecl DQ" -> return () >> pHandleEndLine
    "Doctype Markupdecl SQ" -> return () >> pHandleEndLine
    "El Open" -> return () >> pHandleEndLine
    "El Close" -> return () >> pHandleEndLine
    "El Close 2" -> return () >> pHandleEndLine
    "El Close 3" -> return () >> pHandleEndLine
    "CSS" -> return () >> pHandleEndLine
    "CSS content" -> return () >> pHandleEndLine
    "JS" -> return () >> pHandleEndLine
    "JS content" -> return () >> pHandleEndLine
    "JS comment close" -> (popContext) >> pEndLine
    "Value" -> return () >> pHandleEndLine
    "Value NQ" -> (popContext >> popContext) >> pEndLine
    "Value DQ" -> return () >> pHandleEndLine
    "Value SQ" -> return () >> pHandleEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Comment","co"),("CDATA","bn"),("Processing Instruction","kw"),("Doctype","dt"),("Element","kw"),("Attribute","ot"),("Value","st"),("EntityRef","dv"),("PEntityRef","dv"),("Error","er"),("Template Var","fu"),("Template Tag","fu"),("Template Tag Argument","fu"),("Template String","st"),("Template Comment","co"),("Template Filter","ot"),("Mismatched Block Tag","er")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_blocktags = Set.fromList $ words $ "for block if ifequal ifnotequal ifchanged blocktrans spaceless"
list_endblocktags = Set.fromList $ words $ "endfor endblock endif endifequal endifnotequal endifchanged endblocktrans endspaceless"

regex_'5c'7b'25'5cs'2aend'5ba'2dz'5d'2b'5cs'2a'25'5c'7d = compileRegex "\\{%\\s*end[a-z]+\\s*%\\}"
regex_'5c'7b'25'5cs'2acomment'5cs'2a'25'5c'7d = compileRegex "\\{%\\s*comment\\s*%\\}"
regex_'5c'7b'25'5cs'2aendcomment'5cs'2a'25'5c'7d = compileRegex "\\{%\\s*endcomment\\s*%\\}"
regex_'28'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29 = compileRegex "([A-Za-z_:][\\w.:_-]*)"
regex_'3c'21DOCTYPE'5cs'2b = compileRegex "<!DOCTYPE\\s+"
regex_'3c'5c'3f'5b'5cw'3a'2d'5d'2a = compileRegex "<\\?[\\w:-]*"
regex_'3cstyle'5cb = compileRegex "<style\\b"
regex_'3cscript'5cb = compileRegex "<script\\b"
regex_'3cpre'5cb = compileRegex "<pre\\b"
regex_'3cdiv'5cb = compileRegex "<div\\b"
regex_'3ctable'5cb = compileRegex "<table\\b"
regex_'3c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex "<[A-Za-z_:][\\w.:_-]*"
regex_'3c'2fpre'5cb = compileRegex "</pre\\b"
regex_'3c'2fdiv'5cb = compileRegex "</div\\b"
regex_'3c'2ftable'5cb = compileRegex "</table\\b"
regex_'3c'2f'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex "</[A-Za-z_:][\\w.:_-]*"
regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b = compileRegex "&(#[0-9]+|#[xX][0-9A-Fa-f]+|[A-Za-z_:][\\w.:_-]*);"
regex_'25'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'3b = compileRegex "%[A-Za-z_:][\\w.:_-]*;"
regex_'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex "[A-Za-z_:][\\w.:_-]*"
regex_'5cs'2b'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex "\\s+[A-Za-z_:][\\w.:_-]*"
regex_'3c'21'28ELEMENT'7cENTITY'7cATTLIST'7cNOTATION'29'5cb = compileRegex "<!(ELEMENT|ENTITY|ATTLIST|NOTATION)\\b"
regex_'2d'28'2d'28'3f'21'2d'3e'29'29'2b = compileRegex "-(-(?!->))+"
regex_'5cS = compileRegex "\\S"
regex_'3c'2fstyle'5cb = compileRegex "</style\\b"
regex_'3c'2fscript'5cb = compileRegex "</script\\b"
regex_'2f'2f'28'3f'3d'2e'2a'3c'2fscript'5cb'29 = compileRegex "//(?=.*</script\\b)"
regex_'2f'28'3f'21'3e'29 = compileRegex "/(?!>)"
regex_'5b'5e'2f'3e'3c'22'27'5cs'5d = compileRegex "[^/><\"'\\s]"

defaultAttributes = [("Start","Normal Text"),("In Block","Normal Text"),("FindTemplate","Normal Text"),("Template Comment","Template Comment"),("Template Var","Template Var"),("Template Filter","Template Filter"),("Template Tag","Template Tag"),("Found Block Tag","Template Tag"),("In Block Tag","Template Tag Argument"),("Non Matching Tag","Template Tag"),("In Template Tag","Template Tag Argument"),("Single A-string","Template String"),("Single Q-string","Template String"),("FindHTML","Normal Text"),("FindEntityRefs","Normal Text"),("FindPEntityRefs","Normal Text"),("FindAttributes","Normal Text"),("FindDTDRules","Normal Text"),("Comment","Comment"),("CDATA","Normal Text"),("PI","Normal Text"),("Doctype","Normal Text"),("Doctype Internal Subset","Normal Text"),("Doctype Markupdecl","Normal Text"),("Doctype Markupdecl DQ","Value"),("Doctype Markupdecl SQ","Value"),("El Open","Normal Text"),("El Close","Normal Text"),("El Close 2","Normal Text"),("El Close 3","Normal Text"),("CSS","Normal Text"),("CSS content","Normal Text"),("JS","Normal Text"),("JS content","Normal Text"),("JS comment close","Comment"),("Value","Normal Text"),("Value NQ","Normal Text"),("Value DQ","Value"),("Value SQ","Value")]

parseRules "Start" = 
  do (attr, result) <- (((pRegExpr regex_'5c'7b'25'5cs'2aend'5ba'2dz'5d'2b'5cs'2a'25'5c'7d >>= withAttribute "Mismatched Block Tag"))
                        <|>
                        ((parseRules "FindTemplate"))
                        <|>
                        ((parseRules "FindHTML")))
     return (attr, result)

parseRules "In Block" = 
  do (attr, result) <- (((lookAhead (pRegExpr regex_'5c'7b'25'5cs'2aend'5ba'2dz'5d'2b'5cs'2a'25'5c'7d) >> return ([],"") ) >>~ (popContext))
                        <|>
                        ((parseRules "FindTemplate"))
                        <|>
                        ((parseRules "FindHTML")))
     return (attr, result)

parseRules "FindTemplate" = 
  do (attr, result) <- (((pRegExpr regex_'5c'7b'25'5cs'2acomment'5cs'2a'25'5c'7d >>= withAttribute "Template Comment") >>~ pushContext "Template Comment")
                        <|>
                        ((pDetect2Chars False '{' '{' >>= withAttribute "Template Var") >>~ pushContext "Template Var")
                        <|>
                        ((pDetect2Chars False '{' '%' >>= withAttribute "Template Tag") >>~ pushContext "Template Tag"))
     return (attr, result)

parseRules "Template Comment" = 
  do (attr, result) <- ((pRegExpr regex_'5c'7b'25'5cs'2aendcomment'5cs'2a'25'5c'7d >>= withAttribute "Template Comment") >>~ (popContext))
     return (attr, result)

parseRules "Template Var" = 
  do (attr, result) <- (((pDetect2Chars False '}' '}' >>= withAttribute "Template Var") >>~ (popContext))
                        <|>
                        ((pDetectChar False '|' >>= withAttribute "Template Filter") >>~ pushContext "Template Filter")
                        <|>
                        ((pDetect2Chars False '{' '{' >>= withAttribute "Error"))
                        <|>
                        ((pDetect2Chars False '{' '%' >>= withAttribute "Error"))
                        <|>
                        ((pDetect2Chars False '%' '}' >>= withAttribute "Error")))
     return (attr, result)

parseRules "Template Filter" = 
  do (attr, result) <- (((pDetect2Chars False '}' '}' >>= withAttribute "Template Var") >>~ (popContext >> popContext))
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "Template String") >>~ pushContext "Single A-string")
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "Template String") >>~ pushContext "Single Q-string")
                        <|>
                        ((pDetect2Chars False '{' '{' >>= withAttribute "Error"))
                        <|>
                        ((pDetect2Chars False '{' '%' >>= withAttribute "Error"))
                        <|>
                        ((pDetect2Chars False '%' '}' >>= withAttribute "Error")))
     return (attr, result)

parseRules "Template Tag" = 
  do (attr, result) <- (((lookAhead (pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_blocktags) >> return ([],"") ) >>~ pushContext "Found Block Tag")
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Template Tag") >>~ pushContext "In Template Tag"))
     return (attr, result)

parseRules "Found Block Tag" = 
  do (attr, result) <- ((pRegExpr regex_'28'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29 >>= withAttribute "Template Tag") >>~ pushContext "In Block Tag")
     return (attr, result)

parseRules "In Block Tag" = 
  do (attr, result) <- (((pRegExprDynamic "\\{%\\s*end%1\\s*%\\}" >>= withAttribute "Template Tag") >>~ (popContext >> popContext >> popContext))
                        <|>
                        ((lookAhead (pRegExpr regex_'5c'7b'25'5cs'2aend'5ba'2dz'5d'2b'5cs'2a'25'5c'7d) >> return ([],"") ) >>~ pushContext "Non Matching Tag")
                        <|>
                        ((pDetect2Chars False '%' '}' >>= withAttribute "Template Tag") >>~ pushContext "In Block")
                        <|>
                        ((parseRules "In Template Tag")))
     return (attr, result)

parseRules "Non Matching Tag" = 
  do (attr, result) <- (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_endblocktags >>= withAttribute "Mismatched Block Tag") >>~ (popContext))
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Template Tag") >>~ (popContext)))
     return (attr, result)

parseRules "In Template Tag" = 
  do (attr, result) <- (((pDetect2Chars False '%' '}' >>= withAttribute "Template Tag") >>~ (popContext >> popContext))
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "Template String") >>~ pushContext "Single A-string")
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "Template String") >>~ pushContext "Single Q-string")
                        <|>
                        ((pDetect2Chars False '{' '{' >>= withAttribute "Error"))
                        <|>
                        ((pDetect2Chars False '{' '%' >>= withAttribute "Error"))
                        <|>
                        ((pDetect2Chars False '}' '}' >>= withAttribute "Error")))
     return (attr, result)

parseRules "Single A-string" = 
  do (attr, result) <- (((pHlCStringChar >>= withAttribute "Template String"))
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "Template String") >>~ (popContext)))
     return (attr, result)

parseRules "Single Q-string" = 
  do (attr, result) <- (((pHlCStringChar >>= withAttribute "Template String"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "Template String") >>~ (popContext)))
     return (attr, result)

parseRules "FindHTML" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Normal Text"))
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Normal Text"))
                        <|>
                        ((pString False "<!--" >>= withAttribute "Comment") >>~ pushContext "Comment")
                        <|>
                        ((pString False "<![CDATA[" >>= withAttribute "CDATA") >>~ pushContext "CDATA")
                        <|>
                        ((pRegExpr regex_'3c'21DOCTYPE'5cs'2b >>= withAttribute "Doctype") >>~ pushContext "Doctype")
                        <|>
                        ((pRegExpr regex_'3c'5c'3f'5b'5cw'3a'2d'5d'2a >>= withAttribute "Processing Instruction") >>~ pushContext "PI")
                        <|>
                        ((pRegExpr regex_'3cstyle'5cb >>= withAttribute "Element") >>~ pushContext "CSS")
                        <|>
                        ((pRegExpr regex_'3cscript'5cb >>= withAttribute "Element") >>~ pushContext "JS")
                        <|>
                        ((pRegExpr regex_'3cpre'5cb >>= withAttribute "Element") >>~ pushContext "El Open")
                        <|>
                        ((pRegExpr regex_'3cdiv'5cb >>= withAttribute "Element") >>~ pushContext "El Open")
                        <|>
                        ((pRegExpr regex_'3ctable'5cb >>= withAttribute "Element") >>~ pushContext "El Open")
                        <|>
                        ((pRegExpr regex_'3c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute "Element") >>~ pushContext "El Open")
                        <|>
                        ((pRegExpr regex_'3c'2fpre'5cb >>= withAttribute "Element") >>~ pushContext "El Close")
                        <|>
                        ((pRegExpr regex_'3c'2fdiv'5cb >>= withAttribute "Element") >>~ pushContext "El Close")
                        <|>
                        ((pRegExpr regex_'3c'2ftable'5cb >>= withAttribute "Element") >>~ pushContext "El Close")
                        <|>
                        ((pRegExpr regex_'3c'2f'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute "Element") >>~ pushContext "El Close")
                        <|>
                        ((parseRules "FindDTDRules"))
                        <|>
                        ((parseRules "FindEntityRefs")))
     return (attr, result)

parseRules "FindEntityRefs" = 
  do (attr, result) <- (((pRegExpr regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b >>= withAttribute "EntityRef"))
                        <|>
                        ((pAnyChar "&<" >>= withAttribute "Error")))
     return (attr, result)

parseRules "FindPEntityRefs" = 
  do (attr, result) <- (((pRegExpr regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b >>= withAttribute "EntityRef"))
                        <|>
                        ((pRegExpr regex_'25'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'3b >>= withAttribute "PEntityRef"))
                        <|>
                        ((pAnyChar "&%" >>= withAttribute "Error")))
     return (attr, result)

parseRules "FindAttributes" = 
  do (attr, result) <- (((pColumn 0 >> pRegExpr regex_'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute "Attribute"))
                        <|>
                        ((pRegExpr regex_'5cs'2b'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute "Attribute"))
                        <|>
                        ((pDetectChar False '=' >>= withAttribute "Attribute") >>~ pushContext "Value"))
     return (attr, result)

parseRules "FindDTDRules" = 
  do (attr, result) <- ((pRegExpr regex_'3c'21'28ELEMENT'7cENTITY'7cATTLIST'7cNOTATION'29'5cb >>= withAttribute "Doctype") >>~ pushContext "Doctype Markupdecl")
     return (attr, result)

parseRules "Comment" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Comment"))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Alert.parseExpression))
                        <|>
                        ((parseRules "FindTemplate"))
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Comment"))
                        <|>
                        ((pString False "-->" >>= withAttribute "Comment") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'2d'28'2d'28'3f'21'2d'3e'29'29'2b >>= withAttribute "Error")))
     return (attr, result)

parseRules "CDATA" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Normal Text"))
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Normal Text"))
                        <|>
                        ((pString False "]]>" >>= withAttribute "CDATA") >>~ (popContext))
                        <|>
                        ((pString False "]]&gt;" >>= withAttribute "EntityRef")))
     return (attr, result)

parseRules "PI" = 
  do (attr, result) <- ((pDetect2Chars False '?' '>' >>= withAttribute "Processing Instruction") >>~ (popContext))
     return (attr, result)

parseRules "Doctype" = 
  do (attr, result) <- (((pDetectChar False '>' >>= withAttribute "Doctype") >>~ (popContext))
                        <|>
                        ((pDetectChar False '[' >>= withAttribute "Doctype") >>~ pushContext "Doctype Internal Subset"))
     return (attr, result)

parseRules "Doctype Internal Subset" = 
  do (attr, result) <- (((pDetectChar False ']' >>= withAttribute "Doctype") >>~ (popContext))
                        <|>
                        ((parseRules "FindDTDRules"))
                        <|>
                        ((pString False "<!--" >>= withAttribute "Comment") >>~ pushContext "Comment")
                        <|>
                        ((pRegExpr regex_'3c'5c'3f'5b'5cw'3a'2d'5d'2a >>= withAttribute "Processing Instruction") >>~ pushContext "PI")
                        <|>
                        ((parseRules "FindPEntityRefs")))
     return (attr, result)

parseRules "Doctype Markupdecl" = 
  do (attr, result) <- (((pDetectChar False '>' >>= withAttribute "Doctype") >>~ (popContext))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "Value") >>~ pushContext "Doctype Markupdecl DQ")
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "Value") >>~ pushContext "Doctype Markupdecl SQ"))
     return (attr, result)

parseRules "Doctype Markupdecl DQ" = 
  do (attr, result) <- (((pDetectChar False '"' >>= withAttribute "Value") >>~ (popContext))
                        <|>
                        ((parseRules "FindPEntityRefs")))
     return (attr, result)

parseRules "Doctype Markupdecl SQ" = 
  do (attr, result) <- (((pDetectChar False '\'' >>= withAttribute "Value") >>~ (popContext))
                        <|>
                        ((parseRules "FindPEntityRefs")))
     return (attr, result)

parseRules "El Open" = 
  do (attr, result) <- (((pDetect2Chars False '/' '>' >>= withAttribute "Element") >>~ (popContext))
                        <|>
                        ((pDetectChar False '>' >>= withAttribute "Element") >>~ (popContext))
                        <|>
                        ((parseRules "FindAttributes"))
                        <|>
                        ((parseRules "FindTemplate"))
                        <|>
                        ((pRegExpr regex_'5cS >>= withAttribute "Error")))
     return (attr, result)

parseRules "El Close" = 
  do (attr, result) <- (((pDetectChar False '>' >>= withAttribute "Element") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5cS >>= withAttribute "Error")))
     return (attr, result)

parseRules "El Close 2" = 
  do (attr, result) <- (((pDetectChar False '>' >>= withAttribute "Element") >>~ (popContext >> popContext >> popContext))
                        <|>
                        ((pRegExpr regex_'5cS >>= withAttribute "Error")))
     return (attr, result)

parseRules "El Close 3" = 
  do (attr, result) <- (((pDetectChar False '>' >>= withAttribute "Element") >>~ (popContext >> popContext >> popContext >> popContext))
                        <|>
                        ((pRegExpr regex_'5cS >>= withAttribute "Error")))
     return (attr, result)

parseRules "CSS" = 
  do (attr, result) <- (((pDetect2Chars False '/' '>' >>= withAttribute "Element") >>~ (popContext))
                        <|>
                        ((pDetectChar False '>' >>= withAttribute "Element") >>~ pushContext "CSS content")
                        <|>
                        ((parseRules "FindAttributes"))
                        <|>
                        ((parseRules "FindTemplate"))
                        <|>
                        ((pRegExpr regex_'5cS >>= withAttribute "Error")))
     return (attr, result)

parseRules "CSS content" = 
  do (attr, result) <- (((pRegExpr regex_'3c'2fstyle'5cb >>= withAttribute "Element") >>~ pushContext "El Close 2")
                        <|>
                        ((parseRules "FindTemplate"))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Css.parseExpression)))
     return (attr, result)

parseRules "JS" = 
  do (attr, result) <- (((pDetect2Chars False '/' '>' >>= withAttribute "Element") >>~ (popContext))
                        <|>
                        ((pDetectChar False '>' >>= withAttribute "Element") >>~ pushContext "JS content")
                        <|>
                        ((parseRules "FindTemplate"))
                        <|>
                        ((parseRules "FindAttributes"))
                        <|>
                        ((pRegExpr regex_'5cS >>= withAttribute "Error")))
     return (attr, result)

parseRules "JS content" = 
  do (attr, result) <- (((pRegExpr regex_'3c'2fscript'5cb >>= withAttribute "Element") >>~ pushContext "El Close 2")
                        <|>
                        ((pRegExpr regex_'2f'2f'28'3f'3d'2e'2a'3c'2fscript'5cb'29 >>= withAttribute "Comment") >>~ pushContext "JS comment close")
                        <|>
                        ((parseRules "FindTemplate"))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Javascript.parseExpression)))
     return (attr, result)

parseRules "JS comment close" = 
  do (attr, result) <- (((pRegExpr regex_'3c'2fscript'5cb >>= withAttribute "Element") >>~ pushContext "El Close 3")
                        <|>
                        ((parseRules "FindTemplate"))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Alert.parseExpression)))
     return (attr, result)

parseRules "Value" = 
  do (attr, result) <- (((pDetectChar False '"' >>= withAttribute "Value") >>~ pushContext "Value DQ")
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "Value") >>~ pushContext "Value SQ")
                        <|>
                        ((pDetectSpaces >>= withAttribute "Normal Text"))
                        <|>
                        (pushContext "Value NQ" >> return ([], "")))
     return (attr, result)

parseRules "Value NQ" = 
  do (attr, result) <- (((parseRules "FindEntityRefs"))
                        <|>
                        ((parseRules "FindTemplate"))
                        <|>
                        ((pRegExpr regex_'2f'28'3f'21'3e'29 >>= withAttribute "Value"))
                        <|>
                        ((pRegExpr regex_'5b'5e'2f'3e'3c'22'27'5cs'5d >>= withAttribute "Value"))
                        <|>
                        ((popContext >> popContext) >> return ([], "")))
     return (attr, result)

parseRules "Value DQ" = 
  do (attr, result) <- (((pDetectChar False '"' >>= withAttribute "Value") >>~ (popContext >> popContext))
                        <|>
                        ((parseRules "FindTemplate"))
                        <|>
                        ((parseRules "FindEntityRefs")))
     return (attr, result)

parseRules "Value SQ" = 
  do (attr, result) <- (((pDetectChar False '\'' >>= withAttribute "Value") >>~ (popContext >> popContext))
                        <|>
                        ((parseRules "FindTemplate"))
                        <|>
                        ((parseRules "FindEntityRefs")))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
