{- This module was generated from data in the Kate syntax highlighting file desktop.xml, version 1.04,
   by   -}

module Text.Highlighting.Kate.Syntax.Desktop ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

-- | Full name of language.
syntaxName :: String
syntaxName = ".desktop"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.desktop;*.kdelnk"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = ".desktop" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [(".desktop",["Normal"])], synStLanguage = ".desktop", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Normal" -> return () >> pHandleEndLine
    "Value" -> (popContext) >> pEndLine
    "Comment" -> (popContext) >> pEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Section","kw"),("Key","dt"),("Language","dv"),("Comment","co")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))


regex_'5c'5b'2e'2a'5c'5d'24 = compileRegex "\\[.*\\]$"
regex_'5c'5b'2e'2a'5c'5d = compileRegex "\\[.*\\]"

defaultAttributes = [("Normal","Key"),("Value","Normal Text"),("Comment","Comment")]

parseRules "Normal" = 
  do (attr, result) <- (((pColumn 0 >> pRegExpr regex_'5c'5b'2e'2a'5c'5d'24 >>= withAttribute "Section"))
                        <|>
                        ((pRegExpr regex_'5c'5b'2e'2a'5c'5d >>= withAttribute "Language") >>~ pushContext "Value")
                        <|>
                        ((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute "Comment") >>~ pushContext "Comment")
                        <|>
                        ((pDetectChar False '=' >>= withAttribute "Normal Text") >>~ pushContext "Value"))
     return (attr, result)

parseRules "Value" = 
  pzero

parseRules "Comment" = 
  pzero

parseRules x = fail $ "Unknown context" ++ x
