{- This module was generated from data in the Kate syntax highlighting file bash.xml, version 2.12,
   by  Wilbert Berendsen (wilbert@kde.nl) -}

module Text.Highlighting.Kate.Syntax.Bash ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "Bash"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.sh;*.bash;*.ebuild;*.eclass;.bashrc;.bash_profile;.bash_login;.profile"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Bash" }
  context <- currentContext <|> (pushContext "Start" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("Bash",["Start"])], synStLanguage = "Bash", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Start" -> return () >> pHandleEndLine
    "FindAll" -> return () >> pHandleEndLine
    "FindMost" -> return () >> pHandleEndLine
    "FindComments" -> (popContext) >> pEndLine
    "Comment" -> (popContext) >> pEndLine
    "FindCommentsParen" -> (popContext) >> pEndLine
    "CommentParen" -> (popContext) >> pEndLine
    "FindCommentsBackq" -> (popContext) >> pEndLine
    "CommentBackq" -> (popContext) >> pEndLine
    "FindCommands" -> return () >> pHandleEndLine
    "FindOthers" -> return () >> pHandleEndLine
    "FindStrings" -> return () >> pHandleEndLine
    "FindSubstitutions" -> return () >> pHandleEndLine
    "FindTests" -> return () >> pHandleEndLine
    "ExprDblParen" -> return () >> pHandleEndLine
    "ExprDblParenSubst" -> return () >> pHandleEndLine
    "ExprSubParen" -> return () >> pHandleEndLine
    "ExprBracket" -> return () >> pHandleEndLine
    "ExprDblBracket" -> return () >> pHandleEndLine
    "Group" -> return () >> pHandleEndLine
    "SubShell" -> return () >> pHandleEndLine
    "Assign" -> (popContext) >> pEndLine
    "AssignArray" -> (popContext) >> pEndLine
    "AssignSubscr" -> (popContext) >> pEndLine
    "Subscript" -> return () >> pHandleEndLine
    "FunctionDef" -> (popContext) >> pEndLine
    "VarName" -> (popContext) >> pEndLine
    "ProcessSubst" -> return () >> pHandleEndLine
    "StringSQ" -> return () >> pHandleEndLine
    "StringDQ" -> return () >> pHandleEndLine
    "StringEsc" -> return () >> pHandleEndLine
    "VarBrace" -> return () >> pHandleEndLine
    "VarAlt" -> return () >> pHandleEndLine
    "VarSubst" -> return () >> pHandleEndLine
    "VarSubst2" -> return () >> pHandleEndLine
    "VarSub" -> return () >> pHandleEndLine
    "VarSub2" -> return () >> pHandleEndLine
    "SubstFile" -> return () >> pHandleEndLine
    "SubstCommand" -> return () >> pHandleEndLine
    "SubstBackq" -> return () >> pHandleEndLine
    "Case" -> return () >> pHandleEndLine
    "CaseIn" -> return () >> pHandleEndLine
    "CaseExpr" -> return () >> pHandleEndLine
    "HereDoc" -> return () >> pHandleEndLine
    "HereDocRemainder" -> (popContext) >> pEndLine
    "HereDocQ" -> return () >> pHandleEndLine
    "HereDocNQ" -> return () >> pHandleEndLine
    "HereDocIQ" -> return () >> pHandleEndLine
    "HereDocINQ" -> return () >> pHandleEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Comment","co"),("Keyword","kw"),("Control","kw"),("Builtin","kw"),("Command","kw"),("Redirection","kw"),("Escape","dt"),("String SingleQ","st"),("String DoubleQ","st"),("Backquote","kw"),("String Transl.","st"),("String Escape","dt"),("Variable","ot"),("Expression","ot"),("Function","fu"),("Error","er")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "else for function in select until while elif then set"
list_builtins = Set.fromList $ words $ ": source alias bg bind break builtin cd caller command compgen complete continue dirs disown echo enable eval exec exit fc fg getopts hash help history jobs kill let logout popd printf pushd pwd return set shift shopt suspend test time times trap type ulimit umask unalias wait"
list_builtins'5fvar = Set.fromList $ words $ "export unset declare typeset local read readonly"
list_unixcommands = Set.fromList $ words $ "arch awk bash bunzip2 bzcat bzcmp bzdiff bzegrep bzfgrep bzgrep bzip2 bzip2recover bzless bzmore cat chattr chgrp chmod chown chvt cp date dd deallocvt df dir dircolors dmesg dnsdomainname domainname du dumpkeys echo ed egrep false fgconsole fgrep fuser gawk getkeycodes gocr grep groff groups gunzip gzexe gzip hostname igawk install kbd_mode kbdrate killall last lastb link ln loadkeys loadunimap login ls lsattr lsmod lsmod.old lzcat lzcmp lzdiff lzegrep lzfgrep lzgrep lzless lzcat lzma lzmainfo lzmore mapscrn mesg mkdir mkfifo mknod mktemp more mount mv nano netstat nisdomainname nroff openvt pgawk pidof ping ps pstree pwd rbash readlink red resizecons rm rmdir run-parts sash sed setfont setkeycodes setleds setmetamode setserial sh showkey shred sleep ssed stat stty su sync tar tempfile touch troff true umount uname unicode_start unicode_stop unlink unlzma unxz utmpdump uuidgen vdir wall wc xz xzcat ypdomainname zcat zcmp zdiff zegrep zfgrep zforce zgrep zless zmore znew zsh aclocal aconnect aplay apm apmsleep apropos ar arecord as as86 autoconf autoheader automake awk basename bc bison c++ cal cat cc cdda2wav cdparanoia cdrdao cd-read cdrecord chfn chgrp chmod chown chroot chsh clear cmp co col comm cp cpio cpp cut dc dd df diff diff3 dir dircolors directomatic dirname du env expr fbset file find flex flex++ fmt free ftp funzip fuser g++ gawk gc gcc gdb getent getopt gettext gettextize gimp gimp-remote gimptool gmake gs head hexdump id install join kill killall ld ld86 ldd less lex ln locate lockfile logname lp lpr ls lynx m4 make man mkdir mknod msgfmt mv namei nasm nawk nice nl nm nm86 nmap nohup nop od passwd patch pcregrep pcretest perl perror pidof pr printf procmail prune ps2ascii ps2epsi ps2frag ps2pdf ps2ps psbook psmerge psnup psresize psselect pstops rcs rev rm scp sed seq setterm shred size size86 skill slogin snice sort sox split ssh ssh-add ssh-agent ssh-keygen ssh-keyscan stat strings strip sudo suidperl sum tac tail tee test tr uniq unlink unzip updatedb updmap uptime users vmstat w wc wget whatis whereis which who whoami write xargs yacc yes zip zsoelim dcop kdialog kfile xhost xmodmap xset"

regex_'5b'5cs'3b'5d'28'3f'3d'23'29 = compileRegex "[\\s;](?=#)"
regex_'5b'5e'29'5d'28'3f'3d'5c'29'29 = compileRegex "[^)](?=\\))"
regex_'5b'5e'60'5d'28'3f'3d'60'29 = compileRegex "[^`](?=`)"
regex_'5c'5b'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex "\\[\\[(?=($|\\s))"
regex_'5cs'5c'5b'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex "\\s\\[\\[(?=($|\\s))"
regex_'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex "\\[(?=($|\\s))"
regex_'5cs'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex "\\s\\[(?=($|\\s))"
regex_'5c'7b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex "\\{(?=($|\\s))"
regex_'5cbdo'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex "\\bdo(?![\\w$+-])"
regex_'5cbdone'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex "\\bdone(?![\\w$+-])"
regex_'5cbif_'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex "\\bif (?![\\w$+-])"
regex_'5cbfi'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex "\\bfi(?![\\w$+-])"
regex_'5cbcase'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex "\\bcase(?![\\w$+-])"
regex_'2d'5bA'2dZa'2dz0'2d9'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex "-[A-Za-z0-9][A-Za-z0-9_]*"
regex_'2d'2d'5ba'2dz'5d'5bA'2dZa'2dz0'2d9'5f'2d'5d'2a = compileRegex "--[a-z][A-Za-z0-9_-]*"
regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'5c'2b'3f'3d = compileRegex "\\b[A-Za-z_][A-Za-z0-9_]*\\+?="
regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'3f'3d'5c'5b'2e'2b'5c'5d'5c'2b'3f'3d'29 = compileRegex "\\b[A-Za-z_][A-Za-z0-9_]*(?=\\[.+\\]\\+?=)"
regex_'5cbfunction'5cb = compileRegex "\\bfunction\\b"
regex_'5c'2e'28'3f'3d'5cs'29 = compileRegex "\\.(?=\\s)"
regex_'5cd'2a'3c'3c'3c = compileRegex "\\d*<<<"
regex_'5b'3c'3e'5d'5c'28 = compileRegex "[<>]\\("
regex_'28'5b0'2d9'5d'2a'28'3e'7b1'2c2'7d'7c'3c'29'28'26'5b0'2d9'5d'2b'2d'3f'29'3f'7c'26'3e'7c'3e'26'7c'5b0'2d9'5d'2a'3c'3e'29 = compileRegex "([0-9]*(>{1,2}|<)(&[0-9]+-?)?|&>|>&|[0-9]*<>)"
regex_'28'5b'7c'26'5d'29'5c1'3f = compileRegex "([|&])\\1?"
regex_'5bA'2dZa'2dz'5f'3a'5d'5bA'2dZa'2dz0'2d9'5f'3a'23'25'40'2d'5d'2a'5cs'2a'5c'28'5c'29 = compileRegex "[A-Za-z_:][A-Za-z0-9_:#%@-]*\\s*\\(\\)"
regex_'5c'5c'5b'5d'5b'3b'5c'5c'24'60'7b'7d'28'29'7c'26'3c'3e'2a_'5d = compileRegex "\\\\[][;\\\\$`{}()|&<>* ]"
regex_'5c'5c'24 = compileRegex "\\\\$"
regex_'5c'7b'28'3f'21'28'5cs'7c'24'29'29'5cS'2a'5c'7d = compileRegex "\\{(?!(\\s|$))\\S*\\}"
regex_'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'2f'29 = compileRegex "([\\w_@.%*?+-]|\\\\ )*(?=/)"
regex_'7e'5cw'2a = compileRegex "~\\w*"
regex_'2f'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'28'5b'5cs'2f'29'3a'3b'24'60'27'22'5d'7c'24'29'29 = compileRegex "/([\\w_@.%*?+-]|\\\\ )*(?=([\\s/):;$`'\"]|$))"
regex_'5c'24'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'5c'5b = compileRegex "\\$[A-Za-z_][A-Za-z0-9_]*\\["
regex_'5c'24'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex "\\$[A-Za-z_][A-Za-z0-9_]*"
regex_'5c'24'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d = compileRegex "\\$[*@#?$!_0-9-]"
regex_'5c'24'5c'7b'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d'5c'7d = compileRegex "\\$\\{[*@#?$!_0-9-]\\}"
regex_'5c'24'5c'7b'23'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'5c'5b'5b'2a'40'5d'5c'5d'29'3f'5c'7d = compileRegex "\\$\\{#[A-Za-z_][A-Za-z0-9_]*(\\[[*@]\\])?\\}"
regex_'5c'24'5c'7b'21'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'5c'5b'5b'2a'40'5d'5c'5d'7c'5b'2a'40'5d'29'3f'5c'7d = compileRegex "\\$\\{![A-Za-z_][A-Za-z0-9_]*(\\[[*@]\\]|[*@])?\\}"
regex_'5c'24'5c'7b'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex "\\$\\{[A-Za-z_][A-Za-z0-9_]*"
regex_'5c'24'5c'7b'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d'28'3f'3d'5b'3a'23'25'2f'3d'3f'2b'2d'5d'29 = compileRegex "\\$\\{[*@#?$!_0-9-](?=[:#%/=?+-])"
regex_'5c'5c'5b'60'24'5c'5c'5d = compileRegex "\\\\[`$\\\\]"
regex_'2d'5babcdefghkprstuwxOGLSNozn'5d'28'3f'3d'5cs'29 = compileRegex "-[abcdefghkprstuwxOGLSNozn](?=\\s)"
regex_'2d'28'5bno'5dt'7cef'29'28'3f'3d'5cs'29 = compileRegex "-([no]t|ef)(?=\\s)"
regex_'28'5b'21'3d'5d'3d'3f'7c'5b'3e'3c'5d'29'28'3f'3d'5cs'29 = compileRegex "([!=]=?|[><])(?=\\s)"
regex_'2d'28eq'7cne'7c'5bgl'5d'5bte'5d'29'28'3f'3d'5cs'29 = compileRegex "-(eq|ne|[gl][te])(?=\\s)"
regex_'5cs'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 = compileRegex "\\s\\](?=($|[\\s;|&]))"
regex_'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 = compileRegex "\\](?=($|[\\s;|&]))"
regex_'5cs'5c'5d'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 = compileRegex "\\s\\]\\](?=($|[\\s;|&]))"
regex_'5c'5d'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 = compileRegex "\\]\\](?=($|[\\s;|&]))"
regex_'5b'5cw'3a'2c'2b'5f'2e'2f'2d'5d = compileRegex "[\\w:,+_./-]"
regex_'5cs'2b'5bA'2dZa'2dz'5f'3a'5d'5bA'2dZa'2dz0'2d9'5f'3a'23'25'40'2d'5d'2a'28'5cs'2a'5c'28'5c'29'29'3f = compileRegex "\\s+[A-Za-z_:][A-Za-z0-9_:#%@-]*(\\s*\\(\\))?"
regex_'2d'5bA'2dZa'2dz0'2d9'5d'2b = compileRegex "-[A-Za-z0-9]+"
regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex "\\b[A-Za-z_][A-Za-z0-9_]*"
regex_'5b'5e'5d'7d'29'7c'3b'60'26'3e'3c'5d = compileRegex "[^]})|;`&><]"
regex_'5c'5c'5b'60'22'5c'5c'24'5cn'5d = compileRegex "\\\\[`\"\\\\$\\n]"
regex_'5c'5c'5babefnrtv'5c'5c'27'5d = compileRegex "\\\\[abefnrtv\\\\']"
regex_'5c'5c'28'5b0'2d7'5d'7b1'2c3'7d'7cx'5bA'2dFa'2df0'2d9'5d'7b1'2c2'7d'7cc'2e'29 = compileRegex "\\\\([0-7]{1,3}|x[A-Fa-f0-9]{1,2}|c.)"
regex_'28'3a'3f'5b'2d'3d'3f'2b'5d'7c'23'23'3f'7c'25'25'3f'29 = compileRegex "(:?[-=?+]|##?|%%?)"
regex_'2f'2f'3f = compileRegex "//?"
regex_'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex "[A-Za-z_][A-Za-z0-9_]*"
regex_'5b0'2d9'5d'2b'28'3f'3d'5b'3a'7d'5d'29 = compileRegex "[0-9]+(?=[:}])"
regex_'5b0'2d9'5d'28'3f'3d'5b'3a'7d'5d'29 = compileRegex "[0-9](?=[:}])"
regex_'5csin'5cb = compileRegex "\\sin\\b"
regex_'5cbesac'28'3f'3d'24'7c'5b'5cs'3b'29'5d'29 = compileRegex "\\besac(?=$|[\\s;)])"
regex_esac'28'3f'3d'24'7c'5b'5cs'3b'29'5d'29 = compileRegex "esac(?=$|[\\s;)])"
regex_'28'3c'3c'2d'5cs'2a'22'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'22'29 = compileRegex "(<<-\\s*\"([^|&;()<>\\s]+)\")"
regex_'28'3c'3c'2d'5cs'2a'27'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'27'29 = compileRegex "(<<-\\s*'([^|&;()<>\\s]+)')"
regex_'28'3c'3c'2d'5cs'2a'5c'5c'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29 = compileRegex "(<<-\\s*\\\\([^|&;()<>\\s]+))"
regex_'28'3c'3c'2d'5cs'2a'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29 = compileRegex "(<<-\\s*([^|&;()<>\\s]+))"
regex_'28'3c'3c'5cs'2a'22'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'22'29 = compileRegex "(<<\\s*\"([^|&;()<>\\s]+)\")"
regex_'28'3c'3c'5cs'2a'27'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'27'29 = compileRegex "(<<\\s*'([^|&;()<>\\s]+)')"
regex_'28'3c'3c'5cs'2a'5c'5c'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29 = compileRegex "(<<\\s*\\\\([^|&;()<>\\s]+))"
regex_'28'3c'3c'5cs'2a'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29 = compileRegex "(<<\\s*([^|&;()<>\\s]+))"

defaultAttributes = [("Start","Normal Text"),("FindAll","Normal Text"),("FindMost","Normal Text"),("FindComments","Normal Text"),("Comment","Comment"),("FindCommentsParen","Normal Text"),("CommentParen","Comment"),("FindCommentsBackq","Normal Text"),("CommentBackq","Comment"),("FindCommands","Normal Text"),("FindOthers","Normal Text"),("FindStrings","Normal Text"),("FindSubstitutions","Normal Text"),("FindTests","Normal Text"),("ExprDblParen","Normal Text"),("ExprDblParenSubst","Normal Text"),("ExprSubParen","Normal Text"),("ExprBracket","Normal Text"),("ExprDblBracket","Normal Text"),("Group","Normal Text"),("SubShell","Normal Text"),("Assign","Normal Text"),("AssignArray","Normal Text"),("AssignSubscr","Normal Text"),("Subscript","Variable"),("FunctionDef","Function"),("VarName","Normal Text"),("ProcessSubst","Normal Text"),("StringSQ","String SingleQ"),("StringDQ","String DoubleQ"),("StringEsc","String SingleQ"),("VarBrace","Error"),("VarAlt","Normal Text"),("VarSubst","Normal Text"),("VarSubst2","Normal Text"),("VarSub","Error"),("VarSub2","Error"),("SubstFile","Normal Text"),("SubstCommand","Normal Text"),("SubstBackq","Normal Text"),("Case","Normal Text"),("CaseIn","Normal Text"),("CaseExpr","Normal Text"),("HereDoc","Normal Text"),("HereDocRemainder","Normal Text"),("HereDocQ","Normal Text"),("HereDocNQ","Normal Text"),("HereDocIQ","Normal Text"),("HereDocINQ","Normal Text")]

parseRules "Start" = 
  do (attr, result) <- ((parseRules "FindAll"))
     return (attr, result)

parseRules "FindAll" = 
  do (attr, result) <- (((parseRules "FindComments"))
                        <|>
                        ((parseRules "FindCommands"))
                        <|>
                        ((parseRules "FindStrings"))
                        <|>
                        ((parseRules "FindSubstitutions"))
                        <|>
                        ((parseRules "FindOthers")))
     return (attr, result)

parseRules "FindMost" = 
  do (attr, result) <- (((parseRules "FindComments"))
                        <|>
                        ((parseRules "FindStrings"))
                        <|>
                        ((parseRules "FindSubstitutions"))
                        <|>
                        ((parseRules "FindOthers")))
     return (attr, result)

parseRules "FindComments" = 
  do (attr, result) <- (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute "Comment") >>~ pushContext "Comment")
                        <|>
                        ((pRegExpr regex_'5b'5cs'3b'5d'28'3f'3d'23'29 >>= withAttribute "Normal Text") >>~ pushContext "Comment"))
     return (attr, result)

parseRules "Comment" = 
  do (attr, result) <- ((Text.Highlighting.Kate.Syntax.Alert.parseExpression))
     return (attr, result)

parseRules "FindCommentsParen" = 
  do (attr, result) <- (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute "Comment") >>~ pushContext "CommentParen")
                        <|>
                        ((pRegExpr regex_'5b'5cs'3b'5d'28'3f'3d'23'29 >>= withAttribute "Normal Text") >>~ pushContext "CommentParen"))
     return (attr, result)

parseRules "CommentParen" = 
  do (attr, result) <- (((pRegExpr regex_'5b'5e'29'5d'28'3f'3d'5c'29'29 >>= withAttribute "Comment") >>~ (popContext))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Alert.parseExpression)))
     return (attr, result)

parseRules "FindCommentsBackq" = 
  do (attr, result) <- (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute "Comment") >>~ pushContext "CommentBackq")
                        <|>
                        ((pRegExpr regex_'5b'5cs'3b'5d'28'3f'3d'23'29 >>= withAttribute "Normal Text") >>~ pushContext "CommentBackq"))
     return (attr, result)

parseRules "CommentBackq" = 
  do (attr, result) <- (((pRegExpr regex_'5b'5e'60'5d'28'3f'3d'60'29 >>= withAttribute "Comment") >>~ (popContext))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Alert.parseExpression)))
     return (attr, result)

parseRules "FindCommands" = 
  do (attr, result) <- (((pDetect2Chars False '(' '(' >>= withAttribute "Keyword") >>~ pushContext "ExprDblParen")
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5c'5b'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute "Keyword") >>~ pushContext "ExprDblBracket")
                        <|>
                        ((pRegExpr regex_'5cs'5c'5b'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute "Keyword") >>~ pushContext "ExprDblBracket")
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute "Builtin") >>~ pushContext "ExprBracket")
                        <|>
                        ((pRegExpr regex_'5cs'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute "Builtin") >>~ pushContext "ExprBracket")
                        <|>
                        ((pRegExpr regex_'5c'7b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute "Keyword") >>~ pushContext "Group")
                        <|>
                        ((pDetectChar False '(' >>= withAttribute "Keyword") >>~ pushContext "SubShell")
                        <|>
                        ((pRegExpr regex_'5cbdo'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cbdone'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cbif_'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cbfi'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cbcase'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute "Keyword") >>~ pushContext "Case")
                        <|>
                        ((pRegExpr regex_'2d'5bA'2dZa'2dz0'2d9'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute "Option"))
                        <|>
                        ((pRegExpr regex_'2d'2d'5ba'2dz'5d'5bA'2dZa'2dz0'2d9'5f'2d'5d'2a >>= withAttribute "Option"))
                        <|>
                        ((pRegExpr regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'5c'2b'3f'3d >>= withAttribute "Variable") >>~ pushContext "Assign")
                        <|>
                        ((pRegExpr regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'3f'3d'5c'5b'2e'2b'5c'5d'5c'2b'3f'3d'29 >>= withAttribute "Variable") >>~ pushContext "AssignSubscr")
                        <|>
                        ((pString False ":()" >>= withAttribute "Function"))
                        <|>
                        ((pRegExpr regex_'5cbfunction'5cb >>= withAttribute "Keyword") >>~ pushContext "FunctionDef")
                        <|>
                        ((pKeyword " \n\t()!+,<=>&*;?|~\\`" list_keywords >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5c'2e'28'3f'3d'5cs'29 >>= withAttribute "Builtin"))
                        <|>
                        ((pKeyword " \n\t()!+,<=>&*;?|~\\`" list_builtins >>= withAttribute "Builtin"))
                        <|>
                        ((pKeyword " \n\t()!+,<=>&*;?|~\\`" list_unixcommands >>= withAttribute "Command"))
                        <|>
                        ((pKeyword " \n\t()!+,<=>&*;?|~\\`" list_builtins'5fvar >>= withAttribute "Builtin") >>~ pushContext "VarName")
                        <|>
                        ((pRegExpr regex_'5cd'2a'3c'3c'3c >>= withAttribute "Redirection"))
                        <|>
                        ((lookAhead (pString False "<<") >> return ([],"") ) >>~ pushContext "HereDoc")
                        <|>
                        ((pRegExpr regex_'5b'3c'3e'5d'5c'28 >>= withAttribute "Redirection") >>~ pushContext "ProcessSubst")
                        <|>
                        ((pRegExpr regex_'28'5b0'2d9'5d'2a'28'3e'7b1'2c2'7d'7c'3c'29'28'26'5b0'2d9'5d'2b'2d'3f'29'3f'7c'26'3e'7c'3e'26'7c'5b0'2d9'5d'2a'3c'3e'29 >>= withAttribute "Redirection"))
                        <|>
                        ((pRegExpr regex_'28'5b'7c'26'5d'29'5c1'3f >>= withAttribute "Control"))
                        <|>
                        ((pRegExpr regex_'5bA'2dZa'2dz'5f'3a'5d'5bA'2dZa'2dz0'2d9'5f'3a'23'25'40'2d'5d'2a'5cs'2a'5c'28'5c'29 >>= withAttribute "Function")))
     return (attr, result)

parseRules "FindOthers" = 
  do (attr, result) <- (((pRegExpr regex_'5c'5c'5b'5d'5b'3b'5c'5c'24'60'7b'7d'28'29'7c'26'3c'3e'2a_'5d >>= withAttribute "Escape"))
                        <|>
                        ((pRegExpr regex_'5c'5c'24 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5c'7b'28'3f'21'28'5cs'7c'24'29'29'5cS'2a'5c'7d >>= withAttribute "Escape"))
                        <|>
                        ((pRegExpr regex_'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'2f'29 >>= withAttribute "Path"))
                        <|>
                        ((pRegExpr regex_'7e'5cw'2a >>= withAttribute "Path"))
                        <|>
                        ((pRegExpr regex_'2f'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'28'5b'5cs'2f'29'3a'3b'24'60'27'22'5d'7c'24'29'29 >>= withAttribute "Path")))
     return (attr, result)

parseRules "FindStrings" = 
  do (attr, result) <- (((pDetect2Chars False '\\' '\'' >>= withAttribute "Escape"))
                        <|>
                        ((pDetect2Chars False '\\' '"' >>= withAttribute "Escape"))
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "String SingleQ") >>~ pushContext "StringSQ")
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String DoubleQ") >>~ pushContext "StringDQ")
                        <|>
                        ((pDetect2Chars False '$' '\'' >>= withAttribute "String SingleQ") >>~ pushContext "StringEsc")
                        <|>
                        ((pDetect2Chars False '$' '"' >>= withAttribute "String Transl.") >>~ pushContext "StringDQ"))
     return (attr, result)

parseRules "FindSubstitutions" = 
  do (attr, result) <- (((pRegExpr regex_'5c'24'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'5c'5b >>= withAttribute "Variable") >>~ pushContext "Subscript")
                        <|>
                        ((pRegExpr regex_'5c'24'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute "Variable"))
                        <|>
                        ((pRegExpr regex_'5c'24'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d >>= withAttribute "Variable"))
                        <|>
                        ((pRegExpr regex_'5c'24'5c'7b'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d'5c'7d >>= withAttribute "Variable"))
                        <|>
                        ((pRegExpr regex_'5c'24'5c'7b'23'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'5c'5b'5b'2a'40'5d'5c'5d'29'3f'5c'7d >>= withAttribute "Variable"))
                        <|>
                        ((pRegExpr regex_'5c'24'5c'7b'21'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'28'5c'5b'5b'2a'40'5d'5c'5d'7c'5b'2a'40'5d'29'3f'5c'7d >>= withAttribute "Variable"))
                        <|>
                        ((pRegExpr regex_'5c'24'5c'7b'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute "Variable") >>~ pushContext "VarBrace")
                        <|>
                        ((pRegExpr regex_'5c'24'5c'7b'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d'28'3f'3d'5b'3a'23'25'2f'3d'3f'2b'2d'5d'29 >>= withAttribute "Variable") >>~ pushContext "VarBrace")
                        <|>
                        ((pString False "$((" >>= withAttribute "Variable") >>~ pushContext "ExprDblParenSubst")
                        <|>
                        ((pString False "$(<" >>= withAttribute "Redirection") >>~ pushContext "SubstFile")
                        <|>
                        ((pString False "$(" >>= withAttribute "Variable") >>~ pushContext "SubstCommand")
                        <|>
                        ((pDetectChar False '`' >>= withAttribute "Backquote") >>~ pushContext "SubstBackq")
                        <|>
                        ((pRegExpr regex_'5c'5c'5b'60'24'5c'5c'5d >>= withAttribute "Escape")))
     return (attr, result)

parseRules "FindTests" = 
  do (attr, result) <- (((pRegExpr regex_'2d'5babcdefghkprstuwxOGLSNozn'5d'28'3f'3d'5cs'29 >>= withAttribute "Expression"))
                        <|>
                        ((pRegExpr regex_'2d'28'5bno'5dt'7cef'29'28'3f'3d'5cs'29 >>= withAttribute "Expression"))
                        <|>
                        ((pRegExpr regex_'28'5b'21'3d'5d'3d'3f'7c'5b'3e'3c'5d'29'28'3f'3d'5cs'29 >>= withAttribute "Expression"))
                        <|>
                        ((pRegExpr regex_'2d'28eq'7cne'7c'5bgl'5d'5bte'5d'29'28'3f'3d'5cs'29 >>= withAttribute "Expression")))
     return (attr, result)

parseRules "ExprDblParen" = 
  do (attr, result) <- (((pDetect2Chars False ')' ')' >>= withAttribute "Keyword") >>~ (popContext))
                        <|>
                        ((pDetectChar False '(' >>= withAttribute "Normal Text") >>~ pushContext "ExprSubParen")
                        <|>
                        ((parseRules "FindMost")))
     return (attr, result)

parseRules "ExprDblParenSubst" = 
  do (attr, result) <- (((pDetect2Chars False ')' ')' >>= withAttribute "Variable") >>~ (popContext))
                        <|>
                        ((pDetectChar False '(' >>= withAttribute "Normal Text") >>~ pushContext "ExprSubParen")
                        <|>
                        ((parseRules "FindMost")))
     return (attr, result)

parseRules "ExprSubParen" = 
  do (attr, result) <- (((pDetectChar False ')' >>= withAttribute "Normal Text") >>~ (popContext))
                        <|>
                        ((pDetectChar False '(' >>= withAttribute "Normal Text") >>~ pushContext "ExprSubParen")
                        <|>
                        ((parseRules "FindMost")))
     return (attr, result)

parseRules "ExprBracket" = 
  do (attr, result) <- (((pRegExpr regex_'5cs'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 >>= withAttribute "Builtin") >>~ (popContext))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 >>= withAttribute "Builtin") >>~ (popContext))
                        <|>
                        ((pDetectChar False '(' >>= withAttribute "Normal Text") >>~ pushContext "ExprSubParen")
                        <|>
                        ((parseRules "FindTests"))
                        <|>
                        ((parseRules "FindMost")))
     return (attr, result)

parseRules "ExprDblBracket" = 
  do (attr, result) <- (((pRegExpr regex_'5cs'5c'5d'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 >>= withAttribute "Keyword") >>~ (popContext))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5c'5d'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 >>= withAttribute "Keyword") >>~ (popContext))
                        <|>
                        ((pDetectChar False '(' >>= withAttribute "Normal Text") >>~ pushContext "ExprSubParen")
                        <|>
                        ((parseRules "FindTests"))
                        <|>
                        ((parseRules "FindMost")))
     return (attr, result)

parseRules "Group" = 
  do (attr, result) <- (((pDetectChar False '}' >>= withAttribute "Keyword") >>~ (popContext))
                        <|>
                        ((parseRules "FindAll")))
     return (attr, result)

parseRules "SubShell" = 
  do (attr, result) <- (((pDetectChar False ')' >>= withAttribute "Keyword") >>~ (popContext))
                        <|>
                        ((parseRules "FindAll")))
     return (attr, result)

parseRules "Assign" = 
  do (attr, result) <- (((pDetectChar False '(' >>= withAttribute "Variable") >>~ pushContext "AssignArray")
                        <|>
                        ((parseRules "FindStrings"))
                        <|>
                        ((parseRules "FindSubstitutions"))
                        <|>
                        ((parseRules "FindOthers"))
                        <|>
                        ((pRegExpr regex_'5b'5cw'3a'2c'2b'5f'2e'2f'2d'5d >>= withAttribute "Normal Text"))
                        <|>
                        ((popContext) >> return ([], "")))
     return (attr, result)

parseRules "AssignArray" = 
  do (attr, result) <- (((pDetectChar False ')' >>= withAttribute "Variable") >>~ (popContext))
                        <|>
                        ((pDetectChar False '[' >>= withAttribute "Variable") >>~ pushContext "Subscript")
                        <|>
                        ((pDetectChar False '=' >>= withAttribute "Variable") >>~ pushContext "Assign")
                        <|>
                        ((parseRules "FindMost")))
     return (attr, result)

parseRules "AssignSubscr" = 
  do (attr, result) <- (((pDetectChar False '[' >>= withAttribute "Variable") >>~ pushContext "Subscript")
                        <|>
                        ((pDetect2Chars False '+' '=' >>= withAttribute "Variable") >>~ pushContext "Assign")
                        <|>
                        ((pDetectChar False '=' >>= withAttribute "Variable") >>~ pushContext "Assign")
                        <|>
                        ((parseRules "FindStrings"))
                        <|>
                        ((parseRules "FindSubstitutions"))
                        <|>
                        ((parseRules "FindOthers"))
                        <|>
                        ((popContext) >> return ([], "")))
     return (attr, result)

parseRules "Subscript" = 
  do (attr, result) <- (((pDetectChar False ']' >>= withAttribute "Variable") >>~ (popContext))
                        <|>
                        ((parseRules "FindStrings"))
                        <|>
                        ((parseRules "FindSubstitutions"))
                        <|>
                        ((parseRules "FindOthers")))
     return (attr, result)

parseRules "FunctionDef" = 
  do (attr, result) <- (((pRegExpr regex_'5cs'2b'5bA'2dZa'2dz'5f'3a'5d'5bA'2dZa'2dz0'2d9'5f'3a'23'25'40'2d'5d'2a'28'5cs'2a'5c'28'5c'29'29'3f >>= withAttribute "Function") >>~ (popContext))
                        <|>
                        ((popContext) >> return ([], "")))
     return (attr, result)

parseRules "VarName" = 
  do (attr, result) <- (((pRegExpr regex_'2d'5bA'2dZa'2dz0'2d9'5d'2b >>= withAttribute "Option"))
                        <|>
                        ((pRegExpr regex_'2d'2d'5ba'2dz'5d'5bA'2dZa'2dz0'2d9'5f'2d'5d'2a >>= withAttribute "Option"))
                        <|>
                        ((pRegExpr regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute "Variable"))
                        <|>
                        ((pDetectChar False '[' >>= withAttribute "Variable") >>~ pushContext "Subscript")
                        <|>
                        ((pDetectChar False '=' >>= withAttribute "Variable") >>~ pushContext "Assign")
                        <|>
                        ((parseRules "FindMost"))
                        <|>
                        ((pRegExpr regex_'5b'5e'5d'7d'29'7c'3b'60'26'3e'3c'5d >>= withAttribute "Normal Text"))
                        <|>
                        ((popContext) >> return ([], "")))
     return (attr, result)

parseRules "ProcessSubst" = 
  do (attr, result) <- (((pDetectChar False ')' >>= withAttribute "Redirection") >>~ (popContext))
                        <|>
                        ((parseRules "FindCommentsParen"))
                        <|>
                        ((parseRules "FindCommands"))
                        <|>
                        ((parseRules "FindStrings"))
                        <|>
                        ((parseRules "FindSubstitutions"))
                        <|>
                        ((parseRules "FindOthers")))
     return (attr, result)

parseRules "StringSQ" = 
  do (attr, result) <- ((pDetectChar False '\'' >>= withAttribute "String SingleQ") >>~ (popContext))
     return (attr, result)

parseRules "StringDQ" = 
  do (attr, result) <- (((pDetectChar False '"' >>= withAttribute "String DoubleQ") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5c'5c'5b'60'22'5c'5c'24'5cn'5d >>= withAttribute "String Escape"))
                        <|>
                        ((parseRules "FindSubstitutions")))
     return (attr, result)

parseRules "StringEsc" = 
  do (attr, result) <- (((pDetectChar False '\'' >>= withAttribute "String SingleQ") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5c'5c'5babefnrtv'5c'5c'27'5d >>= withAttribute "String Escape"))
                        <|>
                        ((pRegExpr regex_'5c'5c'28'5b0'2d7'5d'7b1'2c3'7d'7cx'5bA'2dFa'2df0'2d9'5d'7b1'2c2'7d'7cc'2e'29 >>= withAttribute "String Escape")))
     return (attr, result)

parseRules "VarBrace" = 
  do (attr, result) <- (((pDetectChar False '}' >>= withAttribute "Variable") >>~ (popContext))
                        <|>
                        ((pDetectChar False '[' >>= withAttribute "Variable") >>~ pushContext "Subscript")
                        <|>
                        ((pRegExpr regex_'28'3a'3f'5b'2d'3d'3f'2b'5d'7c'23'23'3f'7c'25'25'3f'29 >>= withAttribute "Variable") >>~ pushContext "VarAlt")
                        <|>
                        ((pRegExpr regex_'2f'2f'3f >>= withAttribute "Variable") >>~ pushContext "VarSubst")
                        <|>
                        ((pDetectChar False ':' >>= withAttribute "Variable") >>~ pushContext "VarSub"))
     return (attr, result)

parseRules "VarAlt" = 
  do (attr, result) <- (((pDetectChar False '}' >>= withAttribute "Variable") >>~ (popContext >> popContext))
                        <|>
                        ((parseRules "FindStrings"))
                        <|>
                        ((parseRules "FindSubstitutions")))
     return (attr, result)

parseRules "VarSubst" = 
  do (attr, result) <- (((pDetectChar False '}' >>= withAttribute "Variable") >>~ (popContext >> popContext))
                        <|>
                        ((pDetectChar False '/' >>= withAttribute "Variable") >>~ pushContext "VarSubst2")
                        <|>
                        ((parseRules "FindStrings"))
                        <|>
                        ((parseRules "FindSubstitutions")))
     return (attr, result)

parseRules "VarSubst2" = 
  do (attr, result) <- (((pDetectChar False '}' >>= withAttribute "Variable") >>~ (popContext >> popContext >> popContext))
                        <|>
                        ((parseRules "FindStrings"))
                        <|>
                        ((parseRules "FindSubstitutions")))
     return (attr, result)

parseRules "VarSub" = 
  do (attr, result) <- (((pDetectChar False ':' >>= withAttribute "Variable") >>~ pushContext "VarSub2")
                        <|>
                        ((pDetectChar False '}' >>= withAttribute "Variable") >>~ (popContext >> popContext))
                        <|>
                        ((pRegExpr regex_'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute "Variable"))
                        <|>
                        ((pRegExpr regex_'5b0'2d9'5d'2b'28'3f'3d'5b'3a'7d'5d'29 >>= withAttribute "Variable"))
                        <|>
                        ((parseRules "FindSubstitutions")))
     return (attr, result)

parseRules "VarSub2" = 
  do (attr, result) <- (((pDetectChar False '}' >>= withAttribute "Variable") >>~ (popContext >> popContext >> popContext))
                        <|>
                        ((pRegExpr regex_'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute "Variable"))
                        <|>
                        ((pRegExpr regex_'5b0'2d9'5d'28'3f'3d'5b'3a'7d'5d'29 >>= withAttribute "Variable"))
                        <|>
                        ((parseRules "FindSubstitutions")))
     return (attr, result)

parseRules "SubstFile" = 
  do (attr, result) <- (((pDetectChar False ')' >>= withAttribute "Redirection") >>~ (popContext))
                        <|>
                        ((parseRules "FindCommentsParen"))
                        <|>
                        ((parseRules "FindStrings"))
                        <|>
                        ((parseRules "FindSubstitutions"))
                        <|>
                        ((parseRules "FindOthers")))
     return (attr, result)

parseRules "SubstCommand" = 
  do (attr, result) <- (((pDetectChar False ')' >>= withAttribute "Variable") >>~ (popContext))
                        <|>
                        ((parseRules "FindCommentsParen"))
                        <|>
                        ((parseRules "FindCommands"))
                        <|>
                        ((parseRules "FindStrings"))
                        <|>
                        ((parseRules "FindSubstitutions"))
                        <|>
                        ((parseRules "FindOthers")))
     return (attr, result)

parseRules "SubstBackq" = 
  do (attr, result) <- (((pDetectChar False '`' >>= withAttribute "Backquote") >>~ (popContext))
                        <|>
                        ((parseRules "FindCommentsBackq"))
                        <|>
                        ((parseRules "FindCommands"))
                        <|>
                        ((parseRules "FindStrings"))
                        <|>
                        ((parseRules "FindSubstitutions"))
                        <|>
                        ((parseRules "FindOthers")))
     return (attr, result)

parseRules "Case" = 
  do (attr, result) <- (((pRegExpr regex_'5csin'5cb >>= withAttribute "Keyword") >>~ pushContext "CaseIn")
                        <|>
                        ((parseRules "FindMost")))
     return (attr, result)

parseRules "CaseIn" = 
  do (attr, result) <- (((pRegExpr regex_'5cbesac'28'3f'3d'24'7c'5b'5cs'3b'29'5d'29 >>= withAttribute "Keyword") >>~ (popContext >> popContext))
                        <|>
                        ((pDetectChar False ')' >>= withAttribute "Keyword") >>~ pushContext "CaseExpr")
                        <|>
                        ((pAnyChar "(|" >>= withAttribute "Keyword"))
                        <|>
                        ((parseRules "FindMost")))
     return (attr, result)

parseRules "CaseExpr" = 
  do (attr, result) <- (((pDetect2Chars False ';' ';' >>= withAttribute "Keyword") >>~ (popContext))
                        <|>
                        ((pFirstNonSpace >> lookAhead (pRegExpr regex_esac'28'3f'3d'24'7c'5b'5cs'3b'29'5d'29) >> return ([],"") ) >>~ (popContext))
                        <|>
                        ((parseRules "FindAll")))
     return (attr, result)

parseRules "HereDoc" = 
  do (attr, result) <- (((lookAhead (pRegExpr regex_'28'3c'3c'2d'5cs'2a'22'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'22'29) >> return ([],"") ) >>~ pushContext "HereDocIQ")
                        <|>
                        ((lookAhead (pRegExpr regex_'28'3c'3c'2d'5cs'2a'27'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'27'29) >> return ([],"") ) >>~ pushContext "HereDocIQ")
                        <|>
                        ((lookAhead (pRegExpr regex_'28'3c'3c'2d'5cs'2a'5c'5c'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29) >> return ([],"") ) >>~ pushContext "HereDocIQ")
                        <|>
                        ((lookAhead (pRegExpr regex_'28'3c'3c'2d'5cs'2a'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29) >> return ([],"") ) >>~ pushContext "HereDocINQ")
                        <|>
                        ((lookAhead (pRegExpr regex_'28'3c'3c'5cs'2a'22'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'22'29) >> return ([],"") ) >>~ pushContext "HereDocQ")
                        <|>
                        ((lookAhead (pRegExpr regex_'28'3c'3c'5cs'2a'27'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'27'29) >> return ([],"") ) >>~ pushContext "HereDocQ")
                        <|>
                        ((lookAhead (pRegExpr regex_'28'3c'3c'5cs'2a'5c'5c'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29) >> return ([],"") ) >>~ pushContext "HereDocQ")
                        <|>
                        ((lookAhead (pRegExpr regex_'28'3c'3c'5cs'2a'28'5b'5e'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29) >> return ([],"") ) >>~ pushContext "HereDocNQ")
                        <|>
                        ((pString False "<<" >>= withAttribute "Redirection") >>~ (popContext)))
     return (attr, result)

parseRules "HereDocRemainder" = 
  do (attr, result) <- ((parseRules "FindAll"))
     return (attr, result)

parseRules "HereDocQ" = 
  do (attr, result) <- (((pRegExprDynamic "%1" >>= withAttribute "Redirection") >>~ pushContext "HereDocRemainder")
                        <|>
                        ((pColumn 0 >> pRegExprDynamic "%2\\b" >>= withAttribute "Redirection") >>~ (popContext >> popContext)))
     return (attr, result)

parseRules "HereDocNQ" = 
  do (attr, result) <- (((pRegExprDynamic "%1" >>= withAttribute "Redirection") >>~ pushContext "HereDocRemainder")
                        <|>
                        ((pColumn 0 >> pRegExprDynamic "%2\\b" >>= withAttribute "Redirection") >>~ (popContext >> popContext))
                        <|>
                        ((parseRules "FindSubstitutions")))
     return (attr, result)

parseRules "HereDocIQ" = 
  do (attr, result) <- (((pRegExprDynamic "%1" >>= withAttribute "Redirection") >>~ pushContext "HereDocRemainder")
                        <|>
                        ((pColumn 0 >> pRegExprDynamic "\\t*%2\\b" >>= withAttribute "Redirection") >>~ (popContext >> popContext)))
     return (attr, result)

parseRules "HereDocINQ" = 
  do (attr, result) <- (((pRegExprDynamic "%1" >>= withAttribute "Redirection") >>~ pushContext "HereDocRemainder")
                        <|>
                        ((pColumn 0 >> pRegExprDynamic "\\t*%2\\b" >>= withAttribute "Redirection") >>~ (popContext >> popContext))
                        <|>
                        ((parseRules "FindSubstitutions")))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
