{- This module was generated from data in the Kate syntax highlighting file scheme.xml, version 1.12,
   by  Dominik Haumann (dhdev@gmx.de) -}

module Text.Highlighting.Kate.Syntax.Scheme ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "Scheme"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.scm;*.ss;*.scheme;*.guile"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Scheme" }
  context <- currentContext <|> (pushContext "Level0" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("Scheme",["Level0"])], synStLanguage = "Scheme", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Level0" -> return ()
    "Default" -> return ()
    "MultiLineComment" -> return ()
    "SpecialNumber" -> (popContext >> return ())
    "String" -> return ()
    "function_decl" -> return ()
    "Level1" -> return ()
    "Level2" -> return ()
    "Level3" -> return ()
    "Level4" -> return ()
    "Level5" -> return ()
    "Level6" -> return ()
    _ -> return ()
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents, synStCharsParsedInLine = 0, synStPrevChar = '\n' }

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Keyword","kw"),("Definition","kw"),("Operator","kw"),("Function","fu"),("Data","dt"),("Decimal","dv"),("BaseN","bn"),("Float","fl"),("Char","ch"),("String","st"),("Comment","co"),("Region Marker","re")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_operators = Set.fromList $ words $ "<= < = => >= > - / *,* *) +"
list_characters = Set.fromList $ words $ "#\\nul #\\soh #\\stx #\\etx #\\eot #\\enq #\\ack #\\bel #\\bs #\\ht #\\nl #\\vt #\\np #\\cr #\\so #\\si #\\dle #\\dc1 #\\dc2 #\\dc3 #\\dc4 #\\nak #\\syn #\\etb #\\can #\\em #\\sub #\\esc #\\fs #\\gs #\\rs #\\us #\\space #\\sp #\\newline #\\nl #\\tab #\\ht #\\backspace #\\bs #\\return #\\cr #\\page #\\np #\\null #\\nul"
list_defines = Set.fromList $ words $ "define define* define-accessor define-class defined? define-generic define-macro define-method define-module define-private define-public define*-public define-reader-ctor define-syntax define-syntax-macro defmacro defmacro* defmacro*-public"
list_keywords = Set.fromList $ words $ "abs acos and angle append applymap asin assoc assq assv atan begin boolean? break caaaar caaadr caaar caadar caaddr caadr caar cadaar cadadr cadar caddar cadddr caddr cadr call/cc call-with-current-continuation call-with-input-file call-with-output-file call-with-values car case catch cdaaar cdaadr cdaar cdadar cdaddr cdadr cdar cddaar cddadr cddar cdddar cddddr cdddr cddr cdr ceiling char-alphabetic? char-ci>=? char-ci>? char-ci=? char-ci<=? char-downcase char->integer char>=? char>? char=? char? char-lower-case? char<?c char<=? char-numeric? char-ready? char-upcase char-upper-case? char-whitespace? close-input-port close-output-port complex? cond cons continue cos current-input-port current-output-port denominator display do dynamic-wind else eof-object? eq? equal? eqv? eval even? exact->inexact exact? exp expt floor force for-each gcd har-ci<? if imag-part inexact->exact inexact? input-port? integer->char integer? interaction-environment lambda lcm length let let* letrec letrec-syntax let-syntax list->string list list? list-ref list-tail load log magnitude make-polar make-rectangular make-string make-vector max member memq memv min modulo negative? newline not null-environment null? number? number->string numerator odd? open-input-file open-output-file or output-port? pair? peek-char port? positive? procedure? quotient rational? rationalize read-char read real? real-part remainder reverse round scheme-report-environment set-car! set-cdr! sin sqrt string-append string-ci>=? string-ci>? string-ci=? string-ci<=? string-ci<? string-copy string-fill! string>=? string>? string->list string->number string->symbol string=? string string? string-length string<=? string<? string-ref string-set! substring symbol->string symbol? syntax-rules tan transcript-off transcript-on truncate values vector-fill! vector->listlist->vector vector vector? vector-length vector-ref vector-set! while with-input-from-file with-output-to-file write-char write zero?"

regex_'3b'2b'5cs'2aBEGIN'2e'2a'24 = compileRegex ";+\\s*BEGIN.*$"
regex_'3b'2b'5cs'2aEND'2e'2a'24 = compileRegex ";+\\s*END.*$"
regex_'3b'2e'2a'24 = compileRegex ";.*$"
regex_'23'5c'5c'2e = compileRegex "#\\\\."
regex_'23'5bbodxei'5d = compileRegex "#[bodxei]"
regex_'23'5btf'5d = compileRegex "#[tf]"
regex_'21'23'5cs'2a'24 = compileRegex "!#\\s*$"
regex_'5cd'2a'28'5c'2e'5cd'2b'29'3f = compileRegex "\\d*(\\.\\d+)?"
regex_'5cs'2a'5bA'2dZa'2dz0'2d9'2d'2b'5c'3c'5c'3e'2f'2f'5c'2a'5d'2a'5cs'2a = compileRegex "\\s*[A-Za-z0-9-+\\<\\>//\\*]*\\s*"

defaultAttributes = [("Level0","Normal"),("Default","Normal"),("MultiLineComment","Comment"),("SpecialNumber","Normal"),("String","String"),("function_decl","Function"),("Level1","Normal"),("Level2","Normal"),("Level3","Normal"),("Level4","Normal"),("Level5","Normal"),("Level6","Normal")]

parseRules "Level0" = 
  do (attr, result) <- (((pDetectChar False '(' >>= withAttribute "Brackets1") >>~ pushContext "Level1")
                        <|>
                        ((parseRules "Default")))
     return (attr, result)

parseRules "Default" = 
  do (attr, result) <- (((pRegExpr regex_'3b'2b'5cs'2aBEGIN'2e'2a'24 >>= withAttribute "Region Marker"))
                        <|>
                        ((pRegExpr regex_'3b'2b'5cs'2aEND'2e'2a'24 >>= withAttribute "Region Marker"))
                        <|>
                        ((pRegExpr regex_'3b'2e'2a'24 >>= withAttribute "Comment"))
                        <|>
                        ((pDetect2Chars False '#' '!' >>= withAttribute "Comment") >>~ pushContext "MultiLineComment")
                        <|>
                        ((pKeyword " \n\t.(),%&;[]^{|}~" list_keywords >>= withAttribute "Keyword"))
                        <|>
                        ((pKeyword " \n\t.(),%&;[]^{|}~" list_operators >>= withAttribute "Operator"))
                        <|>
                        ((pKeyword " \n\t.(),%&;[]^{|}~" list_defines >>= withAttribute "Definition") >>~ pushContext "function_decl")
                        <|>
                        ((pKeyword " \n\t.(),%&;[]^{|}~" list_characters >>= withAttribute "Char"))
                        <|>
                        ((pRegExpr regex_'23'5c'5c'2e >>= withAttribute "Char"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "String")
                        <|>
                        ((pRegExpr regex_'23'5bbodxei'5d >>= withAttribute "Char") >>~ pushContext "SpecialNumber")
                        <|>
                        ((pRegExpr regex_'23'5btf'5d >>= withAttribute "Decimal"))
                        <|>
                        ((pFloat >>= withAttribute "Float"))
                        <|>
                        ((pInt >>= withAttribute "Decimal"))
                        <|>
                        ((pDetectChar False '(' >>= withAttribute "Brackets1") >>~ pushContext "Level1"))
     return (attr, result)

parseRules "MultiLineComment" = 
  do (attr, result) <- ((pColumn 0 >> pRegExpr regex_'21'23'5cs'2a'24 >>= withAttribute "Comment") >>~ (popContext >> return ()))
     return (attr, result)

parseRules "SpecialNumber" = 
  do (attr, result) <- (((pRegExpr regex_'5cd'2a'28'5c'2e'5cd'2b'29'3f >>= withAttribute "Decimal") >>~ (popContext >> return ()))
                        <|>
                        (return () >> return ([], "")))
     return (attr, result)

parseRules "String" = 
  do (attr, result) <- (((pKeyword " \n\t.(),%&;[]^{|}~" list_characters >>= withAttribute "Char"))
                        <|>
                        ((pRegExpr regex_'23'5c'5c'2e >>= withAttribute "Char"))
                        <|>
                        ((pDetect2Chars False '\\' '"' >>= withAttribute "Char"))
                        <|>
                        ((pDetect2Chars False '\\' '\\' >>= withAttribute "Char"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext >> return ())))
     return (attr, result)

parseRules "function_decl" = 
  do (attr, result) <- ((pRegExpr regex_'5cs'2a'5bA'2dZa'2dz0'2d9'2d'2b'5c'3c'5c'3e'2f'2f'5c'2a'5d'2a'5cs'2a >>= withAttribute "Function") >>~ (popContext >> return ()))
     return (attr, result)

parseRules "Level1" = 
  do (attr, result) <- (((pDetectChar False '(' >>= withAttribute "Brackets2") >>~ pushContext "Level2")
                        <|>
                        ((pDetectChar False ')' >>= withAttribute "Brackets1") >>~ (popContext >> return ()))
                        <|>
                        ((parseRules "Default")))
     return (attr, result)

parseRules "Level2" = 
  do (attr, result) <- (((pDetectChar False '(' >>= withAttribute "Brackets3") >>~ pushContext "Level3")
                        <|>
                        ((pDetectChar False ')' >>= withAttribute "Brackets2") >>~ (popContext >> return ()))
                        <|>
                        ((parseRules "Default")))
     return (attr, result)

parseRules "Level3" = 
  do (attr, result) <- (((pDetectChar False '(' >>= withAttribute "Brackets4") >>~ pushContext "Level4")
                        <|>
                        ((pDetectChar False ')' >>= withAttribute "Brackets3") >>~ (popContext >> return ()))
                        <|>
                        ((parseRules "Default")))
     return (attr, result)

parseRules "Level4" = 
  do (attr, result) <- (((pDetectChar False '(' >>= withAttribute "Brackets5") >>~ pushContext "Level5")
                        <|>
                        ((pDetectChar False ')' >>= withAttribute "Brackets4") >>~ (popContext >> return ()))
                        <|>
                        ((parseRules "Default")))
     return (attr, result)

parseRules "Level5" = 
  do (attr, result) <- (((pDetectChar False '(' >>= withAttribute "Brackets6") >>~ pushContext "Level6")
                        <|>
                        ((pDetectChar False ')' >>= withAttribute "Brackets5") >>~ (popContext >> return ()))
                        <|>
                        ((parseRules "Default")))
     return (attr, result)

parseRules "Level6" = 
  do (attr, result) <- (((pDetectChar False '(' >>= withAttribute "Brackets1") >>~ pushContext "Level1")
                        <|>
                        ((pDetectChar False ')' >>= withAttribute "Brackets6") >>~ (popContext >> return ()))
                        <|>
                        ((parseRules "Default")))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
