/*
 * Copyright 2017-present Facebook, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include <wangle/ssl/PasswordInFile.h>

#include <folly/FileUtil.h>

using namespace std;

namespace wangle {

PasswordInFile::PasswordInFile(const string& file)
    : fileName_(file) {
  folly::readFile(file.c_str(), password_);
  auto p = password_.find('\0');
  if (p != std::string::npos) {
    password_.erase(p);
  }
}

PasswordInFile::~PasswordInFile() {
  OPENSSL_cleanse((char *)password_.data(), password_.length());
}

} // namespace wangle
