<?php
function utf32_utf8($k) {
	if ($k < 0x80) {
		$retval = pack('C', $k);
	} else if ($k < 0x800) {
		$retval = pack('C2', 
            0xc0 | ($k >> 6),
            0x80 | ($k & 0x3f));
	} else if ($k < 0x10000) {
        $retval = pack('C3',
            0xe0 | ($k >> 12),
            0x80 | (($k >> 6) & 0x3f),
            0x80 | ($k & 0x3f));
	} else {
        $retval = pack('C4',
            0xf0 | ($k >> 18),
            0x80 | (($k >> 12) & 0x3f),
            0x80 | (($k >> 6) & 0x3f),
            0x80 | ($k & 0x3f));
	}
	return $retval;
}

for ($i = 0; $i < 0x1DFFF; $i++) {
    if ($i >= 0xd800 && $i < 0xe000) //surrogates
        continue;
    $str = utf32_utf8($i);
    $result = htmlentities($str, ENT_QUOTES | ENT_HTML5, 'UTF-8');
    if ($str != $result) {
        printf("%s\tU+%05X\n", $result, $i);
    }
}

/* multicodepoint entities */
$mpcent = array(
array(0x0003C, 0x20D2),
array(0x0003D, 0x20E5),
array(0x0003E, 0x20D2),
array(0x00066, 0x6A),
array(0x0205F, 0x200A),
array(0x0219D, 0x338),
array(0x02202, 0x338),
array(0x02220, 0x20D2),
array(0x02229, 0xFE00),
array(0x0222A, 0xFE00),
array(0x0223C, 0x020D2),
array(0x0223D, 0x00331),
array(0x0223E, 0x00333),
array(0x02242, 0x338),
array(0x0224B, 0x338),
array(0x0224D, 0x020D2),
array(0x0224E, 0x338),
array(0x0224F, 0x338),
array(0x02250, 0x338),
array(0x02261, 0x020E5),
array(0x02264, 0x20D2),
array(0x02265, 0x020D2),
array(0x02266, 0x338),
array(0x02267, 0x00338),
array(0x02268, 0xFE00),
array(0x02269, 0xFE00),
array(0x0226A, 0x338),
array(0x0226A, 0x20D2),
array(0x0226B, 0x338),
array(0x0226B, 0x20D2),
array(0x0227F, 0x338),
array(0x02282, 0x20D2),
array(0x02283, 0x20D2),
array(0x0228A, 0xFE00),
array(0x0228B, 0xFE00),
array(0x0228F, 0x338),
array(0x02290, 0x338),
array(0x02293, 0xFE00),
array(0x02294, 0xFE00),
array(0x022B4, 0x20D2),
array(0x022B5, 0x20D2),
array(0x022D8, 0x338),
array(0x022D9, 0x338),
array(0x022DA, 0xFE00),
array(0x022DB, 0xFE00),
array(0x022F5, 0x338),
array(0x022F9, 0x338),
array(0x02933, 0x338),
array(0x029CF, 0x338),
array(0x029D0, 0x338),
array(0x02A6D, 0x338),
array(0x02A70, 0x338),
array(0x02A7D, 0x338),
array(0x02A7E, 0x338),
array(0x02AA1, 0x338),
array(0x02AA2, 0x338),
array(0x02AAC, 0xFE00),
array(0x02AAD, 0xFE00),
array(0x02AAF, 0x338),
array(0x02AB0, 0x338),
array(0x02AC5, 0x338),
array(0x02AC6, 0x338),
array(0x02ACB, 0xFE00),
array(0x02ACC, 0xFE00),
array(0x02AFD, 0xFE00),
);

foreach ($mpcent as $i) {
    $str = utf32_utf8($i[0]);
    $str .= utf32_utf8($i[1]);
    $result = htmlentities($str, ENT_QUOTES | ENT_HTML5, 'UTF-8');
    printf("%s\tU+%05X U+%05X\n", $result, $i[0], $i[1]);
}
?>