<?php

// This doc comment block generated by idl/sysdoc.php
/**
 * ( excerpt from http://php.net/manual/en/class.directoryiterator.php )
 *
 * The DirectoryIterator class provides a simple interface for viewing the
 * contents of filesystem directories.
 *
 */
class DirectoryIterator extends SplFileInfo implements SeekableIterator {

  private $dir;
  private $dirName;
  private $index;

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/directoryiterator.construct.php
   * )
   *
   * Constructs a new directory iterator from a path.
   *
   * @path       mixed   The path of the directory to traverse.
   */
  public function __construct($path) {
    if (empty($path)) {
      throw new RuntimeException("Directory name must not be empty.");
    }
    $this->dir = @opendir($path);
    if ($this->dir === false) {
      throw new UnexpectedValueException(
        "DirectoryIterator::__construct($path): failed to open dir"
      );
    }
    $this->dirName = rtrim($path, DIRECTORY_SEPARATOR);
    $this->index = 0;
    parent::__construct($this->readDir());
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/directoryiterator.current.php )
   *
   * Get the current DirectoryIterator item.
   *
   * @return     mixed   The current DirectoryIterator item.
   */
  public function current() {
    return clone $this;
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/directoryiterator.key.php )
   *
   * Get the key for the current DirectoryIterator item.
   *
   * @return     mixed   The key for the current DirectoryIterator item.
   */
  public function key() {
    return $this->index;
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/directoryiterator.next.php )
   *
   * Move forward to the next DirectoryIterator item.
   *
   * @return     mixed   No value is returned.
   */
  public function next() {
    $this->setPathname($this->readDir());
    $this->index++;
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/directoryiterator.rewind.php )
   *
   * Rewind the DirectoryIterator back to the start.
   *
   * @return     mixed   No value is returned.
   */
  public function rewind() {
    rewinddir($this->dir);
    $this->index = -1;
    $this->next();
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/directoryiterator.seek.php )
   *
   * Seek to a given position in the DirectoryIterator.
   *
   * @position   mixed   The zero-based numeric position to seek to.
   *
   * @return     mixed   No value is returned.
   */
  public function seek($position) {
    for ($i = $this->index; $i < $position; $i++) {
      $this->next();
    }
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/directoryiterator.tostring.php )
   *
   * Get the file name of the current DirectoryIterator item.
   *
   * @return     mixed   Returns the file name of the current
   *                     DirectoryIterator item.
   */
  public function __toString() {
    return $this->getFilename();
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/directoryiterator.valid.php )
   *
   * Check whether current DirectoryIterator position is a valid file.
   *
   * @return     mixed   Returns TRUE if the position is valid, otherwise
   *                     FALSE
   */
  public function valid() {
    return $this->getPathname() !== false;
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/directoryiterator.isdot.php )
   *
   * Determines if the current DirectoryIterator item is a directory and
   * either . or ...
   *
   * @return     mixed   TRUE if the entry is . or .., otherwise FALSE
   */
  public function isDot() {
    return $this->getPathname() !== false && (
      $this->getFilename() == '.' || $this->getFilename() == '..'
    );
  }

  private function readDir() {
    // hh_readdir will set $this->dirName if necessary
    $file_name = $this->hh_readdir();
    if ($file_name === false) {
      return false;
    } else {
      return $this->dirName.DIRECTORY_SEPARATOR.$file_name;
    }
  }

  <<__Native>>
  private function hh_readdir(): mixed;

}
