/*
   +----------------------------------------------------------------------+
   | HipHop for PHP                                                       |
   +----------------------------------------------------------------------+
   | Copyright (c) 2010-2014 Facebook, Inc. (http://www.facebook.com)     |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
*/

#ifndef incl_HPHP_VM_PRINT_H_
#define incl_HPHP_VM_PRINT_H_

#include <iosfwd>
#include "hphp/util/trace.h"
#include "hphp/runtime/vm/jit/ir.h"
#include "hphp/runtime/vm/jit/reg-alloc.h"
#include "hphp/runtime/vm/jit/type.h"

namespace HPHP {
namespace JIT {

struct IRInstruction;
class  SSATmp;
struct Block;
struct AsmInfo;

// IRInstruction
void printInstr(std::ostream& ostream, const IRInstruction*,
                const RegAllocInfo* regs = nullptr,
                const GuardConstraints* guards = nullptr);
void printDsts(std::ostream& os, const IRInstruction* inst,
               const RegAllocInfo* regs);
void printSrcs(std::ostream& os, const IRInstruction* inst,
               const RegAllocInfo* regs);
void printOpcode(std::ostream& os, const IRInstruction* inst,
                 const GuardConstraints* guards);
void printSrcs(std::ostream& os, const IRInstruction* inst,
               const RegAllocInfo* regs);
void printDsts(std::ostream& os, const IRInstruction* inst,
               const RegAllocInfo* regs);
void print(std::ostream& ostream, const IRInstruction*,
           const RegAllocInfo* regs = nullptr,
           const GuardConstraints* guards = nullptr);
void print(const IRInstruction*);

// SSATmp
void print(std::ostream& ostream, const SSATmp*,
           const PhysLoc* loc = nullptr);
void print(const SSATmp*);

// Block
void print(std::ostream& os, const Block* block,
           const RegAllocInfo* regs = nullptr,
           const AsmInfo* asmInfo = nullptr,
           const GuardConstraints* guards = nullptr,
           BCMarker* curMarker = nullptr);
void print(const Block* block);

// Unit
void print(std::ostream& ostream, const IRUnit&,
           const RegAllocInfo* regs = nullptr,
           const AsmInfo* asmInfo = nullptr,
           const GuardConstraints* guards = nullptr,
           bool dotBodies = false);
void print(const IRUnit& unit);

/*
 * Some utilities related to dumping. Rather than file-by-file control, we
 * control most IR logging via the hhir trace module.
 */
static inline bool dumpIREnabled(int level = 1) {
  return HPHP::Trace::moduleEnabledRelease(HPHP::Trace::printir, level);
}

const int kIRLevel = 1;
const int kCodeGenLevel = 2;
const int kOptLevel = 3;
const int kRegAllocLevel = 4;
const int kRelocationLevel = 4;
const int kExtraLevel = 6;
const int kExtraExtraLevel = 7;

void printUnit(int level, const IRUnit&, const char* caption,
               const RegAllocInfo* regs = nullptr, AsmInfo* ai = nullptr,
               const GuardConstraints* guards = nullptr);

inline std::ostream& operator<<(std::ostream& os, Type t) {
  return os << t.toString();
}
inline std::ostream& operator<<(std::ostream& os, TypeConstraint tc) {
  return os << tc.toString();
}

}}

#endif
