<?hh
// @generated by idl-to-hni.php

/* The OAuth extension provides a simple interface to interact with data
 * providers using the OAuth HTTP specification to protect private resources.
 */
<<__NativeData("ZendCompat")>>
class OAuth {
  public int $debug = 0;
  public int $sslChecks = 1;
  public string $debugInfo = '';

/* Creates a new OAuth object
 */
  <<__Native("ZendCompat")>>
  public function __construct(mixed $consumer_key,
                              mixed $consumer_secret,
                              mixed $signature_method = OAUTH_SIG_METHOD_HMACSHA1,
                              mixed $auth_type = 0): void;

  /* The destructor. Warning: This function is currently not documented; only
   * its argument list is available.
   */
  <<__Native("ZendCompat")>>
  public function __destruct(): mixed;

  /* Turns off verbose request information (off by default). Alternatively, the
   * debug property can be set to a FALSE value to turn debug off.
   */
  <<__Native("ZendCompat")>>
  public function disableDebug(): mixed;

  /* Disable redirects from being followed automatically, thus allowing the
   * request to be manually redirected. Warning: This function is currently not
   * documented; only its argument list is available.
   */
  <<__Native("ZendCompat")>>
  public function disableRedirects(): mixed;

  /* Turns off the usual SSL peer certificate and host checks, this is not for
   * production environments. Alternatively, the sslChecks member can be set to
   * FALSE to turn SSL checks off.
   */
  <<__Native("ZendCompat")>>
  public function disableSSLChecks(): mixed;

  /* Turns on verbose request information useful for debugging, the debug
   * information is stored in the debugInfo member. Alternatively, the debug
   * member can be set to a non-FALSE value to turn debug on.
   */
  <<__Native("ZendCompat")>>
  public function enableDebug(): mixed;

  /* Follow and sign redirects automatically, which is enabled by default.
   * Warning: This function is currently not documented; only its argument list
   * is available.
   */
  <<__Native("ZendCompat")>>
  public function enableRedirects(): mixed;

  /* Turns on the usual SSL peer certificate and host checks (enabled by
   * default). Alternatively, the sslChecks member can be set to a non-FALSE
   * value to turn SSL checks off.
   */
  <<__Native("ZendCompat")>>
  public function enableSSLChecks(): mixed;

  /* Fetch a resource.
   */
  <<__Native("ZendCompat")>>
  public function fetch(mixed $protected_resource_url,
                        mixed $extra_parameters,
                        mixed $http_method,
                        mixed $http_headers): mixed;

  /* Generate a signature based on the final HTTP method, URL and a string/array
   * of parameters.
   */
  <<__Native("ZendCompat")>>
  public function generateSignature(mixed $http_method,
                                    mixed $url,
                                    mixed $extra_parameters): mixed;

  /* Fetch an access token, secret and any additional response parameters from
   * the service provider.
   */
  <<__Native("ZendCompat")>>
  public function getAccessToken(mixed $access_token_url,
                                 mixed $auth_session_handle,
                                 mixed $verifier_token): mixed;

  /* Gets the Certificate Authority information, which includes the ca_path and
   * ca_info set by OAuth::setCaPath(). Warning: This function is currently not
   * documented; only its argument list is available.
   */
  <<__Native("ZendCompat")>>
  public function getCAPath(): mixed;

  /* Get the raw response of the most recent request.
   */
  <<__Native("ZendCompat")>>
  public function getLastResponse(): mixed;

  /* Get headers for last response.
   */
  <<__Native("ZendCompat")>>
  public function getLastResponseHeaders(): mixed;

  /* Get HTTP information about the last response.
   */
  <<__Native("ZendCompat")>>
  public function getLastResponseInfo(): mixed;

  /* Generate OAuth header string signature based on the final HTTP method, URL
   * and a string/array of parameters
   */
  <<__Native("ZendCompat")>>
  public function getRequestHeader(mixed $http_method,
                                   mixed $url,
                                   mixed $extra_parameters): mixed;

  /* Fetch a request token, secret and any additional response parameters from
   * the service provider.
   */
  <<__Native("ZendCompat")>>
  public function getRequestToken(mixed $request_token_url,
                                  mixed $callback_url,
                                  mixed $http_method): mixed;

  /* Set where the OAuth parameters should be passed.
   */
  <<__Native("ZendCompat")>>
  public function setAuthType(mixed $auth_type): mixed;

  /* Sets the Certificate Authority (CA), both for path and info. Warning: This
   * function is currently not documented; only its argument list is available.
   */
  <<__Native("ZendCompat")>>
  public function setCAPath(mixed $ca_path,
                            mixed $ca_info): mixed;

  /* Sets the nonce for all subsequent requests.
   */
  <<__Native("ZendCompat")>>
  public function setNonce(mixed $nonce): mixed;

  /* Sets the Request Engine, that will be sending the HTTP requests. Warning:
   * This function is currently not documented; only its argument list is
   * available.
   */
  <<__Native("ZendCompat")>>
  public function setRequestEngine(mixed $reqengine): mixed;

  /* Sets the RSA certificate. Warning: This function is currently not
   * documented; only its argument list is available.
   */
  <<__Native("ZendCompat")>>
  public function setRSACertificate(mixed $cert): mixed;

  /* Tweak specific SSL checks for requests. Warning: This function is currently
   * not documented; only its argument list is available.
   */
  <<__Native("ZendCompat")>>
  public function setSSLChecks(mixed $sslcheck): mixed;

  /* Sets the OAuth timestamp for subsequent requests. Warning: This function is
   * currently not documented; only its argument list is available.
   */
  <<__Native("ZendCompat")>>
  public function setTimestamp(mixed $timestamp): mixed;

  /* Set the token and secret for subsequent requests.
   */
  <<__Native("ZendCompat")>>
  public function setToken(mixed $token,
                           mixed $token_secret): mixed;

  /* Sets the OAuth version for subsequent requests
   */
  <<__Native("ZendCompat")>>
  public function setVersion(mixed $version): mixed;
}

/* Manages an OAuth provider class.  See also an external in-depth tutorial
 * titled Writing an OAuth Provider Service, which takes a hands-on approach
 * to providing this service. There are also OAuth provider examples within
 * the OAuth extensions sources.
 */
<<__NativeData("ZendCompat")>>
class OAuthProvider {

  /* Add required oauth provider parameters. Warning: This function is currently
   * not documented; only its argument list is available.
   */
  <<__Native("ZendCompat")>>
  public function addRequiredParameter(mixed $req_params): mixed;

  /* Calls the registered consumer handler callback function, which is set with
   * OAuthProvider::consumerHandler(). Warning: This function is currently not
   * documented; only its argument list is available.
   */
  <<__Native("ZendCompat")>>
  public function callconsumerHandler(): mixed;

  /* Calls the registered timestamp handler callback function, which is set with
   * OAuthProvider::timestampNonceHandler(). Warning: This function is currently
   * not documented; only its argument list is available.
   */
  <<__Native("ZendCompat")>>
  public function callTimestampNonceHandler(): mixed;

  /* Calls the registered token handler callback function, which is set with
   * OAuthProvider::tokenHandler(). Warning: This function is currently not
   * documented; only its argument list is available.
   */
  <<__Native("ZendCompat")>>
  public function calltokenHandler(): mixed;

  /* Checks an OAuth request. Warning: This function is currently not
   * documented; only its argument list is available.
   */
  <<__Native("ZendCompat")>>
  public function checkOAuthRequest(mixed $uri,
                                    mixed $method): mixed;

  /* Initiates a new OAuthProvider object. Warning: This function is currently
   * not documented; only its argument list is available.
   */
  <<__Native("ZendCompat")>>
  public function __construct(mixed $params_array): mixed;

  /* Sets the consumer handler callback, which will later be called with
   * OAuthProvider::callConsumerHandler(). Warning: This function is currently
   * not documented; only its argument list is available.
   */
  <<__Native("ZendCompat")>>
  public function consumerHandler(mixed $callback_function): mixed;

  /* Generates a string of pseudo-random bytes.
   */
  <<__Native("ZendCompat")>>
  public static function generateToken(mixed $size,
                                mixed $strong): mixed;

  /* The 2-legged flow, or request signing. It does not require a token.
   * Warning: This function is currently not documented; only its argument list
   * is available.
   */
  <<__Native("ZendCompat")>>
  public function is2LeggedEndpoint(mixed $params_array): mixed;

  /* Warning: This function is currently not documented; only its argument list
   * is available.
   */
  <<__Native("ZendCompat")>>
  public function isRequestTokenEndpoint(mixed $will_issue_request_token): mixed;

  /* Removes a required parameter. Warning: This function is currently not
   * documented; only its argument list is available.
   */
  <<__Native("ZendCompat")>>
  public function removeRequiredParameter(mixed $req_params): mixed;

  /* Pass in a problem as an OAuthException, with possible problems listed in
   * the OAuth constants section. Warning: This function is currently not
   * documented; only its argument list is available.
   */
  <<__Native("ZendCompat")>>
  public static function reportProblem(mixed $oauthexception): mixed;

  /* Sets a parameter. Warning: This function is currently not documented; only
   * its argument list is available.
   */
  <<__Native("ZendCompat")>>
  public function setParam(mixed $param_key,
                           mixed $param_val): mixed;

  /* Sets the request tokens path. Warning: This function is currently not
   * documented; only its argument list is available.
   */
  <<__Native("ZendCompat")>>
  public function setRequestTokenPath(mixed $path): mixed;

  /* Sets the timestamp nonce handler callback, which will later be called with
   * OAuthProvider::callTimestampNonceHandler(). Errors related to
   * timestamp/nonce are thrown to this callback. Warning: This function is
   * currently not documented; only its argument list is available.
   */
  <<__Native("ZendCompat")>>
  public function timestampNonceHandler(mixed $callback_function): mixed;

  /* Sets the token handler callback, which will later be called with
   * OAuthProvider::callTokenHandler(). Warning: This function is currently not
   * documented; only its argument list is available.
   */
  <<__Native("ZendCompat")>>
  public function tokenHandler(mixed $callback_function): mixed;
}

/* This exception is thrown when exceptional errors occur while using the
 * OAuth extension and contains useful debugging information.
 */
<<__NativeData("ZendCompat")>>
class OAuthException extends Exception {
  public mixed $lastResponse;
  public mixed $debugInfo;

  <<__Native("ZendCompat")>>
  public function __construct(): void;
}

/* Generates a Signature Base String according to pecl/oauth.
 */
<<__Native("ZendCompat")>>
function oauth_get_sbs(mixed $http_method,
                       mixed $uri,
                       mixed $request_parameters): mixed;

/* Encodes a URI to RFC 3986.
 */
<<__Native("ZendCompat")>>
function oauth_urlencode(mixed $uri): mixed;
