<?hh
// @generated by idl-to-hni.php

/* A connection manager for PHP and MongoDB.  This class is used to create and
 * manage connections. A typical use is: Example #1 MongoClient basic usage
 * See MongoClient::__construct() and the section on connecting for more
 * information about creating connections.
 */
<<__NativeData("ZendCompat")>>
class MongoClient {
  public bool $connected = false;
  public mixed $status;
  protected mixed $server;
  protected mixed $persistent;

  /* The MongoClient::close() method forcefully closes a connection to the
   * database, even if persistent connections are being used. You should never
   * have to do this under normal circumstances.
   */
  <<__Native("ZendCompat")>>
  public function close(mixed $connection): mixed;

  <<__Native("ZendCompat")>>
  public function connect(): mixed;

  /* If no parameters are passed, this connects to "localhost:27017" (or
   * whatever was specified in php.ini for mongo.default_host and
   * mongo.default_port).  server should have the form:    The connection string
   * always starts with mongodb://, to indicate it is a connection string in
   * this form. username and password are specified, the constructor will
   * attempt to authenticate the connection with the database before returning.
   * Username and password are optional and must be followed by an @, if
   * specified.  At least one host must be given (port optional, always
   * defaulting to 27017) and as many hosts as desired may be connected to. Host
   * names are comma-separated and the constructor will return successfully if
   * it connected to at least one host. If it could not connect to any of the
   * hosts, it will throw a MongoConnectionException. Please see the Replica
   * Sets section for information on how to connect to Replica Sets.  If you
   * specified a username and password, you may specify a database to
   * authenticate with. If db is not specified, "admin" will be used.  An
   * optional query string may be used to specify extra options. The same
   * options are supported through the options array as well, and are therefore
   * redescribed there. See the examples below on how to set those options.  One
   * part of the options governs how the driver reads from secondary nodes in a
   * replica set environment. Extra information on how these read preferences
   * work is available as well through the read preferences documentation page.
   */
  <<__Native("ZendCompat")>>
  public function __construct(mixed $server,
                              mixed $options): mixed;

  <<__Native("ZendCompat")>>
  public function dropDB(mixed $db): mixed;

  /* This is the cleanest way of getting a database. If the database name has
   * any special characters, MongoClient::selectDB() will need to be used;
   * however, this should be sufficient for most cases.
   */
  <<__Native("ZendCompat")>>
  public function __get(mixed $dbname): mixed;

  /* Returns an array of all open connections, and information about each of the
   * servers
   */
  <<__Native("ZendCompat")>>
  public static function getConnections(): mixed;

  /* This method is only useful with a connection to a replica set. It returns
   * the status of all of the hosts in the set. Without a replica set, it will
   * just return an array with one element containing the host that you are
   * connected to.  See the query section of this manual for information on
   * distributing reads to secondaries.
   */
  <<__Native("ZendCompat")>>
  public function getHosts(): mixed;

  <<__Native("ZendCompat")>>
  public function getReadPreference(): mixed;

  <<__Native("ZendCompat")>>
  public function listDBs(): mixed;

  <<__Native("ZendCompat")>>
  public function selectCollection(mixed $db,
                                   mixed $collection): mixed;

  <<__Native("ZendCompat")>>
  public function selectDB(mixed $name): mixed;

  <<__Native("ZendCompat")>>
  public function setReadPreference(mixed $read_preference,
                                    mixed $tags): mixed;

  <<__Native("ZendCompat")>>
  public function __toString(): mixed;
}

/* Instances of this class are used to interact with a database. To get a
 * database: Example #1 Selecting a database  Database names can use almost
 * any character in the ASCII range. However, they cannot contain " ", "." or
 * be the empty string. The name "system" is also reserved.  A few unusual,
 * but valid, database names: "null", "[x,y]", "3", "\"", "/".  Unlike
 * collection names, database names may contain "$".
 */
<<__NativeData("ZendCompat")>>
class MongoDB {
  public int $w = 1;
  public int $wtimeout = 10000;

  /* This method causes its connection to be authenticated. If authentication is
   * enabled for the database server (it's not, by default), you need to log in
   * before the database will allow you to do anything.  In general, you should
   * use the authenticate built into MongoClient::__construct() in preference to
   * this method. If you authenticate on connection and the connection drops and
   * reconnects during your session, you'll be reauthenticated. If you manually
   * authenticated using this method and the connection drops, you'll have to
   * call this method again once you're reconnected.  This method is identical
   * to running:    Once a connection has been authenticated, it can only be
   * un-authenticated by using the "logout" database command:
   */
  <<__Native("ZendCompat")>>
  public function authenticate(mixed $username,
                               mixed $password): mixed;

  /* Almost everything that is not a CRUD operation can be done with a database
   * command. Need to know the database version? There's a command for that.
   * Need to do aggregation? There's a command for that. Need to turn up
   * logging? You get the idea.  This method is identical to:
   */
  <<__Native("ZendCompat")>>
  public function command(mixed $command,
                          mixed $options): mixed;

  /* This method is not meant to be called directly. The preferred way to create
   * an instance of MongoDB is through MongoClient::__get() or
   * MongoClient::selectDB().  If you're ignoring the previous paragraph and
   * want to call it directly you can do so:    But don't. Isn't this much
   * nicer:
   */
  <<__Native("ZendCompat")>>
  public function __construct(mixed $conn,
                              mixed $name): mixed;

  /* This method is used to create capped collections and other collections
   * requiring special options. It is identical to running:  See
   * MongoDB::command() for more information about database commands.
   */
  <<__Native("ZendCompat")>>
  public function createCollection(mixed $name,
                                   mixed $options,
                                   mixed $capped,
                                   mixed $size,
                                   mixed $max): mixed;

  /* This method is a flexible interface for creating database refrences (see
   * MongoDBRef).
   */
  <<__Native("ZendCompat")>>
  public function createDBRef(mixed $collection,
                              mixed $document_or_id): mixed;

  /* This drops the database currently being used.  This is identical to
   * running:
   */
  <<__Native("ZendCompat")>>
  public function drop(): mixed;

  <<__Native("ZendCompat")>>
  public function dropCollection(mixed $coll): mixed;

  /* The Mongo database server runs a JavaScript engine. This method allows you
   * to run arbitary JavaScript on the database. This can be useful if you want
   * touch a number of collections lightly, or process some results on the
   * database side to reduce the amount that has to be sent to the client.
   * Running JavaScript in the database takes a write lock, meaning it blocks
   * other operations. Make sure you consider this before running a long script.
   *  This is a wrapper for a database command. This method is basically:
   * MongoDB implies a return statement if you have a single statement on a
   * single line. This can cause some unintuitive behavior. For example, this
   * returns "foo":    However, these return NULL:    To avoid surprising
   * behavior, it is best not to depend on MongoDB to decide what to return, but
   * to explicitly state a return value. In the examples above, we can change
   * them to:    Now the first statement will return "foo" and the second
   * statement will return a count of the "foo" collection.
   */
  <<__Native("ZendCompat")>>
  public function execute(mixed $code,
                          mixed $args): mixed;

  /* This method is not very useful for normal MongoDB use. It forces a database
   * error to occur. This means that MongoDB::lastError() will return a generic
   * database error after running this command.  This command is identical to
   * running:
   */
  <<__Native("ZendCompat")>>
  public function forceError(): mixed;

  /* This is the easiest way of getting a collection from a database object. If
   * a collection name contains strange characters, you may have to use
   * MongoDB::selectCollection() instead.
   */
  <<__Native("ZendCompat")>>
  public function __get(mixed $name): mixed;

  /* Returns an array of all the collection names for the given database.
   */
  <<__Native("ZendCompat")>>
  public function getCollectionNames(mixed $includeSystemCollections): mixed;

  <<__Native("ZendCompat")>>
  public function getDBRef(mixed $ref): mixed;

  <<__Native("ZendCompat")>>
  public function getGridFS(mixed $prefix): mixed;

  /* This returns the current database profiling level.  The database profiler
   * tracks query execution times. If you turn it on (say, using
   * MongoDB::setProfilingLevel() or the shell), you can see how many queries
   * took longer than a given number of milliseconds or the timing for all
   * queries.  Note that profiling slows down queries, so it is better to use in
   * development or testing than in a time-sensitive application.  This function
   * is equivalent to running:
   */
  <<__Native("ZendCompat")>>
  public function getProfilingLevel(): mixed;

  <<__Native("ZendCompat")>>
  public function getReadPreference(): mixed;

  /* See the query section of this manual for information on distributing reads
   * to secondaries.
   */
  <<__Native("ZendCompat")>>
  public function getSlaveOkay(): mixed;

  /* This method is equivalent to:
   */
  <<__Native("ZendCompat")>>
  public function lastError(): mixed;

  /* Gets a list of all the collections in the database and returns them as an
   * array of MongoCollection objects.
   */
  <<__Native("ZendCompat")>>
  public function listCollections(mixed $includeSystemCollections): mixed;

  /* MongoDB::lastError() is usually preferred to this. This method returns the
   * last database error that occurred and how many operations ago it occurred.
   * It is mostly deprecated.
   */
  <<__Native("ZendCompat")>>
  public function prevError(): mixed;

  /* This creates a fresh copy of all database data. It will remove any corrupt
   * data and compact and large stretches of free space it finds. This is a very
   * slow operation on a large database.  This is usually run from the shell or
   * the command line, not the driver.  It is equivalent to the function:
   */
  <<__Native("ZendCompat")>>
  public function repair(mixed $preserve_cloned_files,
                         mixed $backup_original_files): mixed;

  /* This method is not used in normal operations. It resets the database error
   * tracker (which can be incremented with MongoDB::forceError(), also not
   * normally used).  It is equivalent to running:
   */
  <<__Native("ZendCompat")>>
  public function resetError(): mixed;

  <<__Native("ZendCompat")>>
  public function selectCollection(mixed $name): mixed;

  /* This changes the current database profiling level.  This function is
   * equivalent to running:    The options for level are 0 (off), 1 (queries >
   * 100ms), and 2 (all queries). If you would like to profile queries that take
   * longer than another time period, use the database command and pass it a
   * second option, the number of milliseconds. For example, to profile all
   * queries that take longer than one second, run:    Profiled queries will
   * appear in the system.profile collection of this database.
   */
  <<__Native("ZendCompat")>>
  public function setProfilingLevel(mixed $level): mixed;

  <<__Native("ZendCompat")>>
  public function setReadPreference(mixed $read_preference,
                                    mixed $tags): mixed;

  /* See the query section of this manual for information on distributing reads
   * to secondaries.
   */
  <<__Native("ZendCompat")>>
  public function setSlaveOkay(mixed $ok): mixed;

  <<__Native("ZendCompat")>>
  public function __toString(): mixed;
}

/* Representations a database collection.  Collection names can use any
 * character in the ASCII set. Some valid collection names are "", "...", "my
 * collection", and "*&#@".  User-defined collection names cannot contain the
 * $ symbol. There are certain system collections which use a $ in their names
 * (e.g., local.oplog.$main), but it is a reserved character. If you attempt
 * to create and use a collection with a $ in the name, MongoDB will assert.
 */
<<__NativeData("ZendCompat")>>
class MongoCollection {
  public int $w = 1;
  public int $wtimeout = 10000;


  /* The MongoDB aggregation framework provides a means to calculate aggregated
   * values without having to use MapReduce. While MapReduce is powerful, it is
   * often more difficult than necessary for many simple aggregation tasks, such
   * as totaling or averaging field values.  This method accepts either a
   * variable amount of pipeline operators, or a single array of operators
   * constituting the pipeline.
   */
  <<__Native("ZendCompat")>>
  public function aggregate(mixed $pipeline,
                            mixed $op): mixed;

  <<__Native("ZendCompat")>>
  public function batchInsert(mixed $a,
                              mixed $options = array()): mixed;

  <<__Native("ZendCompat")>>
  public function __construct(mixed $db,
                              mixed $name): mixed;

  <<__Native("ZendCompat")>>
  public function count(mixed $query,
                        mixed $limit,
                        mixed $skip): mixed;

  <<__Native("ZendCompat")>>
  public function createDBRef(mixed $document_or_id): mixed;

  /* This method is identical to:    Each index, when created, is given a unique
   * name. This is generally user-set (with MongoCollection::ensureIndex()'s
   * "name" option) or generated by the driver from a combination of key names
   * and directions. This name is then used by MongoCollection::deleteIndex() to
   * remove the function.  Unfortunately, the MongoCollection::ensureIndex()
   * generates slightly different names than the shell and, due to backwards
   * compatibility issues, MongoCollection::deleteIndex() cannot delete
   * custom-named indexes as well. Thus, the best way to delete indexes created
   * in the shell or with custom names is to directly call the deleteIndexes
   * database command.  Thus, if you named an index "superfast query", you could
   * only delete it with the PHP driver by running:    To find what an index is
   * named, you can query the system.indexes collection of a database and look
   * for the name field.
   */
  <<__Native("ZendCompat")>>
  public function deleteIndex(mixed $keys): mixed;

  <<__Native("ZendCompat")>>
  public function deleteIndexes(): mixed;

  /* The distinct command returns a list of distinct values for the given key
   * across a collection.
   */
  <<__Native("ZendCompat")>>
  public function distinct(mixed $key,
                           mixed $query): mixed;

  /* Drops this collection and deletes its indices.
   */
  <<__Native("ZendCompat")>>
  public function drop(): mixed;

  /* This method creates an index on the collection and the specified fields.
   * The key specification can either be just a single field name as string, or
   * an array containing one or more field names with their sort direction.
   */
  <<__Native("ZendCompat")>>
  public function ensureIndex(mixed $keys,
                              mixed $options): mixed;

  <<__Native("ZendCompat")>>
  public function find(mixed $query,
                       mixed $fields): mixed;

  /* The findAndModify command atomically modifies and returns a single
   * document. By default, the returned document does not include the
   * modifications made on the update. To return the document with the
   * modifications made on the update, use the new option.
   */
  <<__Native("ZendCompat")>>
  public function findAndModify(mixed $query,
                                mixed $update,
                                mixed $fields,
                                mixed $options): mixed;

  /* As opposed to MongoCollection::find(), this method will return only the
   * first result from the result set, and not a MongoCursor that can be
   * iterated over.
   */
  <<__Native("ZendCompat")>>
  public function findOne(mixed $query,
                          mixed $fields): mixed;

  /* A concise syntax for getting a collection with a dot-separated name. If a
   * collection name contains strange characters, you may have to use
   * MongoDB::selectCollection() instead.
   */
  <<__Native("ZendCompat")>>
  public function __get(mixed $name): mixed;

  <<__Native("ZendCompat")>>
  public function getDBRef(mixed $ref): mixed;

  <<__Native("ZendCompat")>>
  public function getIndexInfo(): mixed;

  <<__Native("ZendCompat")>>
  public function getName(): mixed;

  <<__Native("ZendCompat")>>
  public function getReadPreference(): mixed;

  /* See the query section of this manual for information on distributing reads
   * to secondaries.
   */
  <<__Native("ZendCompat")>>
  public function getSlaveOkay(): mixed;

  <<__Native("ZendCompat")>>
  public function group(mixed $keys,
                        mixed $initial,
                        mixed $reduce,
                        mixed $options): mixed;

  /* All strings sent to the database must be UTF-8. If a string is not UTF-8, a
   * MongoException will be thrown. To insert (or query for) a non-UTF-8 string,
   * use MongoBinData.
   */
  <<__Native("ZendCompat")>>
  public function insert(mixed $a,
                         mixed $options): mixed;

  <<__Native("ZendCompat")>>
  public function remove(mixed $criteria,
                         mixed $options): mixed;

  /* If the object is from the database, update the existing database object,
   * otherwise insert this object.
   */
  <<__Native("ZendCompat")>>
  public function save(mixed $a,
                       mixed $options): mixed;

  <<__Native("ZendCompat")>>
  public function setReadPreference(mixed $read_preference,
                                    mixed $tags): mixed;

  /* See the query section of this manual for information on distributing reads
   * to secondaries.
   */
  <<__Native("ZendCompat")>>
  public function setSlaveOkay(mixed $ok): mixed;

  <<__Native("ZendCompat")>>
  protected static function toIndexString(mixed $keys): mixed;

  <<__Native("ZendCompat")>>
  public function __toString(): mixed;

  <<__Native("ZendCompat")>>
  public function update(mixed $criteria,
                         mixed $new_object,
                         mixed $options): mixed;

  <<__Native("ZendCompat")>>
  public function validate(mixed $scan_data): mixed;
}

/* A cursor is used to iterate through the results of a database query. For
 * example, to query the database and see all results, you could do: Example
 * #1 MongoCursor basic usage    You don't generally create cursors using the
 * MongoCursor constructor, you get a new cursor by calling
 * MongoCollection::find() (as shown above).  Suppose that, in the example
 * above, $collection was a 50GB collection. We certainly wouldn't want to
 * load that into memory all at once, which is what a cursor is for: allowing
 * the client to access the collection in dribs and drabs.  If we have a large
 * result set, we can iterate through it, loading a few megabytes of results
 * into memory at a time. For example, we could do: Example #2 Iterating over
 * MongoCursor  This will go through each document in the collection, loading
 * and garbage collecting documents as needed.  Note that this means that a
 * cursor does not "contain" the database results, it just manages them. Thus,
 * if you print a cursor (with, say, var_dump() or print_r()), you'll just get
 * the cursor object, not your documents. To get the documents themselves, you
 * can use one of the methods shown above.
 */
<<__NativeData("ZendCompat")>>
class MongoCursor {
  public static bool $slaveOkay = false;
  public static int $timeout = 30000;

  /* This is an advanced function and should not be used unless you know what
   * you're doing.  A query can optionally be nested in a "query" field if other
   * options, such as a sort or hint, are given. For instance, adding a sort
   * causes the query to become a subfield of a bigger query object, like:
   * This method is for adding a top-level field to a query. It makes the query
   * a subobject (if it isn't already) and adds the key/value pair of your
   * chosing to the top level. Warning  It cannot be used to add extra criteria
   * to a query on the fly. For instance, this will not work:  This does not
   * query for a user named "joe" with an age of 20.
   */
  <<__Native("ZendCompat")>>
  public function addOption(mixed $key,
                            mixed $value): mixed;

  /* This method is to be used with tailable cursors. If we are at the end of
   * the data, block for a while rather than returning no data. After a timeout
   * period, we do return as normal.
   */
  <<__Native("ZendCompat")>>
  public function awaitData(mixed $wait): mixed;

  /* A cursor typically fetches a batch of result objects and store them
   * locally. This method sets the batchSize value to configure the amount of
   * documents retrieved from the server in one data packet. However, it will
   * never return more documents than fit in the max batch size limit (usually
   * 4MB).
   */
  <<__Native("ZendCompat")>>
  public function batchSize(mixed $batchSize): mixed;

  <<__Native("ZendCompat")>>
  public function __construct(mixed $connection,
                              mixed $ns,
                              mixed $query,
                              mixed $fields): mixed;

  /* This method does not affect the state of the cursor: if you haven't queried
   * yet, you can still apply limits, skips, etc. If you have started iterating
   * through results, it will not move the current position of the cursor. If
   * you have exhasted the cursor, it will not reset it.
   */
  <<__Native("ZendCompat")>>
  public function count(mixed $foundOnly): mixed;

  /* This returns NULL until MongoCursor::next() is called.
   */
  <<__Native("ZendCompat")>>
  public function current(): mixed;

  /* The database sends responses in batches of documents, up to 4MB of
   * documents per response. This method checks if the database has more batches
   * or if the result set has been exhausted.  A cursor being "dead" does not
   * mean that MongoCursor::hasNext() will return FALSE, it only means that the
   * database is done sending results to the client. The client should continue
   * iterating through results until MongoCursor::hasNext() is FALSE.
   */
  <<__Native("ZendCompat")>>
  public function dead(): mixed;

  <<__Native("ZendCompat")>>
  public function doQuery(): mixed;

  <<__Native("ZendCompat")>>
  public function explain(): mixed;

  /* Fields are specified by "fieldname" : bool. TRUE indicates that a field
   * should be returned, FALSE indicates that it should not be returned. You can
   * also use 1 and 0 instead of TRUE and FALSE.  Thus, to return only the
   * "summary" field, one could say:    To return all fields except the "hidden"
   * field:
   */
  <<__Native("ZendCompat")>>
  public function fields(mixed $f): mixed;

  /* This is identical to the function:
   */
  <<__Native("ZendCompat")>>
  public function getNext(): mixed;

  <<__Native("ZendCompat")>>
  public function getReadPreference(): mixed;

  <<__Native("ZendCompat")>>
  public function hasNext(): mixed;

  <<__Native("ZendCompat")>>
  public function hint(mixed $index): mixed;

  /* After remaining idle on the server for some amount of time, cursors, by
   * default, "die." This is generally the behavior one wants. The database
   * cleans up a cursor once all of its results have been sent to the client,
   * but if the client doesn't request all of the results, the cursor will
   * languish there, taking up resources. Thus, after a few minutes, the cursor
   * "times out" and the database assumes the client has gotten everything it
   * needs and cleans up its the cursor's resources.  If, for some reason, you
   * need a cursor to hang around for a long time, you can prevent the database
   * from cleaning it up by using this method. However, if you make a cursor
   * immortal, you need to iterate through all of its results (or at least until
   * MongoCursor::dead() returns TRUE) or the cursor will hang around the
   * database forever, taking up resources.
   */
  <<__Native("ZendCompat")>>
  public function immortal(mixed $liveForever): mixed;

/* This can be called before or after the query.
 */
  <<__Native("ZendCompat")>>
  public function info(): mixed;

  <<__Native("ZendCompat")>>
  public function key(): mixed;

  <<__Native("ZendCompat")>>
  public function limit(mixed $num): mixed;

  <<__Native("ZendCompat")>>
  public function next(): mixed;

  /* This option allows mongos to send partial query results if a shard is
   * unreachable. This is only applicable when running a sharded MongoDB cluster
   * and connecting to a mongos.  If a shard goes down and a query needs to be
   * sent to that shard, mongos will return the results (if any) from shards it
   * already contacted, then an error message that it could not reach the shard
   * (a MongoCursorException in PHP). If you would like to get whatever results
   * mongos can provide and no exception, you can use this method. Note that
   * this means that you won't have an indication that a shard is down in your
   * query response.  This has no effect on the query if all shards are
   * reachable. This flag was implemented in MongoDB version 1.7.5, so will only
   * work with that version and higher.
   */
  <<__Native("ZendCompat")>>
  public function partial(mixed $okay): mixed;

  <<__Native("ZendCompat")>>
  public function reset(): mixed;

  /* This is identical to the function:
   */
  <<__Native("ZendCompat")>>
  public function rewind(): mixed;

  /* The MongoCursor class has several methods for setting flags on the query
   * object. This method is available in case the MongoDB wire protocol has
   * acquired a new flag, and the driver has not been updated with a method for
   * this new flag. In all other cases, the method should be used. See the "See
   * also" section for available methods.
   */
  <<__Native("ZendCompat")>>
  public function setFlag(mixed $flag,
                          mixed $set): mixed;

  <<__Native("ZendCompat")>>
  public function setReadPreference(mixed $read_preference,
                                    mixed $tags): mixed;

  <<__Native("ZendCompat")>>
  public function skip(mixed $num): mixed;

  /* Calling this will make the driver route reads to secondaries if: You are
   * using a replica set and You created a MongoClient instance using the option
   * "replicaSet" => "setName" and There is a healthy secondary that can be
   * reached by the driver. You can check which server was used for this query
   * by calling MongoCursor::info() after running the query. It's server field
   * will show which server the query was sent to.  Note that you should use
   * this function even if you do not use the automatic routing to secondaries.
   * If you connect directly to a secondary in a replica set, you still need to
   * call this function, which basically tells the database that you are aware
   * that you might be getting older data and you're okay with that. If you do
   * not call this, you'll get "not master" errors when you try to query.  This
   * method will override the static class variable MongoCursor::$slaveOkay. It
   * will also override Mongo::setSlaveOkay(), MongoDB::setSlaveOkay() and
   * MongoCollection::setSlaveOkay().
   */
  <<__Native("ZendCompat")>>
  public function slaveOkay(mixed $okay): mixed;

  /* Use snapshot mode for the query. Snapshot mode assures no duplicates are
   * returned, or objects missed, which were present at both the start and end
   * of the query's execution (if an object is new during the query, or deleted
   * during the query, it may or may not be returned, even with snapshot mode).
   * Note that short query responses (less than 1MB) are always effectively
   * snapshotted.  Currently, snapshot mode may not be used with sorting or
   * explicit hints.
   */
  <<__Native("ZendCompat")>>
  public function snapshot(): mixed;

  <<__Native("ZendCompat")>>
  public function sort(mixed $fields): mixed;

  /* Mongo has a feature known as tailable cursors which are similar to the Unix
   * "tail -f" command.  Tailable means cursor is not closed when the last data
   * is retrieved. Rather, the cursor marks the final object's position. you can
   * resume using the cursor later, from where it was located, if more data were
   * received.  Like any "latent cursor", the cursor may become invalid at some
   * point -- for example if that final object it references were deleted. Thus,
   * you should be prepared to requery if the cursor is MongoCursor::dead().
   */
  <<__Native("ZendCompat")>>
  public function tailable(mixed $tail): mixed;

/* A timeout can be set at any time and will affect subsequent queries on the
 * cursor, including fetching more results from the database.
 */
  <<__Native("ZendCompat")>>
  public function timeout(mixed $ms): mixed;

  <<__Native("ZendCompat")>>
  public function valid(): mixed;
}

/* A unique identifier created for database objects. If an object is inserted
 * into the database without an _id field, an _id field will be added to it
 * with a MongoId instance as its value. If the data has a naturally occuring
 * unique field (say, a username or timestamp) it is fine to use this as the
 * _id field instead, and it will not be replaced with a MongoId.  Instances
 * of the MongoId class fulfill the role that autoincrementing does in a
 * relational database: to provide a unique key if the data does not natually
 * have one. Autoincrementing does not work well with a sharded database, as
 * it is impossible to find what the next number should be quickly. This class
 * fulfills the constraints of quickly generating a value that is unique
 * across shards.  Each MongoId is 12 bytes (making its string form 24
 * hexidecimal characters). The first four bytes are a timestamp, the next
 * three are a hash of the client machine's hostname, the next two are the two
 * least significant bytes of the process id running the script, and the last
 * three bytes are an incrementing value.  MongoIds are
 * serializable/unserializable. Their serialized form is similar to their
 * string form: C:7:"MongoId":24:{4af9f23d8ead0e1d32000000}
 */
<<__NativeData("ZendCompat")>>
class MongoId {
  <<__Native("ZendCompat")>>
  public function __construct(mixed $id): mixed;

  /* This returns the hostname MongoId is using to generate unique ids. This
   * should be the same value gethostname() returns.  It is identical to the
   * function:
   */
  <<__Native("ZendCompat")>>
  public static function getHostname(): mixed;

  <<__Native("ZendCompat")>>
  public function getInc(): mixed;

  /* Extracts the pid from the Mongo ID
   */
  <<__Native("ZendCompat")>>
  public function getPID(): mixed;

  /* This returns the same thing as running time() when the id is created.
   */
  <<__Native("ZendCompat")>>
  public function getTimestamp(): mixed;

  /* This function is only used by PHP internally, it shouldn't need to ever be
   * called by the user.  It is identical to the function:
   */
  <<__Native("ZendCompat")>>
  public static function __set_state(mixed $props): mixed;

  <<__Native("ZendCompat")>>
  public function __toString(): mixed;
}

/* Represents JavaScript code for the database.  MongoCode objects are
 * composed of two parts: a string of code and an optional scope. The string
 * of code must be valid JavaScript. The scope is a associative array of
 * variable name/value pairs.
 */
<<__NativeData("ZendCompat")>>
class MongoCode {
  public string $code = '';
  public mixed $scope;

  <<__Native("ZendCompat")>>
  public function __construct(mixed $code,
                              mixed $scope): mixed;

  <<__Native("ZendCompat")>>
  public function __toString(): mixed;
}

/* Represent date objects for the database. This class should be used to save
 * dates to the database and to query for dates. For example: Example #1
 * Storing dates with MongoDate    MongoDB stores dates as milliseconds past
 * the epoch. This means that dates do not contain timezone information.
 * Timezones must be stored in a separate field if needed. Second, this means
 * that any precision beyond milliseconds will be lost when the document is
 * sent to/from the database.
 */
<<__NativeData("ZendCompat")>>
class MongoDate {
  public int $sec = 0;
  public int $usec = 0;

  /* Creates a new date. If no parameters are given, the current time is used.
   */
  <<__Native("ZendCompat")>>
  public function __construct(mixed $sec,
                              mixed $usec): mixed;

  /* Returns a string representation of this date, similar to the representation
   * returned by microtime().
   */
  <<__Native("ZendCompat")>>
  public function __toString(): mixed;
}

/* This class can be used to create regular expressions. Typically, these
 * expressions will be used to query the database and find matching strings.
 * More unusually, they can be saved to the database and retrieved.  Regular
 * expressions consist of four parts. First a / as starting delimiter, then
 * then pattern, another / and finally a string containing flags.  Example #1
 * Regular expression pattern /pattern/flags  MongoDB recognizes six regular
 * expression flags:  i: Case insensitive  m: Multiline  x: Can contain
 * comments  l: locale  s: dotall, "." matches everything, including newlines
 * u: match unicode
 */
<<__NativeData("ZendCompat")>>
class MongoRegex {
  public string $regex = '';
  public string $flags = '';

  /* Creates a new regular expression.
   */
  <<__Native("ZendCompat")>>
  public function __construct(mixed $regex): mixed;

  /* Returns a string representation of this regular expression.
   */
  <<__Native("ZendCompat")>>
  public function __toString(): mixed;
}

/* An object that can be used to store or retrieve binary data from the
 * database.  The maximum size of a single object that can be inserted into
 * the database is 16MB. For data that is larger than this (movies, music,
 * Henry Kissinger's autobiography), use MongoGridFS. For data that is smaller
 * than 16MB, you may find it easier to embed it within the document using
 * MongoBinData.  For example, to embed an image in a document, one could
 * write:    This class contains a type field, which currently gives no
 * additional functionality in the driver or the database. There are five
 * predefined types (which are the class constants listed below), and the user
 * can create their own (at the risk of the BSON spec catching up with them).
 * By default, the PHP driver always uses type 2: a byte array.
 */
<<__NativeData("ZendCompat")>>
class MongoBinData {
  public string $bin = '';
  public int $type = 0;

  /* Creates a new binary data object.  There are five types of binary data
   * currently recognized by the BSON spec: function (0x01), byte array (0x02),
   * UUID (0x03), MD5 (0x05), and user defined (0x80). The default type is byte
   * array (0x02). There is no particular difference in how the driver or server
   * interpret different types, so by and large they are irrelevant for now. Any
   * number (between 0 and 255) could be used for type, if the user is willing
   * to assume the risk that the database might eventually do something with
   * binary data based on type.
   */
  <<__Native("ZendCompat")>>
  public function __construct(mixed $data,
                              mixed $type): mixed;

  <<__Native("ZendCompat")>>
  public function __toString(): mixed;
}

/* The class can be used to save 32-bit integers to the database on a 64-bit
 * system.
 */
<<__NativeData("ZendCompat")>>
class MongoInt32 {
  public string $value = '';

  /* Creates a new 32-bit number with the given value.
   */
  <<__Native("ZendCompat")>>
  public function __construct(mixed $value): mixed;

  <<__Native("ZendCompat")>>
  public function __toString(): mixed;
}

/* The class can be used to save 64-bit integers to the database on a 32-bit
 * system.
 */
<<__NativeData("ZendCompat")>>
class MongoInt64 {
  public string $value = '';

  /* Creates a new 64-bit number with the given value.
   */
  <<__Native("ZendCompat")>>
  public function __construct(mixed $value): mixed;

  <<__Native("ZendCompat")>>
  public function __toString(): mixed;
}

/* This class can be used to create lightweight links between objects in
 * different collections.  Motivation: Suppose we need to refer to a document
 * in another collection. The easiest way is to create a field in the current
 * document. For example, if we had a "people" collection and an "addresses"
 * collection, we might want to create a link between each person document and
 * an address document: Example #1 Linking documents    Then, later on, we can
 * find the person's address by querying the "addresses" collection with the
 * MongoId we saved in the "people" collection.  Suppose now that we have a
 * more general case, where we don't know which collection (or even which
 * database) contains the referenced document. MongoDBRef is a good choice for
 * this case, as it is a common format that all of the drivers and the
 * database understand.  If each person had a list of things they liked which
 * could come from multiple collections, such as "hobbies", "sports", "books",
 * etc., we could use MongoDBRefs to keep track of what "like" went with what
 * collection: Example #2 Creating MongoDBRef links    Database references can
 * be thought of as hyperlinks: they give the unique address of another
 * document, but they do not load it or automatically follow the
 * link/reference.  A database reference is just a normal associative array,
 * not an instance of MongoDBRef, so this class is a little different than the
 * other data type classes. This class contains exclusively static methods for
 * manipulating database references.
 */
<<__NativeData("ZendCompat")>>
class MongoDBRef {
  protected static string $refKey = '$ref';
  protected static string $idKey = '$id';

  /* If no database is given, the current database is used.
   */
  <<__Native("ZendCompat")>>
  public static function create(mixed $collection,
                         mixed $id,
                         mixed $database): mixed;

  <<__Native("ZendCompat")>>
  public static function get(mixed $db,
                      mixed $ref): mixed;

  /* This method does not actually follow the reference, so it does not
   * determine if it is broken or not. It merely checks that ref is in valid
   * database reference format (in that it is an object or array with $ref and
   * $id fields).
   */
  <<__Native("ZendCompat")>>
  public static function isRef(mixed $ref): mixed;
}

/* MongoMinKey is a special type used by the database that evaluates to less
 * than any other type. Thus, if a query is sorted by a given field in
 * ascending order, any document with a MongoMinKey as its value will be
 * returned first.  MongoMinKey has no associated fields, methods, or
 * constants. It is merely the "smallest" thing that can be inserted into the
 * database.
 */
<<__NativeData("ZendCompat")>>
class MongoMinKey {
}

/* MongoMaxKey is a special type used by the database that evaluates to
 * greater than any other type. Thus, if a query is sorted by a given field in
 * ascending order, any document with a MongoMaxKey as its value will be
 * returned last.  MongoMaxKey has no associated fields, methods, or
 * constants. It is merely the "largest" thing that can be inserted into the
 * database.
 */
<<__NativeData("ZendCompat")>>
class MongoMaxKey {
}

/* MongoTimestamp is used by sharding. If you're not looking to write sharding
 * tools, what you probably want is MongoDate.  MongoTimestamp is 4 bytes of
 * timestamp (seconds since the epoch) and 4 bytes of increment.  This class
 * is not for measuring time, creating a timestamp on a document or
 * automatically adding or updating a timestamp on a document. Unless you are
 * writing something that interacts with the sharding internals, stop, go
 * directly to MongoDate, do not pass go, do not collect 200 dollars. This is
 * not the class you are looking for.  If you are writing sharding tools, read
 * on.
 */
<<__NativeData("ZendCompat")>>
class MongoTimestamp {
  public int $sec = 0;
  public int $inc = 0;

  /* Creates a new timestamp. If no parameters are given, the current time is
   * used and the increment is automatically provided. The increment is set to 0
   * when the module is loaded and is incremented every time this constructor is
   * called (without the $inc parameter passed in).
   */
  <<__Native("ZendCompat")>>
  public function __construct(mixed $sec,
                              mixed $inc): mixed;

  /* Returns the "sec" field of this timestamp.
   */
  <<__Native("ZendCompat")>>
  public function __toString(): mixed;
}

/* Utilities for storing and retrieving files from the database.  GridFS is a
 * storage specification all supported drivers implement. Basically, it
 * defines two collections: files, for file metadata, and chunks, for file
 * content. If the file is large, it will automatically be split into smaller
 * chunks and each chunk will be saved as a document in the chunks collection.
 *  Each document in the files collection contains the filename, upload date,
 * and md5 hash. It also contains a unique _id field, which can be used to
 * query the chunks collection for the file's content. Each document in the
 * chunks collection contains a chunk of binary data, a files_id field that
 * matches its file's _id, and the position of this chunk in the overall file.
 *  For example, the files document is something like:  and the chunks
 * documents look like:  Of course, the default chunk size is thousands of
 * bytes, but that makes an unwieldy example.
 */
<<__NativeData("ZendCompat")>>
class MongoGridFS extends MongoCollection {
  public mixed $chunks;
  protected mixed $filesName;
  protected mixed $chunksName;

  /* Files as stored across two collections, the first containing file meta
   * information, the second containing chunks of the actual file. By default,
   * fs.files and fs.chunks are the collection names used.  Use one argument to
   * specify a prefix other than "fs": $fs = new MongoGridFS($db, "myfiles");
   * uses myfiles.files and myfiles.chunks collections.
   */
  <<__Native("ZendCompat")>>
  public function __construct(): mixed;

  <<__Native("ZendCompat")>>
  public function delete(mixed $id): mixed;

  <<__Native("ZendCompat")>>
  public function drop(): mixed;

  <<__Native("ZendCompat")>>
  public function find(mixed $query,
                       mixed $fields): mixed;

  <<__Native("ZendCompat")>>
  public function findOne(mixed $query): mixed;

  <<__Native("ZendCompat")>>
  public function get(mixed $id): mixed;

  <<__Native("ZendCompat")>>
  public function put(mixed $filename,
                      mixed $metadata): mixed;

  <<__Native("ZendCompat")>>
  public function remove(mixed $query,
                         mixed $options): mixed;

  <<__Native("ZendCompat")>>
  public function storeBytes(mixed $bytes,
                             mixed $metadata,
                             mixed $options): mixed;

  <<__Native("ZendCompat")>>
  public function storeFile(mixed $filename,
                            mixed $metadata,
                            mixed $options): mixed;

  <<__Native("ZendCompat")>>
  public function storeUpload(mixed $name,
                              mixed $metadata): mixed;
}

/* A database file object.
 */
<<__NativeData("ZendCompat")>>
class MongoGridFSFile {
  public mixed $file;
  protected mixed $gridfs;

  <<__Native("ZendCompat")>>
  public function __construct(mixed $gridfs,
                              mixed $file): mixed;

  /* Warning: this will load the file into memory. If the file is bigger than
   * your memory, this will cause problems!
   */
  <<__Native("ZendCompat")>>
  public function getBytes(): mixed;

  <<__Native("ZendCompat")>>
  public function getFilename(): mixed;

  /* This method returns a stream resource that can be used with all file
   * functions in PHP that deal with reading files. The contents of the file are
   * pulled out of MongoDB on the fly, so that the whole file does not have to
   * be loaded into memory first.  At most two GridFSFile chunks will be loaded
   * in memory.
   */
  <<__Native("ZendCompat")>>
  public function getResource(): mixed;

  <<__Native("ZendCompat")>>
  public function getSize(): mixed;

  <<__Native("ZendCompat")>>
  public function write(mixed $filename): mixed;
}

/* Cursor for database file results.
 */
<<__NativeData("ZendCompat")>>
class MongoGridFSCursor extends MongoCursor {
  protected mixed $gridfs;

  <<__Native("ZendCompat")>>
  public function __construct(mixed $gridfs,
                              mixed $connection,
                              mixed $ns,
                              mixed $query,
                              mixed $fields): mixed;

  <<__Native("ZendCompat")>>
  public function current(): mixed;

  <<__Native("ZendCompat")>>
  public function getNext(): mixed;
}

/* Logging can be used to get detailed information about what the driver is
 * doing. The logging mechanism as used by MongoLog emits all log messages as
 * a PHP notice. Depending on the server interface that you use, that means
 * that they will either be sent to strerr (with PHP-CLI), or otherwise to the
 * web server's error log. In order for log messages to be output by PHP their
 * level (E_NOTICE) does need to be configured to be shown. That means the
 * E_NOTICE bit needs to be part of PHP's error_reporting level and that
 * display_errors is set to 1.  Logging is turned off, by default. This class
 * allows you to turn on specific levels of logging for specific parts of the
 * driver. Some examples:
 */
<<__NativeData("ZendCompat")>>
class MongoLog {
  private static int $level = 0;
  private static int $module = 0;
  private static mixed $callback = 0;

  /* Retrieves the callback function name.
   */
  <<__Native("ZendCompat")>>
  public static function getCallback(): mixed;

  /* This can be used to see the log level. Use the constants described in the
   * MongoLog section with bitwise operators to check the level.
   */
  <<__Native("ZendCompat")>>
  public static function getLevel(): mixed;

  /* This function can be used to see which parts of the driver's functionality
   * are being logged. Use the constants described in the MongoLog section with
   * bitwise operators to check if specific modules are being logged.
   */
  <<__Native("ZendCompat")>>
  public static function getModule(): mixed;

  /* This function will set a callback function to be called for MongoLog events
   * instead of triggering warnings.
   */
  <<__Native("ZendCompat")>>
  public static function setCallback(mixed $log_function,
                              mixed $module,
                              mixed $level): mixed;

  /* This function can be used to set how verbose logging should be and the
   * types of activities that should be logged. Use the constants described in
   * the MongoLog section with bitwise operators to specify levels.    Note that
   * you must also call MongoLog::setModule() to choose what part of the driver
   * to log.
   */
  <<__Native("ZendCompat")>>
  public static function setLevel(mixed $level): mixed;

  /* This function can be used to set which parts of the driver's functionality
   * should be logged. Use the constants described in the MongoLog section with
   * bitwise operators to specify modules.    Note that you must also call
   * MongoLog::setLevel() to turn on logging.
   */
  <<__Native("ZendCompat")>>
  public static function setModule(mixed $module): mixed;
}

/* Warning  The current (1.3.0+) releases of the driver no longer implements
 * pooling. This class and its methods are therefore deprecated and should not
 * be used.
 */
<<__NativeData("ZendCompat")>>
class MongoPool {

  <<__Native("ZendCompat")>>
  public static function getSize(): mixed;

  /* Returns an array of information about all connection pools.
   */
  <<__Native("ZendCompat")>>
  public static function info(): mixed;

  /* Sets the max number of connections new pools will be able to create.
   */
  <<__Native("ZendCompat")>>
  public static function setSize(mixed $size): mixed;
}

/* A connection between PHP and MongoDB.  This class extends MongoClient and
 * provides access to several deprecated methods.  For backwards
 * compatibility, it also defaults the "w" option of its constructor argument
 * to 0, which does not require write operations to be acknowledged by the
 * server. See MongoClient::__construct() for more information. Warning This
 * class has been DEPRECATED as of version 1.3.0. Relying on this feature is
 * highly discouraged. Please use MongoClient instead.
 */
<<__NativeData("ZendCompat")>>
class Mongo extends MongoClient {

  <<__Native("ZendCompat")>>
  public function connectUtil(): mixed;

  /* This method overwrites the MongoClient constructor and turns off
   * acknowledged writes.  Please see MongoClient::__construct() for description
   * of the parameters.
   */
  <<__Native("ZendCompat")>>
  public function __construct(mixed $server = null, mixed $options = null): mixed;

  <<__Native("ZendCompat")>>
  public static function getPoolSize(): mixed;

  /* This finds the address of the secondary currently being used for reads. It
   * is a read-only method: it does not change anything about the internal state
   * of the object.  When you create a connection to the database, the driver
   * will not immediately decide on a secondary to use. Thus, after you connect,
   * this function will return NULL even if there are secondaries available.
   * When you first do a query with slaveOkay set, at that point the driver will
   * choose a secondary for this connection. At that point, this function will
   * return the chosen secondary.  See the query section of this manual for
   * information on distributing reads to secondaries.
   */
  <<__Native("ZendCompat")>>
  public function getSlave(): mixed;

  /* See the query section of this manual for information on distributing reads
   * to secondaries.
   */
  <<__Native("ZendCompat")>>
  public function getSlaveOkay(): mixed;

  <<__Native("ZendCompat")>>
  public static function poolDebug(): mixed;

  <<__Native("ZendCompat")>>
  public static function setPoolSize(mixed $size): mixed;

  /* See the query section of this manual for information on distributing reads
   * to secondaries.
   */
  <<__Native("ZendCompat")>>
  public function setSlaveOkay(mixed $ok): mixed;

  /* This choses a random secondary for a connection to read from. It is called
   * automatically by the driver and should not need to be used. It calls
   * MongoClient::getHosts() (to refresh the status of hosts) and
   * Mongo::getSlave() (to get the return value).  See the query section of this
   * manual for information on distributing reads to secondaries.
   */
  <<__Native("ZendCompat")>>
  public function switchSlave(): mixed;
}

/* Default Mongo exception.  This covers a bunch of different error conditions
 * that may eventually be moved to more specific exceptions, but will always
 * extend MongoException.  The MongoSomething object has not been correctly
 * initialized by its constructor  Code: 0  Probably your Mongo object is not
 * connected to a database server.  zero-length keys are not allowed, did you
 * use $ with double quotes?  Code: 1  You tried to save "" as a key. You
 * generally should not do this. "" can mess up subobject access and is used
 * by MongoDB internally. However, if you really want, you can set
 * mongo.allow_empty_keys to true in your php.ini file to override this sanity
 * check. If you override this, it is highly recommended that you set error
 * checking to strict to avoid string interpolation errors.  '.' not allowed
 * in key: <key>  Code: 2  You attempted to write a key with '.' in it, which
 * is prohibited.  insert too large: <size>, max: <max>  Code: 3  You're
 * attempting to send too much data to the database at once: the database will
 * only accept inserts up to a certain size (currently 16 MB).  no elements in
 * doc  Code: 4  You're attempting to save a document with no fields.  size of
 * BSON doc is <size> bytes, max <max>MB  Code: 5  You're attempting to save a
 * document that is larger than MongoDB can save.  no documents given  Code: 6
 *  You're attempting to batch insert an empty array of documents.
 * MongoCollection::group takes an array, object, or MongoCode key  Code: 7
 * Wrong type parameter send to MongoCollection::group().  field names must be
 * strings  Code: 8  You should format field selectors as array("field1" => 1,
 * "field2" => 1, ..., "fieldN" => 1).  invalid regex  Code: 9  The regex
 * passed to MongoRegex is not of the correct form.  MongoDBRef::get: $ref
 * field must be a string  Code: 10  MongoDBRef::get: $db field must be a
 * string  Code: 11  non-utf8 string: <str>  Code: 12  This error occurs if
 * you attempt to send a non-utf8 string to the database. All strings going
 * into the database should be UTF8. See php.ini options for the transition
 * option of quieting this exception.  mutex error: <err>  Code: 13  The
 * driver uses mutexes for synchronizing requests and responses in
 * multithreaded environments. This is a fairly serious error and may not have
 * a stack trace. It's unusual and should be reported to maintainers with any
 * system information and steps to reproduce that you can provide.  index name
 * too long: <len>, max <max> characters  Code: 14  Indexes with names longer
 * than 128 characters cannot be created. If you get this error, you should
 * use MongoCollection::ensureIndex()'s "name" option to create a shorter name
 * for your index.
 */
<<__NativeData("ZendCompat")>>
class MongoException extends Exception {
}

/* The MongoResultException is thrown by several command helpers (such as
 * MongoCollection::findAndModify()) in the event of failure. The original
 * result document is available through MongoResultException::getDocument().
 */
<<__NativeData("ZendCompat")>>
class MongoResultException extends MongoException {
  public mixed $document;

  /* Retrieves the full error result document.
   */
  <<__Native("ZendCompat")>>
  public function getDocument(): mixed;
}

/* Caused by accessing a cursor incorrectly or a error receiving a reply. Note
 * that this can be thrown by any database request that receives a reply, not
 * just queries. Writes, commands, and any other operation that sends
 * information to the database and waits for a response can throw a
 * MongoCursorException. The only exception is new MongoClient() (creating a
 * new connection), which will only throw MongoConnectionExceptions.  This
 * returns a specific error message to help diagnose the problem and a numeric
 * error code associated with the cause of the exception.  For example,
 * suppose you tried to insert two documents with the same _id:  This would
 * produce output like:  Note that the MongoDB error code (11000) is used for
 * the PHP error code. The PHP driver uses the "native" error code wherever
 * possible.  The following is a list of common errors, codes, and causes.
 * Exact errors are in italics, errors where the message can vary are
 * described in obliques.  cannot modify cursor after beginning iteration
 * Code: 0  You are calling a method that sets up the query after executing
 * the query. Reset the cursor and try again.  An example:    Get next batch
 * send errors  Code: 1  Could not send the query to the database. Make sure
 * the database is still up and the network is okay.  cursor not found  Code:
 * 2  The driver was trying to fetch more results from the database, but the
 * database did not have a record of the query. This usually means that the
 * cursor timed out on the server side: after a few minutes of inactivity, the
 * database will kill a cursor (see MongoCursor::immortal() for information on
 * preventing this).  An example:    cursor->buf.pos is null  Code: 3  This
 * may indicate you are out of RAM or some other extraordinary circumstance.
 * couldn't get response header  Code: 4  A common error if the database or
 * network goes down. This means that the driver couldn't get a response from
 * the connection.  no db response  Code: 5  This may not even be an error,
 * for example, the database command "shutdown" returns no response. However,
 * if you were expecting a response, this means the database didn't give one.
 * bad response length: %d, did the db assert?  Code: 6  This means that the
 * database said that its response was less than 0. This error probably
 * indicates a network error or database corruption.  incomplete header  Code:
 * 7  Highly unusual. Occurs if the database response started out correctly,
 * but broke off in the middle. Probably indicates a network problem.
 * incomplete response  Code: 8  Highly unusual. Occurs if the database
 * response started out correctly, but broke off in the middle. Probably
 * indicates a network problem.  couldn't find a response  Code: 9  If the
 * response was cached and now cannot be located.  error getting socket  Code:
 * 10  The socket was closed or encountered an error. The driver should
 * automatically reconnect (if possible) on the next operation.  couldn't find
 * reply, please try again  Code: 11  The driver saves any database responses
 * it cannot immediately match with a request. This exception occurs if the
 * driver has already passed your request's response and cannot find your
 * response in its cache.  error getting database response: errstr  WSA error
 * getting database response: errstr  "errstr" is an io error reported
 * directly from the C socket subsystem. On Windows, the error message is
 * prefixed with "WSA".  Timeout error  Code: 13  If there was an error while
 * waiting for a query to complete.  couldn't send query: <various>  Code: 14
 * C socket error on send.  max number of retries exhausted, couldn't send
 * query  Code: 19  The driver will automatically retry "plain" queries (not
 * commands) a couple of times if the first attempt failed for certain
 * reasons. This is to cause fewer exceptions during replica set failover
 * (although you will probably still have to deal with some) and gloss over
 * transient network issues.  This can also be caused by the driver not being
 * able to reconnect at all to the database (if, for example, the database is
 * unreachable).  Version 1.2.2+.
 */
<<__NativeData("ZendCompat")>>
class MongoCursorException extends MongoException {
  private mixed $host;
  private int $fd = 0;

  /* Returns the hostname of the server the query was sent too.
   */
  <<__Native("ZendCompat")>>
  public function getHost(): mixed;
}

/* Caused by a query timing out. You can set the length of time to wait before
 * this exception is thrown by calling MongoCursor::timeout() on the cursor or
 * setting MongoCursor::$timeout. The static variable is useful for queries
 * such as database commands and MongoCollection::findOne(), both of which
 * implicitly use cursors.
 */
<<__NativeData("ZendCompat")>>
class MongoCursorTimeoutException extends MongoCursorException {
}

/* Thrown when the driver fails to connect to the database.  There are a
 * number of possible error messages to help you diagnose the connection
 * problem. These are:  No candidate servers found  Thrown when the driver
 * cannot establish a connection to MongoDB (fulfilling the ReadPreferences,
 * if specified).  No server name given.  This error occurs if you pass in ""
 * as the server name, probably because of an typo with string interpolation,
 * e.g., "$servr" instead of "$server".  failed to get host [hostname] or port
 * [portnum] from [server].  This indicated that the server string was
 * malformed. "[hostname]" and "[portnum]" will be as much as the driver could
 * dicipher of it.  Operation in progress  Connecting to the database timed
 * out.  Transport endpoint is not connected  Generally means that the
 * connection string isn't correct, the driver couldn't even find the database
 * server.  couldn't determine master  No server in a replica set connection
 * was identified as the primary.  couldn't get host info for [server]  This
 * indicated that DNS could not resolve the server address you gave. This
 * could easily be caused by a typo, for example, "server" instead of
 * "$server".  Invalid Argument  This can be caused by attempting to connect
 * to a machine that is up but that the database isn't actually running on.
 * Make sure that you've started the database server before connecting.
 * Permission denied  This means that the socket could not be opened due to
 * permissions issues. On Red Hat variants, this can be caused by a default
 * setting that does not allow Apache to create network connections. You can
 * override this setting by running:  then restarting Apache.  If the error
 * message is not listed above, it is probably an error from the C socket, and
 * you can search the web for its usual cause.
 */
<<__NativeData("ZendCompat")>>
class MongoConnectionException extends MongoException {
}

/* Thrown when there are errors reading or writing files to or from the
 * database.
 */
<<__NativeData("ZendCompat")>>
class MongoGridFSException extends MongoException {
}

/* This function is very beta and entirely useless for 99% of users. It is
 * only useful if you're doing something weird, such as writing your own
 * driver on top of the PHP driver.
 */
<<__Native("ZendCompat")>>
function bson_decode(mixed $bson): mixed;

/* This function is very beta and entirely useless for 99% of users. It is
 * only useful if you're doing something weird, such as writing your own
 * driver on top of the PHP driver.
 */
<<__Native("ZendCompat")>>
function bson_encode(mixed $anything): mixed;
