/*
   +----------------------------------------------------------------------+
   | HipHop for PHP                                                       |
   +----------------------------------------------------------------------+
   | Copyright (c) 2010-2014 Facebook, Inc. (http://www.facebook.com)     |
   | Copyright (c) 1997-2010 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
*/

#include "hphp/runtime/ext/imagick/constants.h"
#include "hphp/runtime/ext/imagick/ext_imagick.h"

namespace HPHP {

const StaticString
  // coord
  s_x("x"),
  s_y("y"),
  // size
  s_columns("columns"),
  s_rows("rows"),
  // geometry
  s_width("width"),
  s_height("height"),
  // affine
  s_sx("sx"),
  s_rx("rx"),
  s_ry("ry"),
  s_sy("sy"),
  s_tx("tx"),
  s_ty("ty"),
  // color
  s_r("r"),
  s_g("g"),
  s_b("b"),
  s_a("a"),
  s_hue("hue"),
  s_saturation("saturation"),
  s_luminosity("luminosity"),
  // extrema
  s_min("min"),
  s_max("max"),
  // channel extrema/range
  s_minima("minima"),
  s_maxima("maxima"),
  // channel kurtosis
  s_kurtosis("kurtosis"),
  s_skewness("skewness"),
  // channel mean
  s_mean("mean"),
  s_standardDeviation("standardDeviation"),
  // other channel statistics
  s_depth("depth"),
  // quantum depth
  s_quantumDepthLong("quantumDepthLong"),
  s_quantumDepthString("quantumDepthString"),
  // quantum range
  s_quantumRangeLong("quantumRangeLong"),
  s_quantumRangeString("quantumRangeString"),
  // version
  s_versionNumber("versionNumber"),
  s_versionString("versionString"),
  // identify
  s_imageName("imageName"),
  s_mimetype("mimetype"),
  s_geometry("geometry"),
  s_resolution("resolution"),
  s_signature("signature"),
  s_rawOutput("rawOutput"),
  s_format("format"),
  s_units("units"),
  s_type("type"),
  s_colorSpace("colorSpace"),
  s_fileSize("fileSize"),
  s_compression("compression"),
  // font metrics
  s_characterWidth("characterWidth"),
  s_characterHeight("characterHeight"),
  s_ascender("ascender"),
  s_descender("descender"),
  s_textWidth("textWidth"),
  s_textHeight("textHeight"),
  s_maxHorizontalAdvance("maxHorizontalAdvance"),
  s_x1("x1"),
  s_y1("y1"),
  s_x2("x2"),
  s_y2("y2"),
  s_originX("originX"),
  s_originY("originY"),
  s_boundingBox("boundingBox"),
  // class name
  s_Imagick("Imagick"),
  s_ImagickDraw("ImagickDraw"),
  s_ImagickPixel("ImagickPixel"),
  s_ImagickPixelIterator("ImagickPixelIterator");

static const StaticString
  // COLOR_* constants
  s_COLOR_BLACK("COLOR_BLACK"),
  s_COLOR_BLUE("COLOR_BLUE"),
  s_COLOR_CYAN("COLOR_CYAN"),
  s_COLOR_GREEN("COLOR_GREEN"),
  s_COLOR_RED("COLOR_RED"),
  s_COLOR_YELLOW("COLOR_YELLOW"),
  s_COLOR_MAGENTA("COLOR_MAGENTA"),
  s_COLOR_OPACITY("COLOR_OPACITY"),
  s_COLOR_ALPHA("COLOR_ALPHA"),
  s_COLOR_FUZZ("COLOR_FUZZ"),

  // DISPOSE constants
  s_DISPOSE_UNRECOGNIZED("DISPOSE_UNRECOGNIZED"),
  s_DISPOSE_UNDEFINED("DISPOSE_UNDEFINED"),
  s_DISPOSE_NONE("DISPOSE_NONE"),
  s_DISPOSE_BACKGROUND("DISPOSE_BACKGROUND"),
  s_DISPOSE_PREVIOUS("DISPOSE_PREVIOUS"),

  // Composite Operator Constants
  s_COMPOSITE_DEFAULT("COMPOSITE_DEFAULT"),
  s_COMPOSITE_UNDEFINED("COMPOSITE_UNDEFINED"),
  s_COMPOSITE_NO("COMPOSITE_NO"),
  s_COMPOSITE_ADD("COMPOSITE_ADD"),
  s_COMPOSITE_ATOP("COMPOSITE_ATOP"),
  s_COMPOSITE_BLEND("COMPOSITE_BLEND"),
  s_COMPOSITE_BUMPMAP("COMPOSITE_BUMPMAP"),
  s_COMPOSITE_CLEAR("COMPOSITE_CLEAR"),
  s_COMPOSITE_COLORBURN("COMPOSITE_COLORBURN"),
  s_COMPOSITE_COLORDODGE("COMPOSITE_COLORDODGE"),
  s_COMPOSITE_COLORIZE("COMPOSITE_COLORIZE"),
  s_COMPOSITE_COPYBLACK("COMPOSITE_COPYBLACK"),
  s_COMPOSITE_COPYBLUE("COMPOSITE_COPYBLUE"),
  s_COMPOSITE_COPY("COMPOSITE_COPY"),
  s_COMPOSITE_COPYCYAN("COMPOSITE_COPYCYAN"),
  s_COMPOSITE_COPYGREEN("COMPOSITE_COPYGREEN"),
  s_COMPOSITE_COPYMAGENTA("COMPOSITE_COPYMAGENTA"),
  s_COMPOSITE_COPYOPACITY("COMPOSITE_COPYOPACITY"),
  s_COMPOSITE_COPYRED("COMPOSITE_COPYRED"),
  s_COMPOSITE_COPYYELLOW("COMPOSITE_COPYYELLOW"),
  s_COMPOSITE_DARKEN("COMPOSITE_DARKEN"),
  s_COMPOSITE_DSTATOP("COMPOSITE_DSTATOP"),
  s_COMPOSITE_DST("COMPOSITE_DST"),
  s_COMPOSITE_DSTIN("COMPOSITE_DSTIN"),
  s_COMPOSITE_DSTOUT("COMPOSITE_DSTOUT"),
  s_COMPOSITE_DSTOVER("COMPOSITE_DSTOVER"),
  s_COMPOSITE_DIFFERENCE("COMPOSITE_DIFFERENCE"),
  s_COMPOSITE_DISPLACE("COMPOSITE_DISPLACE"),
  s_COMPOSITE_DISSOLVE("COMPOSITE_DISSOLVE"),
  s_COMPOSITE_EXCLUSION("COMPOSITE_EXCLUSION"),
  s_COMPOSITE_HARDLIGHT("COMPOSITE_HARDLIGHT"),
  s_COMPOSITE_HUE("COMPOSITE_HUE"),
  s_COMPOSITE_IN("COMPOSITE_IN"),
  s_COMPOSITE_LIGHTEN("COMPOSITE_LIGHTEN"),
  s_COMPOSITE_LUMINIZE("COMPOSITE_LUMINIZE"),
  s_COMPOSITE_MINUS("COMPOSITE_MINUS"),
  s_COMPOSITE_MODULATE("COMPOSITE_MODULATE"),
  s_COMPOSITE_MULTIPLY("COMPOSITE_MULTIPLY"),
  s_COMPOSITE_OUT("COMPOSITE_OUT"),
  s_COMPOSITE_OVER("COMPOSITE_OVER"),
  s_COMPOSITE_OVERLAY("COMPOSITE_OVERLAY"),
  s_COMPOSITE_PLUS("COMPOSITE_PLUS"),
  s_COMPOSITE_REPLACE("COMPOSITE_REPLACE"),
  s_COMPOSITE_SATURATE("COMPOSITE_SATURATE"),
  s_COMPOSITE_SCREEN("COMPOSITE_SCREEN"),
  s_COMPOSITE_SOFTLIGHT("COMPOSITE_SOFTLIGHT"),
  s_COMPOSITE_SRCATOP("COMPOSITE_SRCATOP"),
  s_COMPOSITE_SRC("COMPOSITE_SRC"),
  s_COMPOSITE_SRCIN("COMPOSITE_SRCIN"),
  s_COMPOSITE_SRCOUT("COMPOSITE_SRCOUT"),
  s_COMPOSITE_SRCOVER("COMPOSITE_SRCOVER"),
  s_COMPOSITE_SUBTRACT("COMPOSITE_SUBTRACT"),
  s_COMPOSITE_THRESHOLD("COMPOSITE_THRESHOLD"),
  s_COMPOSITE_XOR("COMPOSITE_XOR"),
  s_COMPOSITE_CHANGEMASK("COMPOSITE_CHANGEMASK"),
  s_COMPOSITE_LINEARLIGHT("COMPOSITE_LINEARLIGHT"),
  s_COMPOSITE_DIVIDE("COMPOSITE_DIVIDE"),
  s_COMPOSITE_DISTORT("COMPOSITE_DISTORT"),
  s_COMPOSITE_BLUR("COMPOSITE_BLUR"),
  s_COMPOSITE_PEGTOPLIGHT("COMPOSITE_PEGTOPLIGHT"),
  s_COMPOSITE_VIVIDLIGHT("COMPOSITE_VIVIDLIGHT"),
  s_COMPOSITE_PINLIGHT("COMPOSITE_PINLIGHT"),
  s_COMPOSITE_LINEARDODGE("COMPOSITE_LINEARDODGE"),
  s_COMPOSITE_LINEARBURN("COMPOSITE_LINEARBURN"),
  s_COMPOSITE_MATHEMATICS("COMPOSITE_MATHEMATICS"),
  s_COMPOSITE_MODULUSADD("COMPOSITE_MODULUSADD"),
  s_COMPOSITE_MODULUSSUBTRACT("COMPOSITE_MODULUSSUBTRACT"),
#if MagickLibVersion >= 0x670
  s_COMPOSITE_MINUSDST("COMPOSITE_MINUSDST"),
  s_COMPOSITE_DIVIDEDST("COMPOSITE_DIVIDEDST"),
  s_COMPOSITE_DIVIDESRC("COMPOSITE_DIVIDESRC"),
  s_COMPOSITE_MINUSSRC("COMPOSITE_MINUSSRC"),
  s_COMPOSITE_DARKENINTENSITY("COMPOSITE_DARKENINTENSITY"),
  s_COMPOSITE_LIGHTENINTENSITY("COMPOSITE_LIGHTENINTENSITY"),
#endif

  // MONTAGEMODE constants
  s_MONTAGEMODE_FRAME("MONTAGEMODE_FRAME"),
  s_MONTAGEMODE_UNFRAME("MONTAGEMODE_UNFRAME"),
  s_MONTAGEMODE_CONCATENATE("MONTAGEMODE_CONCATENATE"),

  // STYLE constants
  s_STYLE_NORMAL("STYLE_NORMAL"),
  s_STYLE_ITALIC("STYLE_ITALIC"),
  s_STYLE_OBLIQUE("STYLE_OBLIQUE"),
  s_STYLE_ANY("STYLE_ANY"),

  // FILTER constants
  s_FILTER_UNDEFINED("FILTER_UNDEFINED"),
  s_FILTER_POINT("FILTER_POINT"),
  s_FILTER_BOX("FILTER_BOX"),
  s_FILTER_TRIANGLE("FILTER_TRIANGLE"),
  s_FILTER_HERMITE("FILTER_HERMITE"),
  s_FILTER_HANNING("FILTER_HANNING"),
  s_FILTER_HAMMING("FILTER_HAMMING"),
  s_FILTER_BLACKMAN("FILTER_BLACKMAN"),
  s_FILTER_GAUSSIAN("FILTER_GAUSSIAN"),
  s_FILTER_QUADRATIC("FILTER_QUADRATIC"),
  s_FILTER_CUBIC("FILTER_CUBIC"),
  s_FILTER_CATROM("FILTER_CATROM"),
  s_FILTER_MITCHELL("FILTER_MITCHELL"),
  s_FILTER_LANCZOS("FILTER_LANCZOS"),
  s_FILTER_BESSEL("FILTER_BESSEL"),
  s_FILTER_SINC("FILTER_SINC"),
  s_FILTER_KAISER("FILTER_KAISER"),
  s_FILTER_WELSH("FILTER_WELSH"),
  s_FILTER_PARZEN("FILTER_PARZEN"),
  s_FILTER_LAGRANGE("FILTER_LAGRANGE"),
  s_FILTER_SENTINEL("FILTER_SENTINEL"),
  s_FILTER_BOHMAN("FILTER_BOHMAN"),
  s_FILTER_BARTLETT("FILTER_BARTLETT"),
  s_FILTER_JINC("FILTER_JINC"),
  s_FILTER_SINCFAST("FILTER_SINCFAST"),
  s_FILTER_ROBIDOUX("FILTER_ROBIDOUX"),
  s_FILTER_LANCZOSSHARP("FILTER_LANCZOSSHARP"),
  s_FILTER_LANCZOS2("FILTER_LANCZOS2"),
  s_FILTER_LANCZOS2SHARP("FILTER_LANCZOS2SHARP"),
#if MagickLibVersion >= 0x677
  s_FILTER_ROBIDOUXSHARP("FILTER_ROBIDOUXSHARP"),
  s_FILTER_COSINE("FILTER_COSINE"),
#endif
#if MagickLibVersion >= 0x678
  s_FILTER_SPLINE("FILTER_SPLINE"),
#endif
#if MagickLibVersion >= 0x681
  s_FILTER_LANCZOSRADIUS("FILTER_LANCZOSRADIUS"),
#endif

  // IMGTYPE constants
  s_IMGTYPE_UNDEFINED("IMGTYPE_UNDEFINED"),
  s_IMGTYPE_BILEVEL("IMGTYPE_BILEVEL"),
  s_IMGTYPE_GRAYSCALE("IMGTYPE_GRAYSCALE"),
  s_IMGTYPE_GRAYSCALEMATTE("IMGTYPE_GRAYSCALEMATTE"),
  s_IMGTYPE_PALETTEMATTE("IMGTYPE_PALETTEMATTE"),
  s_IMGTYPE_TRUECOLOR("IMGTYPE_TRUECOLOR"),
  s_IMGTYPE_TRUECOLORMATTE("IMGTYPE_TRUECOLORMATTE"),
  s_IMGTYPE_COLORSEPARATION("IMGTYPE_COLORSEPARATION"),
  s_IMGTYPE_COLORSEPARATIONMATTE("IMGTYPE_COLORSEPARATIONMATTE"),
  s_IMGTYPE_OPTIMIZE("IMGTYPE_OPTIMIZE"),
  s_IMGTYPE_PALETTEBILEVELMATTE("IMGTYPE_PALETTEBILEVELMATTE"),

  // RESOLUTION constants
  s_RESOLUTION_UNDEFINED("RESOLUTION_UNDEFINED"),
  s_RESOLUTION_PIXELSPERINCH("RESOLUTION_PIXELSPERINCH"),
  s_RESOLUTION_PIXELSPERCENTIMETER("RESOLUTION_PIXELSPERCENTIMETER"),

  // COMPRESSION constants
  s_COMPRESSION_UNDEFINED("COMPRESSION_UNDEFINED"),
  s_COMPRESSION_NO("COMPRESSION_NO"),
  s_COMPRESSION_BZIP("COMPRESSION_BZIP"),
  s_COMPRESSION_FAX("COMPRESSION_FAX"),
  s_COMPRESSION_GROUP4("COMPRESSION_GROUP4"),
  s_COMPRESSION_JPEG("COMPRESSION_JPEG"),
  s_COMPRESSION_JPEG2000("COMPRESSION_JPEG2000"),
  s_COMPRESSION_LOSSLESSJPEG("COMPRESSION_LOSSLESSJPEG"),
  s_COMPRESSION_LZW("COMPRESSION_LZW"),
  s_COMPRESSION_RLE("COMPRESSION_RLE"),
  s_COMPRESSION_ZIP("COMPRESSION_ZIP"),
  s_COMPRESSION_DXT1("COMPRESSION_DXT1"),
  s_COMPRESSION_DXT3("COMPRESSION_DXT3"),
  s_COMPRESSION_DXT5("COMPRESSION_DXT5"),
  s_COMPRESSION_ZIPS("COMPRESSION_ZIPS"),
  s_COMPRESSION_PIZ("COMPRESSION_PIZ"),
  s_COMPRESSION_PXR24("COMPRESSION_PXR24"),
  s_COMPRESSION_B44("COMPRESSION_B44"),
  s_COMPRESSION_B44A("COMPRESSION_B44A"),
  s_COMPRESSION_LZMA("COMPRESSION_LZMA"),
#if MagickLibVersion >= 0x670
  s_COMPRESSION_JBIG1("COMPRESSION_JBIG1"),
  s_COMPRESSION_JBIG2("COMPRESSION_JBIG2"),
#endif

  // PAINT constants
  s_PAINT_POINT("PAINT_POINT"),
  s_PAINT_REPLACE("PAINT_REPLACE"),
  s_PAINT_FLOODFILL("PAINT_FLOODFILL"),
  s_PAINT_FILLTOBORDER("PAINT_FILLTOBORDER"),
  s_PAINT_RESET("PAINT_RESET"),

  // GRAVITY constants
  s_GRAVITY_NORTHWEST("GRAVITY_NORTHWEST"),
  s_GRAVITY_NORTH("GRAVITY_NORTH"),
  s_GRAVITY_NORTHEAST("GRAVITY_NORTHEAST"),
  s_GRAVITY_WEST("GRAVITY_WEST"),
  s_GRAVITY_CENTER("GRAVITY_CENTER"),
  s_GRAVITY_EAST("GRAVITY_EAST"),
  s_GRAVITY_SOUTHWEST("GRAVITY_SOUTHWEST"),
  s_GRAVITY_SOUTH("GRAVITY_SOUTH"),
  s_GRAVITY_SOUTHEAST("GRAVITY_SOUTHEAST"),

  // STRETCH constants
  s_STRETCH_NORMAL("STRETCH_NORMAL"),
  s_STRETCH_ULTRACONDENSED("STRETCH_ULTRACONDENSED"),
  s_STRETCH_CONDENSED("STRETCH_CONDENSED"),
  s_STRETCH_SEMICONDENSED("STRETCH_SEMICONDENSED"),
  s_STRETCH_SEMIEXPANDED("STRETCH_SEMIEXPANDED"),
  s_STRETCH_EXPANDED("STRETCH_EXPANDED"),
  s_STRETCH_EXTRAEXPANDED("STRETCH_EXTRAEXPANDED"),
  s_STRETCH_ULTRAEXPANDED("STRETCH_ULTRAEXPANDED"),
  s_STRETCH_ANY("STRETCH_ANY"),

  // ALIGN constants
  s_ALIGN_UNDEFINED("ALIGN_UNDEFINED"),
  s_ALIGN_LEFT("ALIGN_LEFT"),
  s_ALIGN_CENTER("ALIGN_CENTER"),
  s_ALIGN_RIGHT("ALIGN_RIGHT"),

  // DECORATION constants
  s_DECORATION_NO("DECORATION_NO"),
  s_DECORATION_UNDERLINE("DECORATION_UNDERLINE"),
  s_DECORATION_OVERLINE("DECORATION_OVERLINE"),
  s_DECORATION_LINETROUGH("DECORATION_LINETROUGH"),

  // NOISE constants
  s_NOISE_UNIFORM("NOISE_UNIFORM"),
  s_NOISE_GAUSSIAN("NOISE_GAUSSIAN"),
  s_NOISE_MULTIPLICATIVEGAUSSIAN("NOISE_MULTIPLICATIVEGAUSSIAN"),
  s_NOISE_IMPULSE("NOISE_IMPULSE"),
  s_NOISE_LAPLACIAN("NOISE_LAPLACIAN"),
  s_NOISE_POISSON("NOISE_POISSON"),
  s_NOISE_RANDOM("NOISE_RANDOM"),

  // CHANNEL constants
  s_CHANNEL_UNDEFINED("CHANNEL_UNDEFINED"),
  s_CHANNEL_RED("CHANNEL_RED"),
  s_CHANNEL_GRAY("CHANNEL_GRAY"),
  s_CHANNEL_CYAN("CHANNEL_CYAN"),
  s_CHANNEL_GREEN("CHANNEL_GREEN"),
  s_CHANNEL_MAGENTA("CHANNEL_MAGENTA"),
  s_CHANNEL_BLUE("CHANNEL_BLUE"),
  s_CHANNEL_YELLOW("CHANNEL_YELLOW"),
  s_CHANNEL_ALPHA("CHANNEL_ALPHA"),
  s_CHANNEL_OPACITY("CHANNEL_OPACITY"),
  s_CHANNEL_MATTE("CHANNEL_MATTE"),
  s_CHANNEL_BLACK("CHANNEL_BLACK"),
  s_CHANNEL_INDEX("CHANNEL_INDEX"),
  s_CHANNEL_ALL("CHANNEL_ALL"),
  s_CHANNEL_DEFAULT("CHANNEL_DEFAULT"),
  s_CHANNEL_TRUEALPHA("CHANNEL_TRUEALPHA"),
  s_CHANNEL_RGBS("CHANNEL_RGBS"),
  s_CHANNEL_SYNC("CHANNEL_SYNC"),
#if MagickLibVersion >= 0x670
  s_CHANNEL_COMPOSITES("CHANNEL_COMPOSITES"),
#endif

  // METRIC constants
  s_METRIC_UNDEFINED("METRIC_UNDEFINED"),
  s_METRIC_MEANABSOLUTEERROR("METRIC_MEANABSOLUTEERROR"),
  s_METRIC_MEANSQUAREERROR("METRIC_MEANSQUAREERROR"),
  s_METRIC_PEAKABSOLUTEERROR("METRIC_PEAKABSOLUTEERROR"),
  s_METRIC_PEAKSIGNALTONOISERATIO("METRIC_PEAKSIGNALTONOISERATIO"),
  s_METRIC_ROOTMEANSQUAREDERROR("METRIC_ROOTMEANSQUAREDERROR"),

  // PIXEL constants
  s_PIXEL_CHAR("PIXEL_CHAR"),
  s_PIXEL_DOUBLE("PIXEL_DOUBLE"),
  s_PIXEL_FLOAT("PIXEL_FLOAT"),
  s_PIXEL_INTEGER("PIXEL_INTEGER"),
  s_PIXEL_LONG("PIXEL_LONG"),
  s_PIXEL_QUANTUM("PIXEL_QUANTUM"),
  s_PIXEL_SHORT("PIXEL_SHORT"),

  // EVALUATE constants
  s_EVALUATE_UNDEFINED("EVALUATE_UNDEFINED"),
  s_EVALUATE_ADD("EVALUATE_ADD"),
  s_EVALUATE_AND("EVALUATE_AND"),
  s_EVALUATE_DIVIDE("EVALUATE_DIVIDE"),
  s_EVALUATE_LEFTSHIFT("EVALUATE_LEFTSHIFT"),
  s_EVALUATE_MAX("EVALUATE_MAX"),
  s_EVALUATE_MIN("EVALUATE_MIN"),
  s_EVALUATE_MULTIPLY("EVALUATE_MULTIPLY"),
  s_EVALUATE_OR("EVALUATE_OR"),
  s_EVALUATE_RIGHTSHIFT("EVALUATE_RIGHTSHIFT"),
  s_EVALUATE_SET("EVALUATE_SET"),
  s_EVALUATE_SUBTRACT("EVALUATE_SUBTRACT"),
  s_EVALUATE_XOR("EVALUATE_XOR"),
  s_EVALUATE_POW("EVALUATE_POW"),
  s_EVALUATE_LOG("EVALUATE_LOG"),
  s_EVALUATE_THRESHOLD("EVALUATE_THRESHOLD"),
  s_EVALUATE_THRESHOLDBLACK("EVALUATE_THRESHOLDBLACK"),
  s_EVALUATE_THRESHOLDWHITE("EVALUATE_THRESHOLDWHITE"),
  s_EVALUATE_GAUSSIANNOISE("EVALUATE_GAUSSIANNOISE"),
  s_EVALUATE_IMPULSENOISE("EVALUATE_IMPULSENOISE"),
  s_EVALUATE_LAPLACIANNOISE("EVALUATE_LAPLACIANNOISE"),
  s_EVALUATE_MULTIPLICATIVENOISE("EVALUATE_MULTIPLICATIVENOISE"),
  s_EVALUATE_POISSONNOISE("EVALUATE_POISSONNOISE"),
  s_EVALUATE_UNIFORMNOISE("EVALUATE_UNIFORMNOISE"),
  s_EVALUATE_COSINE("EVALUATE_COSINE"),
  s_EVALUATE_SINE("EVALUATE_SINE"),
  s_EVALUATE_ADDMODULUS("EVALUATE_ADDMODULUS"),
  s_EVALUATE_MEAN("EVALUATE_MEAN"),
  s_EVALUATE_ABS("EVALUATE_ABS"),
  s_EVALUATE_EXPONENTIAL("EVALUATE_EXPONENTIAL"),
  s_EVALUATE_MEDIAN("EVALUATE_MEDIAN"),
#if MagickLibVersion >= 0x676
  s_EVALUATE_SUM("EVALUATE_SUM"),
#endif

  // COLORSPACE constants
  s_COLORSPACE_UNDEFINED("COLORSPACE_UNDEFINED"),
  s_COLORSPACE_RGB("COLORSPACE_RGB"),
  s_COLORSPACE_GRAY("COLORSPACE_GRAY"),
  s_COLORSPACE_TRANSPARENT("COLORSPACE_TRANSPARENT"),
  s_COLORSPACE_OHTA("COLORSPACE_OHTA"),
  s_COLORSPACE_LAB("COLORSPACE_LAB"),
  s_COLORSPACE_XYZ("COLORSPACE_XYZ"),
  s_COLORSPACE_YCBCR("COLORSPACE_YCBCR"),
  s_COLORSPACE_YCC("COLORSPACE_YCC"),
  s_COLORSPACE_YIQ("COLORSPACE_YIQ"),
  s_COLORSPACE_YPBPR("COLORSPACE_YPBPR"),
  s_COLORSPACE_YUV("COLORSPACE_YUV"),
  s_COLORSPACE_CMYK("COLORSPACE_CMYK"),
  s_COLORSPACE_SRGB("COLORSPACE_SRGB"),
  s_COLORSPACE_HSB("COLORSPACE_HSB"),
  s_COLORSPACE_HSL("COLORSPACE_HSL"),
  s_COLORSPACE_HWB("COLORSPACE_HWB"),
  s_COLORSPACE_REC601LUMA("COLORSPACE_REC601LUMA"),
  s_COLORSPACE_REC709LUMA("COLORSPACE_REC709LUMA"),
  s_COLORSPACE_LOG("COLORSPACE_LOG"),
  s_COLORSPACE_CMY("COLORSPACE_CMY"),
#if MagickLibVersion >= 0x679
  s_COLORSPACE_LUV("COLORSPACE_LUV"),
  s_COLORSPACE_HCL("COLORSPACE_HCL"),
#endif
#if MagickLibVersion >= 0x680
  s_COLORSPACE_LCH("COLORSPACE_LCH"),
  s_COLORSPACE_LMS("COLORSPACE_LMS"),
#endif
#if MagickLibVersion >= 0x686
  s_COLORSPACE_LCHAB("COLORSPACE_LCHAB"),
  s_COLORSPACE_LCHUV("COLORSPACE_LCHUV"),
  s_COLORSPACE_SCRGB("COLORSPACE_SCRGB"),
  s_COLORSPACE_HSI("COLORSPACE_HSI"),
  s_COLORSPACE_HSV("COLORSPACE_HSV"),
  s_COLORSPACE_HCLP("COLORSPACE_HCLP"),
  s_COLORSPACE_YDBDR("COLORSPACE_YDBDR"),
#endif

  // VIRTUALPIXELMETHOD constants
  s_VIRTUALPIXELMETHOD_UNDEFINED("VIRTUALPIXELMETHOD_UNDEFINED"),
  s_VIRTUALPIXELMETHOD_BACKGROUND("VIRTUALPIXELMETHOD_BACKGROUND"),
  s_VIRTUALPIXELMETHOD_CONSTANT("VIRTUALPIXELMETHOD_CONSTANT"),
  s_VIRTUALPIXELMETHOD_EDGE("VIRTUALPIXELMETHOD_EDGE"),
  s_VIRTUALPIXELMETHOD_MIRROR("VIRTUALPIXELMETHOD_MIRROR"),
  s_VIRTUALPIXELMETHOD_TILE("VIRTUALPIXELMETHOD_TILE"),
  s_VIRTUALPIXELMETHOD_TRANSPARENT("VIRTUALPIXELMETHOD_TRANSPARENT"),
  s_VIRTUALPIXELMETHOD_MASK("VIRTUALPIXELMETHOD_MASK"),
  s_VIRTUALPIXELMETHOD_BLACK("VIRTUALPIXELMETHOD_BLACK"),
  s_VIRTUALPIXELMETHOD_GRAY("VIRTUALPIXELMETHOD_GRAY"),
  s_VIRTUALPIXELMETHOD_WHITE("VIRTUALPIXELMETHOD_WHITE"),
  s_VIRTUALPIXELMETHOD_HORIZONTALTILE("VIRTUALPIXELMETHOD_HORIZONTALTILE"),
  s_VIRTUALPIXELMETHOD_VERTICALTILE("VIRTUALPIXELMETHOD_VERTICALTILE"),
  s_VIRTUALPIXELMETHOD_HORIZONTALTILEEDGE(
    "VIRTUALPIXELMETHOD_HORIZONTALTILEEDGE"),
  s_VIRTUALPIXELMETHOD_VERTICALTILEEDGE("VIRTUALPIXELMETHOD_VERTICALTILEEDGE"),
  s_VIRTUALPIXELMETHOD_CHECKERTILE("VIRTUALPIXELMETHOD_CHECKERTILE"),

  // PREVIEW constants
  s_PREVIEW_UNDEFINED("PREVIEW_UNDEFINED"),
  s_PREVIEW_ROTATE("PREVIEW_ROTATE"),
  s_PREVIEW_SHEAR("PREVIEW_SHEAR"),
  s_PREVIEW_ROLL("PREVIEW_ROLL"),
  s_PREVIEW_HUE("PREVIEW_HUE"),
  s_PREVIEW_SATURATION("PREVIEW_SATURATION"),
  s_PREVIEW_BRIGHTNESS("PREVIEW_BRIGHTNESS"),
  s_PREVIEW_GAMMA("PREVIEW_GAMMA"),
  s_PREVIEW_SPIFF("PREVIEW_SPIFF"),
  s_PREVIEW_DULL("PREVIEW_DULL"),
  s_PREVIEW_GRAYSCALE("PREVIEW_GRAYSCALE"),
  s_PREVIEW_QUANTIZE("PREVIEW_QUANTIZE"),
  s_PREVIEW_DESPECKLE("PREVIEW_DESPECKLE"),
  s_PREVIEW_REDUCENOISE("PREVIEW_REDUCENOISE"),
  s_PREVIEW_ADDNOISE("PREVIEW_ADDNOISE"),
  s_PREVIEW_SHARPEN("PREVIEW_SHARPEN"),
  s_PREVIEW_BLUR("PREVIEW_BLUR"),
  s_PREVIEW_THRESHOLD("PREVIEW_THRESHOLD"),
  s_PREVIEW_EDGEDETECT("PREVIEW_EDGEDETECT"),
  s_PREVIEW_SPREAD("PREVIEW_SPREAD"),
  s_PREVIEW_SOLARIZE("PREVIEW_SOLARIZE"),
  s_PREVIEW_SHADE("PREVIEW_SHADE"),
  s_PREVIEW_RAISE("PREVIEW_RAISE"),
  s_PREVIEW_SEGMENT("PREVIEW_SEGMENT"),
  s_PREVIEW_SWIRL("PREVIEW_SWIRL"),
  s_PREVIEW_IMPLODE("PREVIEW_IMPLODE"),
  s_PREVIEW_WAVE("PREVIEW_WAVE"),
  s_PREVIEW_OILPAINT("PREVIEW_OILPAINT"),
  s_PREVIEW_CHARCOALDRAWING("PREVIEW_CHARCOALDRAWING"),
  s_PREVIEW_JPEG("PREVIEW_JPEG"),

  // RENDERINGINTENT constants
  s_RENDERINGINTENT_UNDEFINED("RENDERINGINTENT_UNDEFINED"),
  s_RENDERINGINTENT_SATURATION("RENDERINGINTENT_SATURATION"),
  s_RENDERINGINTENT_PERCEPTUAL("RENDERINGINTENT_PERCEPTUAL"),
  s_RENDERINGINTENT_ABSOLUTE("RENDERINGINTENT_ABSOLUTE"),
  s_RENDERINGINTENT_RELATIVE("RENDERINGINTENT_RELATIVE"),

  // INTERLACE constants
  s_INTERLACE_UNDEFINED("INTERLACE_UNDEFINED"),
  s_INTERLACE_NO("INTERLACE_NO"),
  s_INTERLACE_LINE("INTERLACE_LINE"),
  s_INTERLACE_PLANE("INTERLACE_PLANE"),
  s_INTERLACE_PARTITION("INTERLACE_PARTITION"),
  s_INTERLACE_GIF("INTERLACE_GIF"),
  s_INTERLACE_JPEG("INTERLACE_JPEG"),
  s_INTERLACE_PNG("INTERLACE_PNG"),

  // FILLRULE constants
  s_FILLRULE_UNDEFINED("FILLRULE_UNDEFINED"),
  s_FILLRULE_EVENODD("FILLRULE_EVENODD"),
  s_FILLRULE_NONZERO("FILLRULE_NONZERO"),

  // PATHUNITS constants
  s_PATHUNITS_UNDEFINED("PATHUNITS_UNDEFINED"),
  s_PATHUNITS_USERSPACE("PATHUNITS_USERSPACE"),
  s_PATHUNITS_USERSPACEONUSE("PATHUNITS_USERSPACEONUSE"),
  s_PATHUNITS_OBJECTBOUNDINGBOX("PATHUNITS_OBJECTBOUNDINGBOX"),

  // LINECAP constants
  s_LINECAP_UNDEFINED("LINECAP_UNDEFINED"),
  s_LINECAP_BUTT("LINECAP_BUTT"),
  s_LINECAP_ROUND("LINECAP_ROUND"),
  s_LINECAP_SQUARE("LINECAP_SQUARE"),

  // LINEJOIN constants
  s_LINEJOIN_UNDEFINED("LINEJOIN_UNDEFINED"),
  s_LINEJOIN_MITER("LINEJOIN_MITER"),
  s_LINEJOIN_ROUND("LINEJOIN_ROUND"),
  s_LINEJOIN_BEVEL("LINEJOIN_BEVEL"),

  // RESOURCETYPE constants
  s_RESOURCETYPE_UNDEFINED("RESOURCETYPE_UNDEFINED"),
  s_RESOURCETYPE_AREA("RESOURCETYPE_AREA"),
  s_RESOURCETYPE_DISK("RESOURCETYPE_DISK"),
  s_RESOURCETYPE_FILE("RESOURCETYPE_FILE"),
  s_RESOURCETYPE_MAP("RESOURCETYPE_MAP"),
  s_RESOURCETYPE_MEMORY("RESOURCETYPE_MEMORY"),
#if MagickLibVersion > 0x678
  s_RESOURCETYPE_THREAD("RESOURCETYPE_THREAD"),
#endif

  // LAYERMETHOD constants
  s_LAYERMETHOD_UNDEFINED("LAYERMETHOD_UNDEFINED"),
  s_LAYERMETHOD_COALESCE("LAYERMETHOD_COALESCE"),
  s_LAYERMETHOD_COMPAREANY("LAYERMETHOD_COMPAREANY"),
  s_LAYERMETHOD_COMPARECLEAR("LAYERMETHOD_COMPARECLEAR"),
  s_LAYERMETHOD_COMPAREOVERLAY("LAYERMETHOD_COMPAREOVERLAY"),
  s_LAYERMETHOD_DISPOSE("LAYERMETHOD_DISPOSE"),
  s_LAYERMETHOD_OPTIMIZE("LAYERMETHOD_OPTIMIZE"),
  s_LAYERMETHOD_OPTIMIZEPLUS("LAYERMETHOD_OPTIMIZEPLUS"),
  s_LAYERMETHOD_OPTIMIZETRANS("LAYERMETHOD_OPTIMIZETRANS"),
  s_LAYERMETHOD_COMPOSITE("LAYERMETHOD_COMPOSITE"),
  s_LAYERMETHOD_OPTIMIZEIMAGE("LAYERMETHOD_OPTIMIZEIMAGE"),
  s_LAYERMETHOD_REMOVEDUPS("LAYERMETHOD_REMOVEDUPS"),
  s_LAYERMETHOD_REMOVEZERO("LAYERMETHOD_REMOVEZERO"),
  s_LAYERMETHOD_MERGE("LAYERMETHOD_MERGE"),
  s_LAYERMETHOD_FLATTEN("LAYERMETHOD_FLATTEN"),
  s_LAYERMETHOD_MOSAIC("LAYERMETHOD_MOSAIC"),
  s_LAYERMETHOD_TRIMBOUNDS("LAYERMETHOD_TRIMBOUNDS"),

  // ORIENTATION constants
  s_ORIENTATION_UNDEFINED("ORIENTATION_UNDEFINED"),
  s_ORIENTATION_TOPLEFT("ORIENTATION_TOPLEFT"),
  s_ORIENTATION_TOPRIGHT("ORIENTATION_TOPRIGHT"),
  s_ORIENTATION_BOTTOMRIGHT("ORIENTATION_BOTTOMRIGHT"),
  s_ORIENTATION_BOTTOMLEFT("ORIENTATION_BOTTOMLEFT"),
  s_ORIENTATION_LEFTTOP("ORIENTATION_LEFTTOP"),
  s_ORIENTATION_RIGHTTOP("ORIENTATION_RIGHTTOP"),
  s_ORIENTATION_RIGHTBOTTOM("ORIENTATION_RIGHTBOTTOM"),
  s_ORIENTATION_LEFTBOTTOM("ORIENTATION_LEFTBOTTOM"),

  // DISTORTION constants
  s_DISTORTION_UNDEFINED("DISTORTION_UNDEFINED"),
  s_DISTORTION_AFFINE("DISTORTION_AFFINE"),
  s_DISTORTION_AFFINEPROJECTION("DISTORTION_AFFINEPROJECTION"),
  s_DISTORTION_ARC("DISTORTION_ARC"),
  s_DISTORTION_BILINEAR("DISTORTION_BILINEAR"),
  s_DISTORTION_PERSPECTIVE("DISTORTION_PERSPECTIVE"),
  s_DISTORTION_PERSPECTIVEPROJECTION("DISTORTION_PERSPECTIVEPROJECTION"),
  s_DISTORTION_SCALEROTATETRANSLATE("DISTORTION_SCALEROTATETRANSLATE"),
  s_DISTORTION_POLYNOMIAL("DISTORTION_POLYNOMIAL"),
  s_DISTORTION_POLAR("DISTORTION_POLAR"),
  s_DISTORTION_DEPOLAR("DISTORTION_DEPOLAR"),
  s_DISTORTION_BARREL("DISTORTION_BARREL"),
  s_DISTORTION_BARRELINVERSE("DISTORTION_BARRELINVERSE"),
  s_DISTORTION_SHEPARDS("DISTORTION_SHEPARDS"),
  s_DISTORTION_SENTINEL("DISTORTION_SENTINEL"),
  s_DISTORTION_BILINEARFORWARD("DISTORTION_BILINEARFORWARD"),
  s_DISTORTION_BILINEARREVERSE("DISTORTION_BILINEARREVERSE"),
#if MagickLibVersion >= 0x670
  s_DISTORTION_RESIZE("DISTORTION_RESIZE"),
#endif
#if MagickLibVersion >= 0x671
  s_DISTORTION_CYLINDER2PLANE("DISTORTION_CYLINDER2PLANE"),
  s_DISTORTION_PLANE2CYLINDER("DISTORTION_PLANE2CYLINDER"),
#endif

  // ALPHACHANNEL constants
  s_ALPHACHANNEL_ACTIVATE("ALPHACHANNEL_ACTIVATE"),
  s_ALPHACHANNEL_DEACTIVATE("ALPHACHANNEL_DEACTIVATE"),
  s_ALPHACHANNEL_RESET("ALPHACHANNEL_RESET"),
  s_ALPHACHANNEL_SET("ALPHACHANNEL_SET"),
  s_ALPHACHANNEL_UNDEFINED("ALPHACHANNEL_UNDEFINED"),
  s_ALPHACHANNEL_COPY("ALPHACHANNEL_COPY"),
  s_ALPHACHANNEL_EXTRACT("ALPHACHANNEL_EXTRACT"),
  s_ALPHACHANNEL_OPAQUE("ALPHACHANNEL_OPAQUE"),
  s_ALPHACHANNEL_SHAPE("ALPHACHANNEL_SHAPE"),
  s_ALPHACHANNEL_TRANSPARENT("ALPHACHANNEL_TRANSPARENT"),
#if MagickLibVersion >= 0x680
  s_ALPHACHANNEL_FLATTEN("ALPHACHANNEL_FLATTEN"),
  s_ALPHACHANNEL_REMOVE("ALPHACHANNEL_REMOVE"),
#endif

  // SPARSECOLORMETHOD constants
  s_SPARSECOLORMETHOD_UNDEFINED("SPARSECOLORMETHOD_UNDEFINED"),
  s_SPARSECOLORMETHOD_BARYCENTRIC("SPARSECOLORMETHOD_BARYCENTRIC"),
  s_SPARSECOLORMETHOD_BILINEAR("SPARSECOLORMETHOD_BILINEAR"),
  s_SPARSECOLORMETHOD_POLYNOMIAL("SPARSECOLORMETHOD_POLYNOMIAL"),
  s_SPARSECOLORMETHOD_SPEPARDS("SPARSECOLORMETHOD_SPEPARDS"),
  s_SPARSECOLORMETHOD_VORONOI("SPARSECOLORMETHOD_VORONOI"),

  // FUNCTION constants
  s_FUNCTION_UNDEFINED("FUNCTION_UNDEFINED"),
  s_FUNCTION_POLYNOMIAL("FUNCTION_POLYNOMIAL"),
  s_FUNCTION_SINUSOID("FUNCTION_SINUSOID"),
  s_FUNCTION_ARCSIN("FUNCTION_ARCSIN"),
  s_FUNCTION_ARCTAN("FUNCTION_ARCTAN"),

  // INTERPOLATE constants
  s_INTERPOLATE_UNDEFINED("INTERPOLATE_UNDEFINED"),
  s_INTERPOLATE_AVERAGE("INTERPOLATE_AVERAGE"),
  s_INTERPOLATE_BICUBIC("INTERPOLATE_BICUBIC"),
  s_INTERPOLATE_BILINEAR("INTERPOLATE_BILINEAR"),
  s_INTERPOLATE_FILTER("INTERPOLATE_FILTER"),
  s_INTERPOLATE_INTEGER("INTERPOLATE_INTEGER"),
  s_INTERPOLATE_MESH("INTERPOLATE_MESH"),
  s_INTERPOLATE_NEARESTNEIGHBOR("INTERPOLATE_NEARESTNEIGHBOR"),
  s_INTERPOLATE_SPLINE("INTERPOLATE_SPLINE"),

  // DITHERMETHOD constants
  s_DITHERMETHOD_UNDEFINED("DITHERMETHOD_UNDEFINED"),
  s_DITHERMETHOD_NO("DITHERMETHOD_NO"),
  s_DITHERMETHOD_RIEMERSMA("DITHERMETHOD_RIEMERSMA"),
  s_DITHERMETHOD_FLOYDSTEINBERG("DITHERMETHOD_FLOYDSTEINBERG");


void loadImagickConstants() {
  // COLOR_* constants
  // Colortype constants. These constants are mainly used with ImagickPixel.
  registerImagickConstants(s_COLOR_BLACK, IMAGICK_COLOR_BLACK);
  registerImagickConstants(s_COLOR_BLUE, IMAGICK_COLOR_BLUE);
  registerImagickConstants(s_COLOR_CYAN, IMAGICK_COLOR_CYAN);
  registerImagickConstants(s_COLOR_GREEN, IMAGICK_COLOR_GREEN);
  registerImagickConstants(s_COLOR_RED, IMAGICK_COLOR_RED);
  registerImagickConstants(s_COLOR_YELLOW, IMAGICK_COLOR_YELLOW);
  registerImagickConstants(s_COLOR_MAGENTA, IMAGICK_COLOR_MAGENTA);
  registerImagickConstants(s_COLOR_OPACITY, IMAGICK_COLOR_OPACITY);
  registerImagickConstants(s_COLOR_ALPHA, IMAGICK_COLOR_ALPHA);
  registerImagickConstants(s_COLOR_FUZZ, IMAGICK_COLOR_FUZZ);

  // DISPOSE constants
  // Dispose type constants
  registerImagickConstants(s_DISPOSE_UNRECOGNIZED, UnrecognizedDispose);
  registerImagickConstants(s_DISPOSE_UNDEFINED, UndefinedDispose);
  registerImagickConstants(s_DISPOSE_NONE, NoneDispose);
  registerImagickConstants(s_DISPOSE_BACKGROUND, BackgroundDispose);
  registerImagickConstants(s_DISPOSE_PREVIOUS, PreviousDispose);

  // Composite Operator Constants
  registerImagickConstants(s_COMPOSITE_DEFAULT, OverCompositeOp);
  registerImagickConstants(s_COMPOSITE_UNDEFINED, UndefinedCompositeOp);
  registerImagickConstants(s_COMPOSITE_NO, NoCompositeOp);
  registerImagickConstants(s_COMPOSITE_ADD, AddCompositeOp);
  registerImagickConstants(s_COMPOSITE_ATOP, AtopCompositeOp);
  registerImagickConstants(s_COMPOSITE_BLEND, BlendCompositeOp);
  registerImagickConstants(s_COMPOSITE_BUMPMAP, BumpmapCompositeOp);
  registerImagickConstants(s_COMPOSITE_CLEAR, ClearCompositeOp);
  registerImagickConstants(s_COMPOSITE_COLORBURN, ColorBurnCompositeOp);
  registerImagickConstants(s_COMPOSITE_COLORDODGE, ColorDodgeCompositeOp);
  registerImagickConstants(s_COMPOSITE_COLORIZE, ColorizeCompositeOp);
  registerImagickConstants(s_COMPOSITE_COPYBLACK, CopyBlackCompositeOp);
  registerImagickConstants(s_COMPOSITE_COPYBLUE, CopyBlueCompositeOp);
  registerImagickConstants(s_COMPOSITE_COPY, CopyCompositeOp);
  registerImagickConstants(s_COMPOSITE_COPYCYAN, CopyCyanCompositeOp);
  registerImagickConstants(s_COMPOSITE_COPYGREEN, CopyGreenCompositeOp);
  registerImagickConstants(s_COMPOSITE_COPYMAGENTA, CopyMagentaCompositeOp);
  registerImagickConstants(s_COMPOSITE_COPYOPACITY, CopyOpacityCompositeOp);
  registerImagickConstants(s_COMPOSITE_COPYRED, CopyRedCompositeOp);
  registerImagickConstants(s_COMPOSITE_COPYYELLOW, CopyYellowCompositeOp);
  registerImagickConstants(s_COMPOSITE_DARKEN, DarkenCompositeOp);
  registerImagickConstants(s_COMPOSITE_DSTATOP, DstAtopCompositeOp);
  registerImagickConstants(s_COMPOSITE_DST, DstCompositeOp);
  registerImagickConstants(s_COMPOSITE_DSTIN, DstInCompositeOp);
  registerImagickConstants(s_COMPOSITE_DSTOUT, DstOutCompositeOp);
  registerImagickConstants(s_COMPOSITE_DSTOVER, DstOverCompositeOp);
  registerImagickConstants(s_COMPOSITE_DIFFERENCE, DifferenceCompositeOp);
  registerImagickConstants(s_COMPOSITE_DISPLACE, DisplaceCompositeOp);
  registerImagickConstants(s_COMPOSITE_DISSOLVE, DissolveCompositeOp);
  registerImagickConstants(s_COMPOSITE_EXCLUSION, ExclusionCompositeOp);
  registerImagickConstants(s_COMPOSITE_HARDLIGHT, HardLightCompositeOp);
  registerImagickConstants(s_COMPOSITE_HUE, HueCompositeOp);
  registerImagickConstants(s_COMPOSITE_IN, InCompositeOp);
  registerImagickConstants(s_COMPOSITE_LIGHTEN, LightenCompositeOp);
  registerImagickConstants(s_COMPOSITE_LUMINIZE, LuminizeCompositeOp);
  registerImagickConstants(s_COMPOSITE_MINUS, MinusCompositeOp);
  registerImagickConstants(s_COMPOSITE_MODULATE, ModulateCompositeOp);
  registerImagickConstants(s_COMPOSITE_MULTIPLY, MultiplyCompositeOp);
  registerImagickConstants(s_COMPOSITE_OUT, OutCompositeOp);
  registerImagickConstants(s_COMPOSITE_OVER, OverCompositeOp);
  registerImagickConstants(s_COMPOSITE_OVERLAY, OverlayCompositeOp);
  registerImagickConstants(s_COMPOSITE_PLUS, PlusCompositeOp);
  registerImagickConstants(s_COMPOSITE_REPLACE, ReplaceCompositeOp);
  registerImagickConstants(s_COMPOSITE_SATURATE, SaturateCompositeOp);
  registerImagickConstants(s_COMPOSITE_SCREEN, ScreenCompositeOp);
  registerImagickConstants(s_COMPOSITE_SOFTLIGHT, SoftLightCompositeOp);
  registerImagickConstants(s_COMPOSITE_SRCATOP, SrcAtopCompositeOp);
  registerImagickConstants(s_COMPOSITE_SRC, SrcCompositeOp);
  registerImagickConstants(s_COMPOSITE_SRCIN, SrcInCompositeOp);
  registerImagickConstants(s_COMPOSITE_SRCOUT, SrcOutCompositeOp);
  registerImagickConstants(s_COMPOSITE_SRCOVER, SrcOverCompositeOp);
  registerImagickConstants(s_COMPOSITE_SUBTRACT, SubtractCompositeOp);
  registerImagickConstants(s_COMPOSITE_THRESHOLD, ThresholdCompositeOp);
  registerImagickConstants(s_COMPOSITE_XOR, XorCompositeOp);
  registerImagickConstants(s_COMPOSITE_CHANGEMASK, ChangeMaskCompositeOp);
  registerImagickConstants(s_COMPOSITE_LINEARLIGHT, LinearLightCompositeOp);
  registerImagickConstants(s_COMPOSITE_DIVIDE, DivideCompositeOp);
  registerImagickConstants(s_COMPOSITE_DISTORT, DistortCompositeOp);
  registerImagickConstants(s_COMPOSITE_BLUR, BlurCompositeOp);
  registerImagickConstants(s_COMPOSITE_PEGTOPLIGHT, PegtopLightCompositeOp);
  registerImagickConstants(s_COMPOSITE_VIVIDLIGHT, VividLightCompositeOp);
  registerImagickConstants(s_COMPOSITE_PINLIGHT, PinLightCompositeOp);
  registerImagickConstants(s_COMPOSITE_LINEARDODGE, LinearDodgeCompositeOp);
  registerImagickConstants(s_COMPOSITE_LINEARBURN, LinearBurnCompositeOp);
  registerImagickConstants(s_COMPOSITE_MATHEMATICS, MathematicsCompositeOp);
  registerImagickConstants(s_COMPOSITE_MODULUSADD, ModulusAddCompositeOp);
  registerImagickConstants(s_COMPOSITE_MODULUSSUBTRACT,
                           ModulusSubtractCompositeOp);
#if MagickLibVersion >= 0x670
  registerImagickConstants(s_COMPOSITE_MINUSDST, MinusDstCompositeOp);
  registerImagickConstants(s_COMPOSITE_DIVIDEDST, DivideDstCompositeOp);
  registerImagickConstants(s_COMPOSITE_DIVIDESRC, DivideSrcCompositeOp);
  registerImagickConstants(s_COMPOSITE_MINUSSRC, MinusSrcCompositeOp);
  registerImagickConstants(s_COMPOSITE_DARKENINTENSITY,
                           DarkenIntensityCompositeOp);
  registerImagickConstants(s_COMPOSITE_LIGHTENINTENSITY,
                           LightenIntensityCompositeOp);
#endif

  // MONTAGEMODE constants
  registerImagickConstants(s_MONTAGEMODE_FRAME, FrameMode);
  registerImagickConstants(s_MONTAGEMODE_UNFRAME, UnframeMode);
  registerImagickConstants(s_MONTAGEMODE_CONCATENATE, ConcatenateMode);

  // STYLE constants
  registerImagickConstants(s_STYLE_NORMAL, NormalStyle);
  registerImagickConstants(s_STYLE_ITALIC, ItalicStyle);
  registerImagickConstants(s_STYLE_OBLIQUE, ObliqueStyle);
  registerImagickConstants(s_STYLE_ANY, AnyStyle);

  // FILTER constants
  registerImagickConstants(s_FILTER_UNDEFINED, UndefinedFilter);
  registerImagickConstants(s_FILTER_POINT, PointFilter);
  registerImagickConstants(s_FILTER_BOX, BoxFilter);
  registerImagickConstants(s_FILTER_TRIANGLE, TriangleFilter);
  registerImagickConstants(s_FILTER_HERMITE, HermiteFilter);
  registerImagickConstants(s_FILTER_HANNING, HanningFilter);
  registerImagickConstants(s_FILTER_HAMMING, HammingFilter);
  registerImagickConstants(s_FILTER_BLACKMAN, BlackmanFilter);
  registerImagickConstants(s_FILTER_GAUSSIAN, GaussianFilter);
  registerImagickConstants(s_FILTER_QUADRATIC, QuadraticFilter);
  registerImagickConstants(s_FILTER_CUBIC, CubicFilter);
  registerImagickConstants(s_FILTER_CATROM, CatromFilter);
  registerImagickConstants(s_FILTER_MITCHELL, MitchellFilter);
  registerImagickConstants(s_FILTER_LANCZOS, LanczosFilter);
  registerImagickConstants(s_FILTER_BESSEL, BesselFilter);
  registerImagickConstants(s_FILTER_SINC, SincFilter);
  registerImagickConstants(s_FILTER_KAISER, KaiserFilter);
  registerImagickConstants(s_FILTER_WELSH, WelshFilter);
  registerImagickConstants(s_FILTER_PARZEN, ParzenFilter);
  registerImagickConstants(s_FILTER_LAGRANGE, LagrangeFilter);
  registerImagickConstants(s_FILTER_SENTINEL, SentinelFilter);
  registerImagickConstants(s_FILTER_BOHMAN, BohmanFilter);
  registerImagickConstants(s_FILTER_BARTLETT, BartlettFilter);
  registerImagickConstants(s_FILTER_JINC, JincFilter);
  registerImagickConstants(s_FILTER_SINCFAST, SincFastFilter);
  registerImagickConstants(s_FILTER_ROBIDOUX, RobidouxFilter);
  registerImagickConstants(s_FILTER_LANCZOSSHARP, LanczosSharpFilter);
  registerImagickConstants(s_FILTER_LANCZOS2, Lanczos2Filter);
  registerImagickConstants(s_FILTER_LANCZOS2SHARP, Lanczos2SharpFilter);
#if MagickLibVersion >= 0x677
  registerImagickConstants(s_FILTER_ROBIDOUXSHARP, RobidouxSharpFilter);
  registerImagickConstants(s_FILTER_COSINE, CosineFilter);
#endif
#if MagickLibVersion >= 0x678
  registerImagickConstants(s_FILTER_SPLINE, SplineFilter);
#endif
#if MagickLibVersion >= 0x681
  registerImagickConstants(s_FILTER_LANCZOSRADIUS, LanczosRadiusFilter);
#endif

  // IMGTYPE constants
  registerImagickConstants(s_IMGTYPE_UNDEFINED, UndefinedType);
  registerImagickConstants(s_IMGTYPE_BILEVEL, BilevelType);
  registerImagickConstants(s_IMGTYPE_GRAYSCALE, GrayscaleType);
  registerImagickConstants(s_IMGTYPE_GRAYSCALEMATTE, GrayscaleMatteType);
  registerImagickConstants(s_IMGTYPE_PALETTEMATTE, PaletteMatteType);
  registerImagickConstants(s_IMGTYPE_TRUECOLOR, TrueColorType);
  registerImagickConstants(s_IMGTYPE_TRUECOLORMATTE, TrueColorMatteType);
  registerImagickConstants(s_IMGTYPE_COLORSEPARATION, ColorSeparationType);
  registerImagickConstants(s_IMGTYPE_COLORSEPARATIONMATTE,
                           ColorSeparationMatteType);
  registerImagickConstants(s_IMGTYPE_OPTIMIZE, OptimizeType);
  registerImagickConstants(s_IMGTYPE_PALETTEBILEVELMATTE,
                           PaletteBilevelMatteType);

  // RESOLUTION constants
  registerImagickConstants(s_RESOLUTION_UNDEFINED, UndefinedResolution);
  registerImagickConstants(s_RESOLUTION_PIXELSPERINCH,
                           PixelsPerInchResolution);
  registerImagickConstants(s_RESOLUTION_PIXELSPERCENTIMETER,
                           PixelsPerCentimeterResolution);

  // COMPRESSION constants
  registerImagickConstants(s_COMPRESSION_UNDEFINED, UndefinedCompression);
  registerImagickConstants(s_COMPRESSION_NO, NoCompression);
  registerImagickConstants(s_COMPRESSION_BZIP, BZipCompression);
  registerImagickConstants(s_COMPRESSION_FAX, FaxCompression);
  registerImagickConstants(s_COMPRESSION_GROUP4, Group4Compression);
  registerImagickConstants(s_COMPRESSION_JPEG, JPEGCompression);
  registerImagickConstants(s_COMPRESSION_JPEG2000, JPEG2000Compression);
  registerImagickConstants(s_COMPRESSION_LOSSLESSJPEG,
                           LosslessJPEGCompression);
  registerImagickConstants(s_COMPRESSION_LZW, LZWCompression);
  registerImagickConstants(s_COMPRESSION_RLE, RLECompression);
  registerImagickConstants(s_COMPRESSION_ZIP, ZipCompression);
  registerImagickConstants(s_COMPRESSION_DXT1, DXT1Compression);
  registerImagickConstants(s_COMPRESSION_DXT3, DXT3Compression);
  registerImagickConstants(s_COMPRESSION_DXT5, DXT5Compression);
  registerImagickConstants(s_COMPRESSION_ZIPS, ZipSCompression);
  registerImagickConstants(s_COMPRESSION_PIZ, PizCompression);
  registerImagickConstants(s_COMPRESSION_PXR24, Pxr24Compression);
  registerImagickConstants(s_COMPRESSION_B44, B44Compression);
  registerImagickConstants(s_COMPRESSION_B44A, B44ACompression);
  registerImagickConstants(s_COMPRESSION_LZMA, LZMACompression);
#if MagickLibVersion >= 0x670
  registerImagickConstants(s_COMPRESSION_JBIG1, JBIG1Compression);
  registerImagickConstants(s_COMPRESSION_JBIG2, JBIG2Compression);
#endif

  // PAINT constants
  registerImagickConstants(s_PAINT_POINT, PointMethod);
  registerImagickConstants(s_PAINT_REPLACE, ReplaceMethod);
  registerImagickConstants(s_PAINT_FLOODFILL, FloodfillMethod);
  registerImagickConstants(s_PAINT_FILLTOBORDER, FillToBorderMethod);
  registerImagickConstants(s_PAINT_RESET, ResetMethod);

  // GRAVITY constants
  registerImagickConstants(s_GRAVITY_NORTHWEST, NorthWestGravity);
  registerImagickConstants(s_GRAVITY_NORTH, NorthGravity);
  registerImagickConstants(s_GRAVITY_NORTHEAST, NorthEastGravity);
  registerImagickConstants(s_GRAVITY_WEST, WestGravity);
  registerImagickConstants(s_GRAVITY_CENTER, CenterGravity);
  registerImagickConstants(s_GRAVITY_EAST, EastGravity);
  registerImagickConstants(s_GRAVITY_SOUTHWEST, SouthWestGravity);
  registerImagickConstants(s_GRAVITY_SOUTH, SouthGravity);
  registerImagickConstants(s_GRAVITY_SOUTHEAST, SouthEastGravity);

  // STRETCH constants
  registerImagickConstants(s_STRETCH_NORMAL, NormalStretch);
  registerImagickConstants(s_STRETCH_ULTRACONDENSED, UltraCondensedStretch);
  registerImagickConstants(s_STRETCH_CONDENSED, CondensedStretch);
  registerImagickConstants(s_STRETCH_SEMICONDENSED, SemiCondensedStretch);
  registerImagickConstants(s_STRETCH_SEMIEXPANDED, SemiExpandedStretch);
  registerImagickConstants(s_STRETCH_EXPANDED, ExpandedStretch);
  registerImagickConstants(s_STRETCH_EXTRAEXPANDED, ExtraExpandedStretch);
  registerImagickConstants(s_STRETCH_ULTRAEXPANDED, UltraExpandedStretch);
  registerImagickConstants(s_STRETCH_ANY, AnyStretch);

  // ALIGN constants
  registerImagickConstants(s_ALIGN_UNDEFINED, UndefinedAlign);
  registerImagickConstants(s_ALIGN_LEFT, LeftAlign);
  registerImagickConstants(s_ALIGN_CENTER, CenterAlign);
  registerImagickConstants(s_ALIGN_RIGHT, RightAlign);

  // DECORATION constants
  registerImagickConstants(s_DECORATION_NO, NoDecoration);
  registerImagickConstants(s_DECORATION_UNDERLINE, UnderlineDecoration);
  registerImagickConstants(s_DECORATION_OVERLINE, OverlineDecoration);
  registerImagickConstants(s_DECORATION_LINETROUGH, LineThroughDecoration);

  // NOISE constants
  registerImagickConstants(s_NOISE_UNIFORM, UniformNoise);
  registerImagickConstants(s_NOISE_GAUSSIAN, GaussianNoise);
  registerImagickConstants(s_NOISE_MULTIPLICATIVEGAUSSIAN,
                           MultiplicativeGaussianNoise);
  registerImagickConstants(s_NOISE_IMPULSE, ImpulseNoise);
  registerImagickConstants(s_NOISE_LAPLACIAN, LaplacianNoise);
  registerImagickConstants(s_NOISE_POISSON, PoissonNoise);
  registerImagickConstants(s_NOISE_RANDOM, RandomNoise);

  // CHANNEL constants
  registerImagickConstants(s_CHANNEL_UNDEFINED, UndefinedChannel);
  registerImagickConstants(s_CHANNEL_RED, RedChannel);
  registerImagickConstants(s_CHANNEL_GRAY, GrayChannel);
  registerImagickConstants(s_CHANNEL_CYAN, CyanChannel);
  registerImagickConstants(s_CHANNEL_GREEN, GreenChannel);
  registerImagickConstants(s_CHANNEL_MAGENTA, MagentaChannel);
  registerImagickConstants(s_CHANNEL_BLUE, BlueChannel);
  registerImagickConstants(s_CHANNEL_YELLOW, YellowChannel);
  registerImagickConstants(s_CHANNEL_ALPHA, AlphaChannel);
  registerImagickConstants(s_CHANNEL_OPACITY, OpacityChannel);
  registerImagickConstants(s_CHANNEL_MATTE, MatteChannel);
  registerImagickConstants(s_CHANNEL_BLACK, BlackChannel);
  registerImagickConstants(s_CHANNEL_INDEX, IndexChannel);
  registerImagickConstants(s_CHANNEL_ALL, AllChannels);
  registerImagickConstants(s_CHANNEL_DEFAULT, DefaultChannels);
  registerImagickConstants(s_CHANNEL_TRUEALPHA, TrueAlphaChannel);
  registerImagickConstants(s_CHANNEL_RGBS, RGBChannels);
  registerImagickConstants(s_CHANNEL_SYNC, SyncChannels);
#if MagickLibVersion >= 0x670
  registerImagickConstants(s_CHANNEL_COMPOSITES, CompositeChannels);
#endif

  // METRIC constants
  registerImagickConstants(s_METRIC_UNDEFINED, UndefinedMetric);
  registerImagickConstants(s_METRIC_MEANABSOLUTEERROR,
                           MeanAbsoluteErrorMetric);
  registerImagickConstants(s_METRIC_MEANSQUAREERROR, MeanSquaredErrorMetric);
  registerImagickConstants(s_METRIC_PEAKABSOLUTEERROR,
                           PeakAbsoluteErrorMetric);
  registerImagickConstants(s_METRIC_PEAKSIGNALTONOISERATIO,
                           PeakSignalToNoiseRatioMetric);
  registerImagickConstants(s_METRIC_ROOTMEANSQUAREDERROR,
                           RootMeanSquaredErrorMetric);

  // PIXEL constants
  registerImagickConstants(s_PIXEL_CHAR, CharPixel);
  registerImagickConstants(s_PIXEL_DOUBLE, DoublePixel);
  registerImagickConstants(s_PIXEL_FLOAT, FloatPixel);
  registerImagickConstants(s_PIXEL_INTEGER, IntegerPixel);
  registerImagickConstants(s_PIXEL_LONG, LongPixel);
  registerImagickConstants(s_PIXEL_QUANTUM, QuantumPixel);
  registerImagickConstants(s_PIXEL_SHORT, ShortPixel);

  // EVALUATE constants
  registerImagickConstants(s_EVALUATE_UNDEFINED, UndefinedEvaluateOperator);
  registerImagickConstants(s_EVALUATE_ADD, AddEvaluateOperator);
  registerImagickConstants(s_EVALUATE_AND, AndEvaluateOperator);
  registerImagickConstants(s_EVALUATE_DIVIDE, DivideEvaluateOperator);
  registerImagickConstants(s_EVALUATE_LEFTSHIFT, LeftShiftEvaluateOperator);
  registerImagickConstants(s_EVALUATE_MAX, MaxEvaluateOperator);
  registerImagickConstants(s_EVALUATE_MIN, MinEvaluateOperator);
  registerImagickConstants(s_EVALUATE_MULTIPLY, MultiplyEvaluateOperator);
  registerImagickConstants(s_EVALUATE_OR, OrEvaluateOperator);
  registerImagickConstants(s_EVALUATE_RIGHTSHIFT, RightShiftEvaluateOperator);
  registerImagickConstants(s_EVALUATE_SET, SetEvaluateOperator);
  registerImagickConstants(s_EVALUATE_SUBTRACT, SubtractEvaluateOperator);
  registerImagickConstants(s_EVALUATE_XOR, XorEvaluateOperator);
  registerImagickConstants(s_EVALUATE_POW, PowEvaluateOperator);
  registerImagickConstants(s_EVALUATE_LOG, LogEvaluateOperator);
  registerImagickConstants(s_EVALUATE_THRESHOLD, ThresholdEvaluateOperator);
  registerImagickConstants(s_EVALUATE_THRESHOLDBLACK,
                           ThresholdBlackEvaluateOperator);
  registerImagickConstants(s_EVALUATE_THRESHOLDWHITE,
                           ThresholdWhiteEvaluateOperator);
  registerImagickConstants(s_EVALUATE_GAUSSIANNOISE,
                           GaussianNoiseEvaluateOperator);
  registerImagickConstants(s_EVALUATE_IMPULSENOISE,
                           ImpulseNoiseEvaluateOperator);
  registerImagickConstants(s_EVALUATE_LAPLACIANNOISE,
                           LaplacianNoiseEvaluateOperator);
  registerImagickConstants(s_EVALUATE_MULTIPLICATIVENOISE,
                           MultiplicativeNoiseEvaluateOperator);
  registerImagickConstants(s_EVALUATE_POISSONNOISE,
                           PoissonNoiseEvaluateOperator);
  registerImagickConstants(s_EVALUATE_UNIFORMNOISE,
                           UniformNoiseEvaluateOperator);
  registerImagickConstants(s_EVALUATE_COSINE, CosineEvaluateOperator);
  registerImagickConstants(s_EVALUATE_SINE, SineEvaluateOperator);
  registerImagickConstants(s_EVALUATE_ADDMODULUS, AddModulusEvaluateOperator);
  registerImagickConstants(s_EVALUATE_MEAN, MeanEvaluateOperator);
  registerImagickConstants(s_EVALUATE_ABS, AbsEvaluateOperator);
  registerImagickConstants(s_EVALUATE_EXPONENTIAL,
                           ExponentialEvaluateOperator);
  registerImagickConstants(s_EVALUATE_MEDIAN, MedianEvaluateOperator);
#if MagickLibVersion >= 0x676
  registerImagickConstants(s_EVALUATE_SUM, SumEvaluateOperator);
#endif

  // COLORSPACE constants
  registerImagickConstants(s_COLORSPACE_UNDEFINED, UndefinedColorspace);
  registerImagickConstants(s_COLORSPACE_RGB, RGBColorspace);
  registerImagickConstants(s_COLORSPACE_GRAY, GRAYColorspace);
  registerImagickConstants(s_COLORSPACE_TRANSPARENT, TransparentColorspace);
  registerImagickConstants(s_COLORSPACE_OHTA, OHTAColorspace);
  registerImagickConstants(s_COLORSPACE_LAB, LABColorspace);
  registerImagickConstants(s_COLORSPACE_XYZ, XYZColorspace);
  registerImagickConstants(s_COLORSPACE_YCBCR, YCbCrColorspace);
  registerImagickConstants(s_COLORSPACE_YCC, YCCColorspace);
  registerImagickConstants(s_COLORSPACE_YIQ, YIQColorspace);
  registerImagickConstants(s_COLORSPACE_YPBPR, YPbPrColorspace);
  registerImagickConstants(s_COLORSPACE_YUV, YUVColorspace);
  registerImagickConstants(s_COLORSPACE_CMYK, CMYKColorspace);
  registerImagickConstants(s_COLORSPACE_SRGB, sRGBColorspace);
  registerImagickConstants(s_COLORSPACE_HSB, HSBColorspace);
  registerImagickConstants(s_COLORSPACE_HSL, HSLColorspace);
  registerImagickConstants(s_COLORSPACE_HWB, HWBColorspace);
  registerImagickConstants(s_COLORSPACE_REC601LUMA, Rec601LumaColorspace);
  registerImagickConstants(s_COLORSPACE_REC709LUMA, Rec709LumaColorspace);
  registerImagickConstants(s_COLORSPACE_LOG, LogColorspace);
  registerImagickConstants(s_COLORSPACE_CMY, CMYColorspace);
#if MagickLibVersion >= 0x679
  registerImagickConstants(s_COLORSPACE_LUV, LuvColorspace);
  registerImagickConstants(s_COLORSPACE_HCL, HCLColorspace);
#endif
#if MagickLibVersion >= 0x680
  registerImagickConstants(s_COLORSPACE_LCH, LCHColorspace);
  registerImagickConstants(s_COLORSPACE_LMS, LMSColorspace);
#endif
#if MagickLibVersion >= 0x686
  registerImagickConstants(s_COLORSPACE_LCHAB, LCHabColorspace);
  registerImagickConstants(s_COLORSPACE_LCHUV, LCHuvColorspace);
  registerImagickConstants(s_COLORSPACE_SCRGB, scRGBColorspace);
  registerImagickConstants(s_COLORSPACE_HSI, HSIColorspace);
  registerImagickConstants(s_COLORSPACE_HSV, HSVColorspace);
  registerImagickConstants(s_COLORSPACE_HCLP, HCLpColorspace);
  registerImagickConstants(s_COLORSPACE_YDBDR, YDbDrColorspace);
#endif

  // VIRTUALPIXELMETHOD constants
  registerImagickConstants(s_VIRTUALPIXELMETHOD_UNDEFINED,
                           UndefinedVirtualPixelMethod);
  registerImagickConstants(s_VIRTUALPIXELMETHOD_BACKGROUND,
                           BackgroundVirtualPixelMethod);
  registerImagickConstants(s_VIRTUALPIXELMETHOD_CONSTANT,
                           ConstantVirtualPixelMethod);
  registerImagickConstants(s_VIRTUALPIXELMETHOD_EDGE, EdgeVirtualPixelMethod);
  registerImagickConstants(s_VIRTUALPIXELMETHOD_MIRROR,
                           MirrorVirtualPixelMethod);
  registerImagickConstants(s_VIRTUALPIXELMETHOD_TILE, TileVirtualPixelMethod);
  registerImagickConstants(s_VIRTUALPIXELMETHOD_TRANSPARENT,
                           TransparentVirtualPixelMethod);
  registerImagickConstants(s_VIRTUALPIXELMETHOD_MASK, MaskVirtualPixelMethod);
  registerImagickConstants(s_VIRTUALPIXELMETHOD_BLACK,
                           BlackVirtualPixelMethod);
  registerImagickConstants(s_VIRTUALPIXELMETHOD_GRAY, GrayVirtualPixelMethod);
  registerImagickConstants(s_VIRTUALPIXELMETHOD_WHITE,
                           WhiteVirtualPixelMethod);
  registerImagickConstants(s_VIRTUALPIXELMETHOD_HORIZONTALTILE,
                           HorizontalTileVirtualPixelMethod);
  registerImagickConstants(s_VIRTUALPIXELMETHOD_VERTICALTILE,
                           VerticalTileVirtualPixelMethod);
  registerImagickConstants(s_VIRTUALPIXELMETHOD_HORIZONTALTILEEDGE,
                           HorizontalTileEdgeVirtualPixelMethod);
  registerImagickConstants(s_VIRTUALPIXELMETHOD_VERTICALTILEEDGE,
                           VerticalTileEdgeVirtualPixelMethod);
  registerImagickConstants(s_VIRTUALPIXELMETHOD_CHECKERTILE,
                           CheckerTileVirtualPixelMethod);

  // PREVIEW constants
  registerImagickConstants(s_PREVIEW_UNDEFINED, UndefinedPreview);
  registerImagickConstants(s_PREVIEW_ROTATE, RotatePreview);
  registerImagickConstants(s_PREVIEW_SHEAR, ShearPreview);
  registerImagickConstants(s_PREVIEW_ROLL, RollPreview);
  registerImagickConstants(s_PREVIEW_HUE, HuePreview);
  registerImagickConstants(s_PREVIEW_SATURATION, SaturationPreview);
  registerImagickConstants(s_PREVIEW_BRIGHTNESS, BrightnessPreview);
  registerImagickConstants(s_PREVIEW_GAMMA, GammaPreview);
  registerImagickConstants(s_PREVIEW_SPIFF, SpiffPreview);
  registerImagickConstants(s_PREVIEW_DULL, DullPreview);
  registerImagickConstants(s_PREVIEW_GRAYSCALE, GrayscalePreview);
  registerImagickConstants(s_PREVIEW_QUANTIZE, QuantizePreview);
  registerImagickConstants(s_PREVIEW_DESPECKLE, DespecklePreview);
  registerImagickConstants(s_PREVIEW_REDUCENOISE, ReduceNoisePreview);
  registerImagickConstants(s_PREVIEW_ADDNOISE, AddNoisePreview);
  registerImagickConstants(s_PREVIEW_SHARPEN, SharpenPreview);
  registerImagickConstants(s_PREVIEW_BLUR, BlurPreview);
  registerImagickConstants(s_PREVIEW_THRESHOLD, ThresholdPreview);
  registerImagickConstants(s_PREVIEW_EDGEDETECT, EdgeDetectPreview);
  registerImagickConstants(s_PREVIEW_SPREAD, SpreadPreview);
  registerImagickConstants(s_PREVIEW_SOLARIZE, SolarizePreview);
  registerImagickConstants(s_PREVIEW_SHADE, ShadePreview);
  registerImagickConstants(s_PREVIEW_RAISE, RaisePreview);
  registerImagickConstants(s_PREVIEW_SEGMENT, SegmentPreview);
  registerImagickConstants(s_PREVIEW_SWIRL, SwirlPreview);
  registerImagickConstants(s_PREVIEW_IMPLODE, ImplodePreview);
  registerImagickConstants(s_PREVIEW_WAVE, WavePreview);
  registerImagickConstants(s_PREVIEW_OILPAINT, OilPaintPreview);
  registerImagickConstants(s_PREVIEW_CHARCOALDRAWING, CharcoalDrawingPreview);
  registerImagickConstants(s_PREVIEW_JPEG, JPEGPreview);

  // RENDERINGINTENT constants
  registerImagickConstants(s_RENDERINGINTENT_UNDEFINED, UndefinedIntent);
  registerImagickConstants(s_RENDERINGINTENT_SATURATION, SaturationIntent);
  registerImagickConstants(s_RENDERINGINTENT_PERCEPTUAL, PerceptualIntent);
  registerImagickConstants(s_RENDERINGINTENT_ABSOLUTE, AbsoluteIntent);
  registerImagickConstants(s_RENDERINGINTENT_RELATIVE, RelativeIntent);

  // INTERLACE constants
  registerImagickConstants(s_INTERLACE_UNDEFINED, UndefinedInterlace);
  registerImagickConstants(s_INTERLACE_NO, NoInterlace);
  registerImagickConstants(s_INTERLACE_LINE, LineInterlace);
  registerImagickConstants(s_INTERLACE_PLANE, PlaneInterlace);
  registerImagickConstants(s_INTERLACE_PARTITION, PartitionInterlace);
  registerImagickConstants(s_INTERLACE_GIF, GIFInterlace);
  registerImagickConstants(s_INTERLACE_JPEG, JPEGInterlace);
  registerImagickConstants(s_INTERLACE_PNG, PNGInterlace);

  // FILLRULE constants
  registerImagickConstants(s_FILLRULE_UNDEFINED, UndefinedRule);
  registerImagickConstants(s_FILLRULE_EVENODD, EvenOddRule);
  registerImagickConstants(s_FILLRULE_NONZERO, NonZeroRule);

  // PATHUNITS constants
  registerImagickConstants(s_PATHUNITS_UNDEFINED, UndefinedPathUnits);
  registerImagickConstants(s_PATHUNITS_USERSPACE, UserSpace);
  registerImagickConstants(s_PATHUNITS_USERSPACEONUSE, UserSpaceOnUse);
  registerImagickConstants(s_PATHUNITS_OBJECTBOUNDINGBOX, ObjectBoundingBox);

  // LINECAP constants
  registerImagickConstants(s_LINECAP_UNDEFINED, UndefinedCap);
  registerImagickConstants(s_LINECAP_BUTT, ButtCap);
  registerImagickConstants(s_LINECAP_ROUND, RoundCap);
  registerImagickConstants(s_LINECAP_SQUARE, SquareCap);

  // LINEJOIN constants
  registerImagickConstants(s_LINEJOIN_UNDEFINED, UndefinedJoin);
  registerImagickConstants(s_LINEJOIN_MITER, MiterJoin);
  registerImagickConstants(s_LINEJOIN_ROUND, RoundJoin);
  registerImagickConstants(s_LINEJOIN_BEVEL, BevelJoin);

  // RESOURCETYPE constants
  registerImagickConstants(s_RESOURCETYPE_UNDEFINED, UndefinedResource);
  registerImagickConstants(s_RESOURCETYPE_AREA, AreaResource);
  registerImagickConstants(s_RESOURCETYPE_DISK, DiskResource);
  registerImagickConstants(s_RESOURCETYPE_FILE, FileResource);
  registerImagickConstants(s_RESOURCETYPE_MAP, MapResource);
  registerImagickConstants(s_RESOURCETYPE_MEMORY, MemoryResource);
#if MagickLibVersion > 0x678
  registerImagickConstants(s_RESOURCETYPE_THREAD, ThreadResource);
#endif

  // LAYERMETHOD constants
  registerImagickConstants(s_LAYERMETHOD_UNDEFINED, UndefinedLayer);
  registerImagickConstants(s_LAYERMETHOD_COALESCE, CoalesceLayer);
  registerImagickConstants(s_LAYERMETHOD_COMPAREANY, CompareAnyLayer);
  registerImagickConstants(s_LAYERMETHOD_COMPARECLEAR, CompareClearLayer);
  registerImagickConstants(s_LAYERMETHOD_COMPAREOVERLAY, CompareOverlayLayer);
  registerImagickConstants(s_LAYERMETHOD_DISPOSE, DisposeLayer);
  registerImagickConstants(s_LAYERMETHOD_OPTIMIZE, OptimizeLayer);
  registerImagickConstants(s_LAYERMETHOD_OPTIMIZEPLUS, OptimizePlusLayer);
  registerImagickConstants(s_LAYERMETHOD_OPTIMIZETRANS, OptimizeTransLayer);
  registerImagickConstants(s_LAYERMETHOD_COMPOSITE, CompositeLayer);
  registerImagickConstants(s_LAYERMETHOD_OPTIMIZEIMAGE, OptimizeImageLayer);
  registerImagickConstants(s_LAYERMETHOD_REMOVEDUPS, RemoveDupsLayer);
  registerImagickConstants(s_LAYERMETHOD_REMOVEZERO, RemoveZeroLayer);
  registerImagickConstants(s_LAYERMETHOD_MERGE, MergeLayer);
  registerImagickConstants(s_LAYERMETHOD_FLATTEN, FlattenLayer);
  registerImagickConstants(s_LAYERMETHOD_MOSAIC, MosaicLayer);
  registerImagickConstants(s_LAYERMETHOD_TRIMBOUNDS, TrimBoundsLayer);

  // ORIENTATION constants
  registerImagickConstants(s_ORIENTATION_UNDEFINED, UndefinedOrientation);
  registerImagickConstants(s_ORIENTATION_TOPLEFT, TopLeftOrientation);
  registerImagickConstants(s_ORIENTATION_TOPRIGHT, TopRightOrientation);
  registerImagickConstants(s_ORIENTATION_BOTTOMRIGHT, BottomRightOrientation);
  registerImagickConstants(s_ORIENTATION_BOTTOMLEFT, BottomLeftOrientation);
  registerImagickConstants(s_ORIENTATION_LEFTTOP, LeftTopOrientation);
  registerImagickConstants(s_ORIENTATION_RIGHTTOP, RightTopOrientation);
  registerImagickConstants(s_ORIENTATION_RIGHTBOTTOM, RightBottomOrientation);
  registerImagickConstants(s_ORIENTATION_LEFTBOTTOM, LeftBottomOrientation);

  // DISTORTION constants
  registerImagickConstants(s_DISTORTION_UNDEFINED, UndefinedDistortion);
  registerImagickConstants(s_DISTORTION_AFFINE, AffineDistortion);
  registerImagickConstants(s_DISTORTION_AFFINEPROJECTION,
                           AffineProjectionDistortion);
  registerImagickConstants(s_DISTORTION_ARC, ArcDistortion);
  registerImagickConstants(s_DISTORTION_BILINEAR, BilinearDistortion);
  registerImagickConstants(s_DISTORTION_PERSPECTIVE, PerspectiveDistortion);
  registerImagickConstants(s_DISTORTION_PERSPECTIVEPROJECTION,
                           PerspectiveProjectionDistortion);
  registerImagickConstants(s_DISTORTION_SCALEROTATETRANSLATE,
                           ScaleRotateTranslateDistortion);
  registerImagickConstants(s_DISTORTION_POLYNOMIAL, PolynomialDistortion);
  registerImagickConstants(s_DISTORTION_POLAR, PolarDistortion);
  registerImagickConstants(s_DISTORTION_DEPOLAR, DePolarDistortion);
  registerImagickConstants(s_DISTORTION_BARREL, BarrelDistortion);
  registerImagickConstants(s_DISTORTION_BARRELINVERSE,
                           BarrelInverseDistortion);
  registerImagickConstants(s_DISTORTION_SHEPARDS, ShepardsDistortion);
  registerImagickConstants(s_DISTORTION_SENTINEL, SentinelDistortion);
  registerImagickConstants(s_DISTORTION_BILINEARFORWARD,
                           BilinearForwardDistortion);
  registerImagickConstants(s_DISTORTION_BILINEARREVERSE,
                           BilinearReverseDistortion);
#if MagickLibVersion >= 0x670
  registerImagickConstants(s_DISTORTION_RESIZE, ResizeDistortion);
#endif
#if MagickLibVersion >= 0x671
  registerImagickConstants(s_DISTORTION_CYLINDER2PLANE,
                           Cylinder2PlaneDistortion);
  registerImagickConstants(s_DISTORTION_PLANE2CYLINDER,
                           Plane2CylinderDistortion);
#endif

  // ALPHACHANNEL constants
  registerImagickConstants(s_ALPHACHANNEL_ACTIVATE, ActivateAlphaChannel);
  registerImagickConstants(s_ALPHACHANNEL_DEACTIVATE, DeactivateAlphaChannel);
  registerImagickConstants(s_ALPHACHANNEL_RESET, ResetAlphaChannel);
  registerImagickConstants(s_ALPHACHANNEL_SET, SetAlphaChannel);
  registerImagickConstants(s_ALPHACHANNEL_UNDEFINED, UndefinedAlphaChannel);
  registerImagickConstants(s_ALPHACHANNEL_COPY, CopyAlphaChannel);
  registerImagickConstants(s_ALPHACHANNEL_EXTRACT, ExtractAlphaChannel);
  registerImagickConstants(s_ALPHACHANNEL_OPAQUE, OpaqueAlphaChannel);
  registerImagickConstants(s_ALPHACHANNEL_SHAPE, ShapeAlphaChannel);
  registerImagickConstants(s_ALPHACHANNEL_TRANSPARENT,
                           TransparentAlphaChannel);
#if MagickLibVersion >= 0x680
  registerImagickConstants(s_ALPHACHANNEL_FLATTEN, FlattenAlphaChannel);
  registerImagickConstants(s_ALPHACHANNEL_REMOVE, RemoveAlphaChannel);
#endif

  // SPARSECOLORMETHOD constants
  registerImagickConstants(s_SPARSECOLORMETHOD_UNDEFINED,
                           UndefinedColorInterpolate);
  registerImagickConstants(s_SPARSECOLORMETHOD_BARYCENTRIC,
                           BarycentricColorInterpolate);
  registerImagickConstants(s_SPARSECOLORMETHOD_BILINEAR,
                           BilinearColorInterpolate);
  registerImagickConstants(s_SPARSECOLORMETHOD_POLYNOMIAL,
                           PolynomialColorInterpolate);
  registerImagickConstants(s_SPARSECOLORMETHOD_SPEPARDS,
                           ShepardsColorInterpolate);
  registerImagickConstants(s_SPARSECOLORMETHOD_VORONOI,
                           VoronoiColorInterpolate);

  // FUNCTION constants
  registerImagickConstants(s_FUNCTION_UNDEFINED, UndefinedFunction);
  registerImagickConstants(s_FUNCTION_POLYNOMIAL, PolynomialFunction);
  registerImagickConstants(s_FUNCTION_SINUSOID, SinusoidFunction);
  registerImagickConstants(s_FUNCTION_ARCSIN, ArcsinFunction);
  registerImagickConstants(s_FUNCTION_ARCTAN, ArctanFunction);

  // INTERPOLATE constants
  registerImagickConstants(s_INTERPOLATE_UNDEFINED,
                           UndefinedInterpolatePixel);
  registerImagickConstants(s_INTERPOLATE_AVERAGE, AverageInterpolatePixel);
  registerImagickConstants(s_INTERPOLATE_BICUBIC, BicubicInterpolatePixel);
  registerImagickConstants(s_INTERPOLATE_BILINEAR, BilinearInterpolatePixel);
  registerImagickConstants(s_INTERPOLATE_FILTER, FilterInterpolatePixel);
  registerImagickConstants(s_INTERPOLATE_INTEGER, IntegerInterpolatePixel);
  registerImagickConstants(s_INTERPOLATE_MESH, MeshInterpolatePixel);
  registerImagickConstants(s_INTERPOLATE_NEARESTNEIGHBOR,
                           NearestNeighborInterpolatePixel);
  registerImagickConstants(s_INTERPOLATE_SPLINE, SplineInterpolatePixel);

  // DITHERMETHOD constants
  registerImagickConstants(s_DITHERMETHOD_UNDEFINED, UndefinedDitherMethod);
  registerImagickConstants(s_DITHERMETHOD_NO, NoDitherMethod);
  registerImagickConstants(s_DITHERMETHOD_RIEMERSMA, RiemersmaDitherMethod);
  registerImagickConstants(s_DITHERMETHOD_FLOYDSTEINBERG,
                           FloydSteinbergDitherMethod);
}

//////////////////////////////////////////////////////////////////////////////
} // namespace HPHP
