{- Copyright (c) 2007 John Goerzen <jgoerzen@complete.org>
   Please see the COPYRIGHT file -}

import Utils
import System.Environment
import System.IO.Error
import Text.Printf
import System.Directory
import HSH
import Types

args = []
helpinfo = "Usage:\n\
\hg-buildpackage [debuild args]\n\
\\n\
\Builds the current package\n\
\\n\
\If HBP_BUILDER is set, builds using that command; otherwise, uses debuild.\n"

main = do args <- getArgs
          builder <- catch (getEnv "HBP_BUILDER") (\_ -> return "debuild")
          package <- getwdpackage
          version <- getwdversion
          let tag = Tag "DEBIAN" package version
          let hasupstream = tag2upsver tag /= tag2ver tag

          assertvalidhg "."
          if hasupstream 
             then buildorig tag
             else putStrLn "Debian-native package; not building or checking\
                            \ for orig.tar.gz"
          runIO (builder, ["-i.hg", "-I.hg"] ++ args)

buildorig tag = 
    do dfe <- doesFileExist tgzname
       dde <- doesDirectoryExist origdirname
       if dfe || dde
          then putStrLn "Upstream file/directory already exists; not building"
          else do putStrLn $ "Building " ++ tgzname ++ 
                               " from Mercurial history"
                  runIO $ ("hg", ["archive", "-r", tag2upsstr tag, "-t", "tgz",
                                  "-X", ".hg_archival.txt", "-X", ".hgtags",
                                  tgzname])
    where tgzname = printf "../%s_%s.orig.tar.gz" (tag2pkg tag) (tag2upsver tag)
          origdirname = printf "../%s-%s.orig" (tag2pkg tag) (tag2upsver tag)
          
