{- Copyright (c) 2007 John Goerzen <jgoerzen@complete.org>
   Please see the COPYRIGHT file -}

module Types where
import Data.String.Utils
import Data.List
import System.Console.GetOpt

data Tag = Tag String String String deriving (Eq, Ord)
tag2ver (Tag _ _ v) = v
tag2pkg (Tag _ p _) = p
tag2type (Tag t _ _) = t
parsetag t = case split "_" t of
              [x, y, z] -> Tag x y (parsetag2ver z)
              _ -> error $ "Unable to parse tag " ++ t

tag2upsver (Tag "DEBIAN" _ v) = case findIndices (== '-') v of
                                  [] -> stripepoch v
                                  x -> stripepoch (take (last x) v)
tag2upsver (Tag _ _ v) = v

tag2upsstr t@(Tag "DEBIAN" p v) = show (Tag "UPSTREAM" p (tag2upsver t))
tag2upsstr (Tag _ p v) = show (Tag "UPSTREAM" p v)

instance Show Tag where
    show (Tag "DEBIAN" p v) = "DEBIAN_" ++ p ++ "_" ++ (ver2tag v)
    show (Tag t p v) = t ++ "_" ++ p ++ "_" ++ v

ver2tag v = replace ":" ";" v
parsetag2ver v = replace ";" ":" v
stripepoch v =
    case span (/= ':') v of
      (ver, []) -> ver
      (_, (x:xs)) -> xs

data ImportOpt = Verbose | S String deriving (Eq, Ord, Show)
importopt2arg Verbose = ["-v"]
importopt2arg (S x) = ["-s", x]

importargs = 
    [Option ['v'] ["verbose"] (NoArg Verbose) "Enable verbose mode",
     Option ['s'] ["similarity"] (ReqArg S "n") "Use hg addremove -s for renames"]
