/* 
 * ### Copyright (C) 2001-2007 Michael Fuchs ###
 * ### All Rights Reserved.             ###
 *
 * Author: Michael Fuchs
 * E-Mail: michael.fuchs@unico-group.com
 * URL:    http://www.michael-a-fuchs.de
 */
package org.dbdoclet.trafo.html.docbook.editor.javadoc;

import org.dbdoclet.trafo.html.docbook.editor.Editor;
import org.dbdoclet.trafo.html.docbook.editor.EditorInstruction;

/**
 * The class <code>ValueEditor</code> is reponsible for transforming @value tags
 * into DocBook code.
 * 
 * @author <a href="mailto:michael.fuchs@unico-group.com">Michael Fuchs</a>
 * @version $Revision$
 */
public class ValueEditor extends Editor {

    @Override
    public EditorInstruction edit(EditorInstruction values) {

	setValues(values);

	org.dbdoclet.trafo.tag.javadoc.Value value = (org.dbdoclet.trafo.tag.javadoc.Value) getHtmlElement();
	getCurrent().appendChild(value.getTextContent());

	traverse(false);

	return finalizeValues();
    }
}
