/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.xml.tokenizer.parser;


/**
 * Token literal values and constants.
 * Generated by org.javacc.parser.OtherFilesGen#start()
 */
public interface XmlTokenizerConstants {

  /** End of File. */
  int EOF = 0;
  /** RegularExpression Id. */
  int TAG_START = 8;
  /** RegularExpression Id. */
  int QUOTE = 9;
  /** RegularExpression Id. */
  int TEXT = 10;
  /** RegularExpression Id. */
  int TAG_END = 16;
  /** RegularExpression Id. */
  int EQUALS = 17;
  /** RegularExpression Id. */
  int SLASH = 18;
  /** RegularExpression Id. */
  int NCNAME = 19;
  /** RegularExpression Id. */
  int VALUE = 20;
  /** RegularExpression Id. */
  int COMMENT = 21;
  /** RegularExpression Id. */
  int DIGIT = 22;
  /** RegularExpression Id. */
  int LETTER = 23;
  /** RegularExpression Id. */
  int WHITESPACE = 24;
  /** RegularExpression Id. */
  int NAME_START_CHAR = 25;
  /** RegularExpression Id. */
  int TEXT_AFTER_GT = 26;
  /** RegularExpression Id. */
  int NAME_CHAR = 27;
  /** RegularExpression Id. */
  int NAME = 28;

  /** Lexical state. */
  int DEFAULT = 0;
  /** Lexical state. */
  int WithinIgnorable = 1;
  /** Lexical state. */
  int TAG_CONTEXT = 2;
  /** Lexical state. */
  int COMMENT_CONTEXT = 3;

  /** Literal token values. */
  String[] tokenImage = {
    "<EOF>",
    "\" \"",
    "\"\\r\"",
    "\"\\t\"",
    "\"\\n\"",
    "<token of kind 5>",
    "<token of kind 6>",
    "<token of kind 7>",
    "\"<\"",
    "<QUOTE>",
    "<TEXT>",
    "\"<!--\"",
    "\" \"",
    "\"\\r\"",
    "\"\\t\"",
    "\"\\n\"",
    "\">\"",
    "\"=\"",
    "\"/\"",
    "<NCNAME>",
    "<VALUE>",
    "<COMMENT>",
    "<DIGIT>",
    "<LETTER>",
    "<WHITESPACE>",
    "<NAME_START_CHAR>",
    "<TEXT_AFTER_GT>",
    "<NAME_CHAR>",
    "<NAME>",
  };

}
