/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.tag.html;

import org.w3c.dom.Node;

public class Html extends StrictElement {

    @Override
    public boolean validate() {

	Node parent = getParentNode();
	
	if (parent instanceof HtmlDocument) {
	    
	    nodeStack.removeAllElements();
	    nodeStack.push(this);
	    return true;
	}
	
	return false;
    }

    private static final String tag = "html";

    public static String getTag() {
	return tag;
    }

    public Html() {
	setNodeName(tag);
	setFormatType(FORMAT_BLOCK);
    }
}
