/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.tag.docbook;

import java.util.HashMap;

public class InformalFigure extends DocBookElement {

    private static final String TAG = "informalfigure";
    private static final HashMap<String, HashMap<String, Object>> invalidParentMap;

    static {

	invalidParentMap = new HashMap<String, HashMap<String, Object>>();
	invalidParentMap.put(Abbrev.getTag(), Abbrev.getAttributeMap());
	invalidParentMap.put(Acronym.getTag(), Acronym.getAttributeMap());
	invalidParentMap.put(Address.getTag(), Address.getAttributeMap());
	invalidParentMap.put(Subscript.getTag(), Subscript.getAttributeMap());
	invalidParentMap.put(Superscript.getTag(), Superscript.getAttributeMap());
	invalidParentMap.put(Title.getTag(), Title.getAttributeMap());
	invalidParentMap.put(ProgramListing.getTag(), ProgramListing.getAttributeMap());
    }

    public static String getTag() {

	return TAG;
    }

    InformalFigure() {
	super("informalfigure");
	setFormatType(FORMAT_BLOCK);
    }

    @Override
    public boolean validate() {

	return validate(invalidParentMap);
    }
}
