/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.tag;

import java.util.Stack;


public class NodeStack extends Stack<Object> {

    private static final long serialVersionUID = 1L;

    public int searchNearest(String[] nodes) {

        if (nodes == null) {

            throw new IllegalArgumentException("Variable nodes is null!");
        }

        int min = -1;
        int index;

        for (int i = 0; i < nodes.length; i++) {

            index = search(nodes[i]);

            if (index != -1) {

                if ((min == -1) || (index < min)) {
                    min = index;
                }
            } // end of if ()
        } // end of for ()

        return min;
    }
}
