/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.html.docbook.editor.javadoc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.trafo.html.docbook.editor.Editor;
import org.dbdoclet.trafo.html.docbook.editor.EditorInstruction;
import org.dbdoclet.trafo.tag.docbook.DocBookElement;
import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;
import org.dbdoclet.trafo.tag.docbook.Emphasis;
import org.dbdoclet.trafo.tag.docbook.Literal;

/**
 * The class <code>LinkEditor</code> is reponsible for transforming @link tags
 * into DocBook code.
 * 
 * @author <a href="mailto:michael.fuchs@unico-group.com">Michael Fuchs</a>
 * @version $Revision$
 */
public class LinkEditor extends Editor {

	private static Log logger = LogFactory.getLog(LinkEditor.class);

	@Override
	public EditorInstruction edit(EditorInstruction values) {

		setValues(values);
		DocBookTagFactory dbfactory = values.getTagFactory();
		DocBookElement parent = getParent();

		org.dbdoclet.trafo.tag.javadoc.Link link = (org.dbdoclet.trafo.tag.javadoc.Link) getHtmlElement();

		String ref = link.getRef();
		logger.debug("ref=" + ref);

		if ((ref != null) && (ref.length() > 0)) {

			String name = link.getName();
			String label = link.getTextContent();

			Literal elem;

			if (parent instanceof Literal) {

				elem = (Literal) parent;

			} else {

				elem = dbfactory.createLiteral();
				setCurrent(elem);
				parent.appendChild(getCurrent());
			}

			if ((label != null) && (label.length() > 0)) {
				elem.appendChild(dbfactory.createLink(label, ref));
			} else {
				elem.appendChild(dbfactory.createLink(name, ref));
			}

		} else {

			Emphasis elem = dbfactory.createEmphasis(link.getName());
			setCurrent(elem);
			parent.appendChild(getCurrent());
		}

		traverse(false);

		return finalizeValues();
	}
}
