/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.trafo.tag.docbook.DocBookElement;
import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;
import org.dbdoclet.trafo.tag.docbook.Para;
import org.dbdoclet.xiphias.dom.NodeImpl;

public class TextEditor extends Editor {

	@Override
	public EditorInstruction edit(EditorInstruction values)
			throws EditorException {

		try {

			setValues(super.edit(values));
			DocBookTagFactory dbfactory = values.getTagFactory();

			DocBookElement parent = getParent();
			DocBookElement current = getCurrent();

			if (parent.isContentModel()) {

				if (getCharacterDataNode().getNodeType() == NodeImpl.TEXT_NODE) {

					Para para = dbfactory.createPara();
					parent.appendChild(para);

					setParent(para);
					parent = para;

					setCurrent(para);
					current = para;
				}
			}

			String text = getCharacterDataNode().getData();
			current.appendChild(text);
			return finalizeValues();
			
		} catch (Exception oops) {

			throw new EditorException(oops);
		}
	}
}
