/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.html.docbook.editor;

import java.util.Iterator;

import org.dbdoclet.trafo.html.docbook.DbtConstants;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.dbdoclet.xiphias.dom.NodeImpl;
import org.dbdoclet.xiphias.dom.NodeListImpl;

public class TdEditor extends Editor {

	@Override
	public EditorInstruction edit(EditorInstruction values)
			throws EditorException {

		setValues(super.edit(values));

		DocBookTagFactory dbfactory = values.getTagFactory();

		Script script = getTransformer().getScript();
		boolean decomposeTables = script.isParameterOn(
				DbtConstants.SECTION_DOCBOOK,
				DbtConstants.PARAM_DOCBOOK_DECOMPOSE_TABLES,
				DbtConstants.DEFAULT_DECOMPOSE_TABLES);

		if (decomposeTables || getHtmlElement().isMute()) {
			traverse(true);
			return finalizeValues();
		}

		org.dbdoclet.trafo.tag.html.Td td = (org.dbdoclet.trafo.tag.html.Td) getHtmlElement();
		org.dbdoclet.trafo.tag.docbook.Entry entry = dbfactory.createEntry();
		copyCommonAttributes(getHtmlElement(), entry);

		NodeListImpl children = td.getTrafoChildNodes();
		Iterator<NodeImpl> iterator = children.iterator();
		NodeImpl node;

		while (iterator.hasNext()) {

			node = iterator.next();

			if (node instanceof org.dbdoclet.trafo.tag.html.Table) {
				traverse(true);
				return finalizeValues();
			}
		}

		entry.setAlign(td.getAlign());
		entry.setChar(td.getChar());
		entry.setCharOff(td.getCharOff());
		entry.setVAlign(td.getVAlign());

		int colspan = td.getColspan();

		if (colspan > 1) {

			entry.setNameSt("c" + td.getIndex());
			entry.setNameEnd("c" + ((td.getIndex() + colspan) - 1));
		}

		int rowspan = td.getRowspan();

		if (rowspan > 0) {
			entry.setMorerows(rowspan);
		}

		org.dbdoclet.trafo.tag.docbook.Para para = dbfactory.createPara();
		para.setFormatType(ElementImpl.FORMAT_INLINE);

		entry.appendChild(para);
		para.setParentNode(entry);

		getParent().appendChild(entry);
		entry.setParentNode(getParent());

		setCurrent(para);
		traverse(true);

		return finalizeValues();
	}
}
