/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.trafo.tag.docbook.Article;
import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;
import org.dbdoclet.trafo.tag.html.HtmlElement;

public class HtmlEditor extends Editor {

	@Override
	public EditorInstruction edit(EditorInstruction values)
			throws EditorException {

		setValues(super.edit(values));
		DocBookTagFactory dbfactory = values.getTagFactory();

		Article article = dbfactory.createArticle();

		HtmlElement child = getHtmlElement();

		String lang = child.getAttribute("lang");

		if (lang == null) {
			lang = child.getAttribute("xml:lang");
		}

		if (lang != null) {
			article.setAttribute("lang", lang.toLowerCase());
		}

		setCurrent(article);
		traverse(true);

		article.setAttribute("xmlns", "http://docbook.org/ns/docbook");
		article.setAttribute("version", "5.0");

		if (lang != null) {
			article.setAttribute("xml:lang", lang.toLowerCase());
		}

		getParent().appendChild(getCurrent());

		return finalizeValues();
	}
}
