/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;
import org.dbdoclet.trafo.tag.docbook.Emphasis;
import org.dbdoclet.trafo.tag.docbook.SimPara;
import org.dbdoclet.trafo.tag.html.Font;

public class FontEditor extends Editor {

    @Override
	public EditorInstruction edit(EditorInstruction values) throws EditorException {

	setValues(super.edit(values));
	DocBookTagFactory dbfactory = values.getTagFactory();

	traverse(true);
	Font font = (Font) values.getHtmlElement();

	String color = font.getAttribute("color");

	if (color == null || color.trim().length() == 0) {
	    return finalizeValues();
	}

	Emphasis emphasis = dbfactory.createEmphasis();
	emphasis.setRole("color");
	emphasis.setCondition(color);

	setCurrent(emphasis);

	if (emphasis.isValidParent(getParent()) == false) {

	    SimPara candidate = dbfactory.createSimPara();
	    candidate.setParentNode(getParent());

	    if (candidate.validate()) {

		getParent().appendChild(candidate);
		candidate.appendChild(getCurrent());
	    }

	} else {

	    getCurrent().setParentNode(getParent());
	    getParent().appendChild(getCurrent());
	}

	return finalizeValues();
    }
}
