/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.trafo.tag.html.HtmlElement;
import org.dbdoclet.trafo.tag.javadoc.JavaDocElement;

public class EditorFactory {

    static public Editor getChildEditor(HtmlElement child) throws EditorFactoryException {

	if (child == null) {
	    throw new EditorFactoryException("Can't create editor for child null!");
	}

	String str = child.getClass().getName();

	if (child instanceof JavaDocElement) {

	    str = "org.dbdoclet.trafo.html.docbook.editor.javadoc"
		    + str.substring(str.lastIndexOf('.'), str.length()) + "Editor";

	} else {

	    str = "org.dbdoclet.trafo.html.docbook.editor"
		    + str.substring(str.lastIndexOf('.'), str.length()) + "Editor";
	}

	Class<?> c;
	Object o;

	try {

	    c = Class.forName(str);
	    o = c.newInstance();

	} catch (ClassNotFoundException oops) {

	    return new DefaultEditor();
	    
	} catch (InstantiationException oops) {

	    throw new EditorFactoryException("Can't create editor for " + child.getNodeName());

	} catch (IllegalAccessException oops) {

	    throw new EditorFactoryException("No permission to create editor for "
		    + child.getNodeName());
	}

	return (Editor) o;
    }

    public static Editor getCommentEditor() {

	return new CommentEditor();
    }

    public static Editor getTextEditor() {

	return new TextEditor();
    }
}
