/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.html.docbook.editor;

import java.io.PrintStream;
import java.io.PrintWriter;

public class EditorException extends Exception {

    private static final long serialVersionUID = 1L;
    private Exception cause;

    public EditorException(Exception oops) {

	super(oops.getClass().getName() + ": " + oops.getMessage());
	cause = oops;
    }

    public EditorException(String msg) {
	super(msg);
    }

    @Override
    public void printStackTrace() {

	if (cause != null) {

	    System.err.println("\nCause:");
	    cause.printStackTrace();
	    System.err.println("-------");
	}

	super.printStackTrace();
    }

    @Override
    public void printStackTrace(PrintStream stream) {

	printStackTrace(new PrintWriter(stream));
    }

    @Override
    public void printStackTrace(PrintWriter writer) {

	if (writer == null) {
	    return;
	}

	if (cause != null) {

	    writer.println("\nCause:");
	    cause.printStackTrace(writer);
	    writer.println("-------");
	}

	super.printStackTrace(writer);
    }
}
