/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.trafo.tag.docbook.DocBookElement;
import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;
import org.dbdoclet.trafo.tag.docbook.Literal;
import org.dbdoclet.trafo.tag.html.Code;

public class CodeEditor extends Editor {

    @Override
    public EditorInstruction edit(EditorInstruction values) throws EditorException {

	setValues(super.edit(values));
	DocBookTagFactory dbfactory = values.getTagFactory();

	Code code = (Code) getHtmlElement();
	DocBookElement parent = getParent();

	if (parent.isContentModel() == true) {

	    setCurrent(dbfactory.createProgramListing());
	    parent.appendChild(getCurrent());
	    traverse(true);

	} else {

	    Literal candidate = dbfactory.createLiteral(code.getTextContent());
	    candidate.setParentNode(parent);

	    if (candidate.validate()) {
		parent.appendChild(candidate);
	    }

	    traverse(false);
	}

	return finalizeValues();
    }
}
