package org.dbdoclet.trafo.html.docbook;

import java.util.ArrayList;
import java.util.HashMap;

import org.dbdoclet.progress.ProgressEvent;
import org.dbdoclet.progress.ProgressListener;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.trafo.tag.docbook.DocBookElement;
import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;
import org.dbdoclet.trafo.tag.docbook.EntryTbl;
import org.dbdoclet.trafo.tag.docbook.InformalTable;
import org.dbdoclet.trafo.tag.docbook.Para;
import org.dbdoclet.trafo.tag.docbook.Table;
import org.dbdoclet.xiphias.HtmlServices;
import org.dbdoclet.xiphias.XmlServices;
import org.dbdoclet.xiphias.dom.AbstractNodeVisitor;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.dbdoclet.xiphias.dom.NodeImpl;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class PostprocessStage1 extends AbstractNodeVisitor {

	private ArrayList<Node> removeList;
	private HashMap<EntryTbl, DocBookElement> subtables;
	private final Script script;

	public PostprocessStage1(DocBookTagFactory dbfactory, Script script, ArrayList<ProgressListener> listeners) {

		super(listeners);

		this.script = script;
		removeList = new ArrayList<Node>();
		subtables = new HashMap<EntryTbl, DocBookElement>();
	}

	public void accept(Node node) {

		fireProgressEvent(node.toString(), ProgressEvent.STAGE_ACTION);

		if (node instanceof Text) {

			if (script.isParameterOn(
					DbtConstants.SECTION_DOCBOOK,
					DbtConstants.PARAM_DOCBOOOK_COLLAPSE_PROTECTED_SPACE, false)) {

				Text textNode = (Text) node;
				String text = textNode.getData();

				if (text.indexOf("\u00A0") != -1) {
					text = text.replace('\u00A0', ' ');
				}

				textNode.setData(XmlServices.normalizeText(text));
			}

			replaceHtmlEntities((Text) node);
		}

		if (node instanceof ElementImpl) {

			NodeImpl elem = (NodeImpl) node;

			if (elem instanceof Para && elem.hasSiblingElements() == true
					&& elem.hasElementChildren() == false) {

				String text = elem.getTextContent();
				text = text.replace((char) 160, ' ');
				text = text.trim();

				if (text.length() == 0) {
					removeList.add(elem);
				}
			}

			if (elem instanceof EntryTbl) {

				node = NodeImpl
						.findParent(elem.getParentNode(), EntryTbl.class);

				if (node != null) {

					DocBookElement parentTable = (DocBookElement) NodeImpl
							.findParent(elem, Table.class);

					if (parentTable == null) {
						parentTable = (DocBookElement) NodeImpl.findParent(
								elem, InformalTable.class);
					}

					if (parentTable != null) {
						subtables.put((EntryTbl) elem, parentTable);
					}
				}
			}
		}
	}

	public void finish() {
		removeNodes(removeList);
	}

	public HashMap<EntryTbl, DocBookElement> getSubtables() {
		return subtables;
	}

	private void replaceHtmlEntities(Text child) {

		String buffer = HtmlServices.replaceEntities(child.getTextContent());
		child.setTextContent(buffer);
	}

	public void openTag(Node node) throws Exception {
		//
	}

	public void closeTag(Node node) throws Exception {
		//
	}
}
