/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.html.docbook;

import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.service.StringServices;
import org.dbdoclet.xiphias.dom.ElementImpl;

public class LinkManager {

	private static Log logger = LogFactory.getLog(LinkManager.class);

	private final ArrayList<String> anchorIdList;
	private final ArrayList<ElementImpl> linkList;
	private final ArrayList<String> usedIdList;

	public LinkManager() {

		linkList = new ArrayList<ElementImpl>();
		anchorIdList = new ArrayList<String>();
		usedIdList = new ArrayList<String>();
	}

	public void addLink(ElementImpl link) {
		linkList.add(link);
	}

	public String createUniqueId(String str) {

		String id = str;

		id = ElementImpl.hardenId(id);

		String key = id;
		int counter = 1;

		while (anchorIdList.contains(key)) {

			key = id + "." + counter;
			counter++;
		}

		anchorIdList.add(key);
		logger.debug("Added reference " + key + ".");

		return key;
	}

	public ArrayList<ElementImpl> getLinkList() {
		return linkList;
	}

	public String getUniqueId(String str) {

		String id = str;

		logger.debug("#1 id=" + id);

		id = StringServices.cutPrefix(id, "#");

		id = ElementImpl.hardenId(id);
		logger.debug("#2 id=" + id);

		if (id == null || id.length() == 0) {
			id = "dbdoclet.id";
		}

		if (usedIdList.contains(id) == false) {
			usedIdList.add(id);
		}

		logger.debug("#3 id=" + id);
		return id;
	}

	public ArrayList<String> getUnresolvedIds() {

		ArrayList<String> list = new ArrayList<String>(usedIdList);
		list.removeAll(anchorIdList);

		return list;
	}

	public ArrayList<String> getUsedIdList() {

		return anchorIdList;
	}
}
