/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.option;

/**
 * Die Klasse <code>SelectOption</code> definiert eine Option, die einen Wert
 * aus einer Menge vorbestimmter Werte annehmen kann.
 *
 * Das folgende Beispiel zeigt die Definition der Option "cmd", die die Werte
 * list, extract und create annehmen kann.
 *
 * <div id="example_SelectOption" title="Beispiel für SelectOption"> 
 * <pre>  SelectOption optCmd = new SelectOption("cmd", "c");
 *  optCmd.isRequired(true);
 *  String[] optCmdList = { "list", "extract", "create" };
 *  optCmd.setList(optCmdList);
 *  options.add(optCmd);</pre>
 * </div>
 *
 * @author <a href="mailto:mfuchs@unico-consulting.com">Michael Fuchs</a>
 * @version 1.0
 */
public class SelectOption extends Option<String> {

    private String[] list;
    
    public SelectOption() {
        super();
        hasArgument(true);
    }

    public SelectOption(String longName, String shortName) {
        super(longName, shortName);
        hasArgument(true);
    }

    public void setList(String[] list) {
        this.list = list;
    }

    public String getListAsString() {
        String buffer = "";
        
        for (int i = 0; i<list.length; i++) {

            buffer += list[i];
            
            if (i < list.length-1)
                buffer += ", ";
        }
        
        return buffer;
    }


    protected boolean checkArgument(String arg) {

        for (int i = 0; i<list.length; i++) {

            if (arg.equals(list[i]))
                return true;

        } // end of for ()

        return false;
    }

	@Override
	public void addValueFromString(String value) {
		addValue(value);
	}

	@Override
	public void setValueFromString(String value) {
		setValue(value);
	}

	@Override
	public OptionType getType() {
		return OptionType.TEXT;
	}
    
}
