/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet;

/**
 * Diese Ausnahme signalisiert den gewünschten Abbruch einer Aktion,
 * beispielsweise aus einer Fortschrittsanzeige heraus. Die Ausnahme kann aus
 * tief verschachtelten Strukturen heraus geworfen werden. Da es eine
 * <code>RuntimeException</code> ist, muß sie nicht in der Methodesignatur
 * aufgeführt werden.
 * 
 * @author Michael Fuchs
 */
public class CanceledException extends RuntimeException {

    private static final long serialVersionUID = 1L;

    public CanceledException() {
        super();
    }

    public CanceledException(String msg) {
        super(msg);
    }

    public CanceledException(Throwable cause) {
        super(cause);
    }

    public CanceledException(String message, Throwable cause) {
        super(message, cause);
    }
}
