/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.xiphias.dom;

import org.dbdoclet.log.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;


public class TextImpl extends CharacterDataImpl implements Text {

    private static Logger logger = Logger.getLogger(TextImpl.class);

    public TextImpl(String text, NodeImpl parent) {

        super();

        setNodeType(TEXT_NODE);
        setNodeName("#text");
        setParentNode(parent);
        setData(text);

        logger.debug("Text text=[" + text + "]");
    }

    public TextImpl(String text) {
        this(text, null);
    }

    /**
     * The method <code>toString</code> returns the first 24
     * characters of the text of this node.
     *
     * If the length of the text is greater than 24 characters, the
     * text is truncated and three digits are appended.
     *
     * @return a <code>String</code> value
     */
    @Override
    public String toString() {

        String data = getData();
        
        if ((data == null) || (data.length() == 0)) {
            return "";
        }

        if (data.length() < 24) {
            return data.trim();
        } else {
            return data.substring(0, 23) + "...";
        }
    }

    public String getWholeText() {
        // TODO Auto-generated method stub
        return null;
    }

    public boolean isElementContentWhitespace() {
        // TODO Auto-generated method stub
        return false;
    }

    public Text replaceWholeText(String content) throws DOMException {
        // TODO Auto-generated method stub
        return null;
    }

    public Text splitText(int offset) throws DOMException {
        // TODO Auto-generated method stub
        return null;
    }

}
/*
 * $Log$
 */
