/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.xiphias.dom;

import java.util.ArrayList;
import java.util.Iterator;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeListImpl extends ArrayList<NodeImpl> implements NodeList {

	private static final long serialVersionUID = 1L;

	public int getLength() {
		return size();
	}

	public Node item(int index) {

		if ((index < 0) || (index >= size())) {
			return null;
		}

		Object obj = get(index);

		if (obj instanceof Node) {
			return (Node) obj;
		} else {
			throw new IllegalStateException(
					"Object in NodeList is not of type Node but of type " + obj);
		}
	}

	@Override
	public Iterator<NodeImpl> iterator() {

		Iterator<NodeImpl> iterator = super.iterator();
		return iterator;
	}
}
