/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.xiphias.dom;

import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentImpl extends NodeImpl implements Document {

	private String xmlEncoding = "UTF-8";
	private String xmlVersion = "1.0";
	private ElementImpl documentElement;
	private DocumentType docType;

	public DocumentImpl() {

		super("#document", null);
		setNodeType(DOCUMENT_NODE);

		setXmlEncoding("UTF-8");
		setXmlVersion("1.0");
	}

	public Node adoptNode(Node source) throws DOMException {
		throw new IllegalStateException("Not yet implemented");
	}

	public Attr createAttribute(String name) throws DOMException {
		throw new IllegalStateException("Not yet implemented");
	}

	public Attr createAttributeNS(String namespaceURI, String qualifiedName)
			throws DOMException {
		throw new IllegalStateException("Not yet implemented");
	}

	public CDATASection createCDATASection(String data) throws DOMException {
		throw new IllegalStateException("Not yet implemented");
	}

	public Comment createComment(String data) {
		throw new IllegalStateException("Not yet implemented");
	}

	public DocumentFragment createDocumentFragment() {
		throw new IllegalStateException("Not yet implemented");
	}

	public ElementImpl createElement(String tagName) throws DOMException {

		ElementImpl elem = new ElementImpl(tagName);
		elem.setDocument(this);
		elem.setFormatType(FORMAT_BLOCK);
		return elem;
	}

	public Element createElementNS(String namespaceURI, String qualifiedName)
			throws DOMException {
		throw new IllegalStateException("Not yet implemented");
	}

	public EntityReference createEntityReference(String name)
			throws DOMException {
		throw new IllegalStateException("Not yet implemented");
	}

	public ProcessingInstruction createProcessingInstruction(String target,
			String data) throws DOMException {
		throw new IllegalStateException("Not yet implemented");
	}

	public Text createTextNode(String data) {

		TextImpl text = new TextImpl(data);
		return text;
	}

	public String createXmlDeclaration() {
		return "<?xml version=\"" + xmlVersion + "\" encoding=\"" + xmlEncoding
				+ "\"?>\n";
	}

	public DocumentType getDoctype() {
		return docType;
	}

	public ElementImpl getDocumentElement() {
		return documentElement;
	}

	public String getDocumentURI() {
		throw new IllegalStateException("Not yet implemented");
	}

	public DOMConfiguration getDomConfig() {
		throw new IllegalStateException("Not yet implemented");
	}

	public Element getElementById(String elementId) {
		throw new IllegalStateException("Not yet implemented");
	}

	public NodeList getElementsByTagName(String tagname) {
		throw new IllegalStateException("Not yet implemented");
	}

	public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
		throw new IllegalStateException("Not yet implemented");
	}

	public DOMImplementation getImplementation() {
		throw new IllegalStateException("Not yet implemented");
	}

	public String getInputEncoding() {
		throw new IllegalStateException("Not yet implemented");
	}

	public boolean getStrictErrorChecking() {
		throw new IllegalStateException("Not yet implemented");
	}

	public String getXmlEncoding() {
		return xmlEncoding;
	}

	public boolean getXmlStandalone() {
		throw new IllegalStateException("Not yet implemented");
	}

	public String getXmlVersion() {
		return xmlVersion;
	}

	public Node importNode(Node importedNode, boolean deep) throws DOMException {
		throw new IllegalStateException("Not yet implemented");
	}

	public void normalizeDocument() {
		throw new IllegalStateException("Not yet implemented");

	}

	public Node renameNode(Node n, String namespaceURI, String qualifiedName)
			throws DOMException {
		throw new IllegalStateException("Not yet implemented");
	}

	public void setDocumentElement(ElementImpl documentElement) {
		this.documentElement = documentElement;
	}

	public void setDoctype(DocumentType docType) {
		this.docType = docType;
	}

	public void setDocumentURI(String documentURI) {
		throw new IllegalStateException("Not yet implemented");

	}

	public void setStrictErrorChecking(boolean strictErrorChecking) {
		throw new IllegalStateException("Not yet implemented");

	}

	public void setXmlEncoding(String xmlEncoding) {
		this.xmlEncoding = xmlEncoding;
	}

	public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
		throw new IllegalStateException("Not yet implemented");

	}

	public void setXmlVersion(String xmlVersion) throws DOMException {
		this.xmlVersion = xmlVersion;

	}
}
