/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.tag.html;

import java.util.HashMap;

public abstract class StrictElement extends HtmlElement {

    @Override
	protected boolean validate(HashMap<String, HashMap<String, String>> validParentMap) {

	if (validParentMap == null) {
	    throw new IllegalArgumentException("Parameter validParentMap is null!");
	}

	if (getParentNode() == null) {
	    throw new NullPointerException("Variable getParent() is null!");
	}

	if (nodeStack == null) {
	    throw new NullPointerException("Variable nodeStack is null!");
	}

	nodeStack.removeAllElements();
	nodeStack.push(this);

	if (validParentMap.get(getParentNode().getNodeName()) != null) {
	    return true;
	}

	return false;
    }
}
