/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.tag.html;

import java.util.HashMap;

import org.dbdoclet.xiphias.dom.DocumentFragmentImpl;
import org.dbdoclet.xiphias.dom.NodeImpl;

public class Select extends InlineElement {

    private static String tag = "select";
    private static HashMap<String, HashMap<String, String>> validParentMap;
    static {

	validParentMap = new HashMap<String, HashMap<String, String>>();
	validParentMap.putAll(blockElementMap);
	validParentMap.putAll(inlineElementMap);
	validParentMap.remove(Button.getTag());
    }

    public static String getTag() {

	return tag;
    }

    public Select() {

	setNodeName(tag);
	setFormatType(FORMAT_BLOCK);
    }

    @Override
	public void closed() {

	boolean hasOptions = false;

	if (hasChildNodes() == true && getNumberOfChildNodes() > 0) {

	    for (NodeImpl node : getTrafoChildNodes()) {

		if (node instanceof HtmlElement) {

		    HtmlElement elem = (HtmlElement) node;

		    if (elem instanceof Option) {
			hasOptions = true;
		    }
		}
	    }
	}

	if (hasOptions == false) {
	    appendChild(new Option());
	}
    }

    @Override
	public void init() {

    }

    @Override
	public boolean validate() {

	if (validate(validParentMap)) {

	    return true;
	}

	if (getParentNode() instanceof DocumentFragmentImpl) {

	    Div div = new Div();
	    div.appendChild(this);

	    nodeStack.push(div);

	    return true;
	}

	return false;
    }
}
