/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.tag.docbook;

import java.util.HashMap;

import org.dbdoclet.xiphias.XmlServices;

public class Title extends DocBookElement {

    private static final String tag = "title";

    private static final HashMap<String, HashMap<String, Object>> invalidParentMap;

    static {

	invalidParentMap = new HashMap<String, HashMap<String, Object>>();
        invalidParentMap.put(InformalExample.getTag(), InformalExample.getAttributeMap());
	invalidParentMap.put(InformalFigure.getTag(), InformalFigure.getAttributeMap());
	invalidParentMap.put(InformalTable.getTag(), InformalTable.getAttributeMap());
	invalidParentMap.put(Para.getTag(), Para.getAttributeMap());
    }

    public static HashMap<String, Object> getAttributeMap() {
	return new HashMap<String, Object>();
    }

    public static String getTag() {
	return tag;
    }

    Title() {

	super(tag);
    }

    Title(String title) {

	super(tag);

	if (title != null) {
	    appendChild(XmlServices.textToXml(title));
	}
    }

    @Override
    public boolean validate() {
	return validate(invalidParentMap);
    }
}
