/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.tag.docbook;

import org.dbdoclet.xiphias.dom.ElementImpl;


public class Telem extends DocBookElement {

    Telem(String name) {
        super(name);
    }

    public DocBookElement addRow(DocBookElement elem) {

        elem.setFormatType(ElementImpl.FORMAT_INLINE);
        appendChild(new Row().appendChild(new Entry().appendChild(elem)));

        return this;
    }

    public DocBookElement addRow(Entry entry) {

        appendChild(new Row().appendChild(entry));

        return this;
    }

    public DocBookElement addRow(String str1) {

        appendChild(new Row().appendChild(new Entry().appendChild(
								  new Para(str1).setFormatType(ElementImpl.FORMAT_INLINE))));

        return this;
    }

    public DocBookElement addRow(String str1, String str2) {

        appendChild(new Row().appendChild(new Entry().appendChild(
								  new Para(str1).setFormatType(ElementImpl.FORMAT_INLINE)))
		    .appendChild(new Entry().appendChild(
							 new Para(str2).setFormatType(ElementImpl.FORMAT_INLINE))));

        return this;
    }

    public DocBookElement addRow(String str1, String str2, String str3) {

        appendChild(new Row().appendChild(new Entry().appendChild(
								  new Para(str1).setFormatType(ElementImpl.FORMAT_INLINE)))
		    .appendChild(new Entry().appendChild(
							 new Para(str2).setFormatType(ElementImpl.FORMAT_INLINE)))
		    .appendChild(new Entry().appendChild(
							 new Para(str3).setFormatType(ElementImpl.FORMAT_INLINE))));

        return this;
    }
}
