/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.tag.docbook;

import org.dbdoclet.xiphias.dom.CommentImpl;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.dbdoclet.xiphias.dom.TextImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SectionElement extends DocBookElement {

	SectionElement(String name) {
		super(name);
	}

	public SectionElement getFirstSectionChild() {

		NodeList children = getChildNodes();
		int length = children.getLength();

		for (int i = 0; i < length; i++) {

			Node node = children.item(i);

			if (node != null && node instanceof SectionElement) {
				return (SectionElement) node;
			}
		}

		return null;
	}

	SectionElement getLastSectionChild() {

		NodeList children = getChildNodes();
		int length = children.getLength();

		SectionElement sectionChild = null;

		for (int i = 0; i < length; i++) {

			Node node = children.item(i);

			if (node != null && node instanceof SectionElement) {
				sectionChild = (SectionElement) node;
			}
		}

		return sectionChild;
	}

	public String getTitle() {

		ElementImpl titleElement = (ElementImpl) findChildElement("title");

		if (titleElement != null) {
			return titleElement.getTextContent();
		}
		
		return "";
	}

	public void setTitle(String title) {

		ElementImpl titleElement = (ElementImpl) findChildElement("title");

		if (titleElement != null) {
			titleElement.setTextContent(title);
		}
	}

	public boolean hasContentChildren() {

		NodeList children = getChildNodes();

		int counter = 0;
		int length = children.getLength();

		for (int i = 0; i < length; i++) {

			Node node = children.item(i);

			if (node != null && node instanceof ElementImpl) {

				if (node instanceof Title || node instanceof IndexTerm
						|| node instanceof CommentImpl) {
					continue;
				}

				if (node instanceof TextImpl) {

					TextImpl text = (TextImpl) node;
					String buffer = text.getData();

					if ((buffer == null) || (buffer.trim().length() == 0)) {
						continue;
					}
				}

				if (node instanceof Para) {

					if (node.hasChildNodes() == false) {
						continue;
					}
				}

				counter++;
			}
		}

		if (counter > 0) {
			return true;
		} else {
			return false;
		}
	}

	public boolean hasSectionChildren() {

		NodeList children = getChildNodes();

		int length = children.getLength();

		for (int i = 0; i < length; i++) {

			Node node = children.item(i);

			if (node != null && node instanceof DocBookElement) {

				DocBookElement elem = (DocBookElement) node;

				if (elem.isSection()) {
					return true;
				}
			}
		}

		return false;
	}
	
}
