/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.tag.docbook;



public class ProgramListing extends DocBookElement {

    private static final String tag = "programlisting";

    ProgramListing() {

        super(tag);

        setFormatType(FORMAT_CONTENT);
        isLiteral(true);
    }

    ProgramListing(String text) {
        this();

        appendChild(text);
    }

    ProgramListing setWidth(int width) {

        setAttribute("width", new Integer(width));

        return this;
    }

    public static String getTag() {

        return tag;
    }

    public void setLinenumberingEnabled(boolean linenumbering) {

        if (linenumbering == true) {
            setAttribute("linenumbering", "numbered");
        } else {
            setAttribute("linenumbering", "unnumbered");
        }
    }
}
