/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.tag.docbook;

import java.util.HashMap;

public class Markup extends DocBookElement {

    private static String tag = "markup";
    private static HashMap<String, HashMap<String, Object>> invalidParentMap;

    static {

        invalidParentMap = new HashMap<String, HashMap<String, Object>>();
        invalidParentMap.put(Address.getTag(), Address.getAttributeMap());
        invalidParentMap.put(Article.getTag(), Article.getAttributeMap());
        invalidParentMap.put(BlockQuote.getTag(), BlockQuote.getAttributeMap());
        invalidParentMap.put(Book.getTag(), Book.getAttributeMap());
        invalidParentMap.put(Chapter.getTag(), Chapter.getAttributeMap());
        invalidParentMap.put(ListItem.getTag(), ListItem.getAttributeMap());
        invalidParentMap.put(Sect1.getTag(), Sect1.getAttributeMap());
        invalidParentMap.put(Sect2.getTag(), Sect2.getAttributeMap());
        invalidParentMap.put(Sect3.getTag(), Sect3.getAttributeMap());
        invalidParentMap.put(Sect4.getTag(), Sect4.getAttributeMap());
        invalidParentMap.put(Sect5.getTag(), Sect5.getAttributeMap());
        invalidParentMap.put(Section.getTag(), Section.getAttributeMap());
        invalidParentMap.put(SimpleSect.getTag(), SimpleSect.getAttributeMap());
        invalidParentMap.put(Subscript.getTag(), Subscript.getAttributeMap());
        invalidParentMap.put(Superscript.getTag(), Superscript.getAttributeMap());
    }

    Markup() {

	super(tag);
        setFormatType(FORMAT_INLINE);
    }

    Markup(String text) {

	super(tag);
        appendChild(text);
        setFormatType(FORMAT_INLINE);
    }

    Markup(String text, String role) {

	super(tag);
        appendChild(text);
        setAttribute("role", role);
        setFormatType(FORMAT_INLINE);
    }

    Markup(DocBookElement elem) {

	super(tag);
        appendChild(elem);
        setFormatType(FORMAT_INLINE);
    }

    public static String getTag() {
        return tag;
    }

    @Override
    public boolean validate() {
        return validate(invalidParentMap);
    }

    @Override
    public boolean isValidParent(DocBookElement elem) {

        if (elem == null) {
            throw new IllegalArgumentException("Parameter elem is null!");
        }

        if (invalidParentMap.get(elem.getNodeName()) != null) {
            return false;
        }

        return true;
    }
}
