/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.tag.docbook;

import java.util.HashMap;

import org.dbdoclet.xiphias.XmlServices;

public class Link extends DocBookElement {

    private static final HashMap<String, HashMap<String, Object>> invalidParentMap;

    static {

	invalidParentMap = new HashMap<String, HashMap<String, Object>>();
	invalidParentMap.put(Address.getTag(), Address.getAttributeMap());
    }

    Link() {
	super("link");
    }

    Link(DocBookElement label, String linkend) {

	this(linkend);
	appendChild(label);
    }

    Link(String linkend) {

	this();

	setAttribute("linkend", hardenId(linkend));
	setFormatType(FORMAT_INLINE);
    }

    Link(String label, String linkend) {

	this(linkend);
	appendChild(XmlServices.textToXml(label));
    }

    public void setHref(String href) {

	if (isDocBook5() == true) {
	    setAttribute("xl:href", href);
	} else {
	    setAttribute("linkend", href);
	}
    }

    @Override
    public boolean validate() {
	return validate(invalidParentMap);
    }
}
