/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.html.docbook.editor.javadoc;

import org.dbdoclet.trafo.html.docbook.editor.Editor;
import org.dbdoclet.trafo.html.docbook.editor.EditorInstruction;

/**
 * The class <code>CodeEditor</code> is reponsible for transforming @literal
 * tags into DocBook code.
 * 
 * @author <a href="mailto:michael.fuchs@unico-group.com">Michael Fuchs</a>
 * @version $Revision$
 */
public class LiteralEditor extends Editor {

    @Override
    public EditorInstruction edit(EditorInstruction values) {

	setValues(values);

	org.dbdoclet.trafo.tag.javadoc.Literal literal = (org.dbdoclet.trafo.tag.javadoc.Literal) getHtmlElement();
	getCurrent().appendChild(literal.getTextContent());

	traverse(false);

	return finalizeValues();
    }
}
