/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.html.docbook.editor.javadoc;

import org.dbdoclet.log.Logger;
import org.dbdoclet.trafo.html.docbook.editor.Editor;
import org.dbdoclet.trafo.html.docbook.editor.EditorInstruction;
import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;
import org.dbdoclet.trafo.tag.docbook.Emphasis;
import org.dbdoclet.trafo.tag.docbook.Link;
import org.dbdoclet.trafo.tag.docbook.XRef;
import org.dbdoclet.trafo.tag.javadoc.Linkplain;

public class LinkplainEditor extends Editor {

    private static Logger logger = Logger.getLogger(LinkplainEditor.class);

    @Override
    public EditorInstruction edit(EditorInstruction values) {

	setValues(values);
	DocBookTagFactory dbfactory = values.getTagFactory();

	Linkplain linkplain = (Linkplain) getHtmlElement();

	String ref = linkplain.getRef();
	logger.debug("ref=" + ref);

	if ((ref != null) && (ref.length() > 0)) {

	    String label = linkplain.getTextContent();

	    if ((label != null) && (label.length() > 0)) {

		Link elem = dbfactory.createLink(label, ref);
		setCurrent(elem);

	    } else {

		XRef elem = dbfactory.createXRef(ref);
		setCurrent(elem);
	    }

	} else {

	    Emphasis elem = dbfactory.createEmphasis(linkplain.getName());
	    setCurrent(elem);
	}

	getParent().appendChild(getCurrent());

	traverse(false);

	return finalizeValues();
    }
}